/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.FarmlandWaterManager;
import net.neoforged.neoforge.common.util.TriState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FarmlandBlock
extends FarmBlock {
    public FarmlandBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.MOISTURE, (Comparable)Integer.valueOf(0)));
    }

    public boolean isNearWater(LevelReader pLevel, BlockPos pPos) {
        for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)pPos.offset(-4, 0, -4), (BlockPos)pPos.offset(4, 1, 4))) {
            if (!pLevel.getFluidState(blockPos).is(FluidTags.WATER)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)pLevel, (BlockPos)pPos);
    }

    public boolean shouldMaintainFarmland(BlockGetter pLevel, BlockPos pPos) {
        return pLevel.getBlockState(pPos.above()).is(BlockTags.MAINTAINS_FARMLAND);
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.MOISTURE});
    }

    public void fallOn(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        pEntity.causeFallDamage(pFallDistance, 1.0f, pEntity.damageSources().fall());
        if (!pLevel.isClientSide() && CommonHooks.onFarmlandTrample((Level)pLevel, (BlockPos)pPos, (BlockState)IcariaBlocks.MARL.get().defaultBlockState(), (float)pFallDistance, (Entity)pEntity)) {
            this.turnToMarl(pState, pLevel, pPos);
        }
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        int i = (Integer)pState.getValue((Property)BlockStateProperties.MOISTURE);
        if (!this.isNearWater((LevelReader)pLevel, pPos) && !pLevel.isRainingAt(pPos.above())) {
            if (i > 0) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)BlockStateProperties.MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!this.shouldMaintainFarmland((BlockGetter)pLevel, pPos)) {
                this.turnToMarl(pState, (Level)pLevel, pPos);
            }
        } else if (i < 7) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)BlockStateProperties.MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pState.canSurvive((LevelReader)pLevel, pPos)) {
            this.turnToMarl(pState, (Level)pLevel, pPos);
        }
    }

    public void turnToMarl(BlockState pState, Level pLevel, BlockPos pPos) {
        pLevel.setBlockAndUpdate(pPos, Block.pushEntitiesUp((BlockState)pState, (BlockState)IcariaBlocks.MARL.get().defaultBlockState(), (LevelAccessor)pLevel, (BlockPos)pPos));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return !this.defaultBlockState().canSurvive((LevelReader)pContext.getLevel(), pContext.getClickedPos()) ? IcariaBlocks.MARL.get().defaultBlockState() : super.getStateForPlacement(pContext);
    }

    public ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pResult) {
        if (pStack.is(IcariaItems.CALCITE_DUST.get()) && (Integer)pState.getValue((Property)BlockStateProperties.MOISTURE) == 7) {
            pLevel.playSound(null, pPos, IcariaSoundEvents.CALCITE_FERTILIZE, SoundSource.BLOCKS);
            if (!pLevel.isClientSide()) {
                pLevel.setBlock(pPos, IcariaBlocks.FERTILIZED_FARMLAND.get().defaultBlockState(), 2);
                pPlayer.awardStat(Stats.ITEM_USED.get((Object)IcariaItems.CALCITE_DUST.get()));
                if (!pPlayer.isCreative()) {
                    pStack.shrink(1);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    public TriState canSustainPlant(BlockState pState, BlockGetter pLevel, BlockPos pPos, Direction pDirection, BlockState pPlant) {
        return pPlant.is(BlockTags.MAINTAINS_FARMLAND) ? TriState.TRUE : TriState.DEFAULT;
    }
}

