/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.config.IcariaConfig;
import com.axanthic.icaria.common.entity.ForgeBlockEntity;
import com.axanthic.icaria.common.entity.ForgeRedirectorBlockEntity;
import com.axanthic.icaria.common.menu.provider.ForgeMenuProvider;
import com.axanthic.icaria.common.properties.Corner;
import com.axanthic.icaria.common.registry.IcariaBlockEntityTypes;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.registry.IcariaShapes;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ForgeBlock
extends BaseEntityBlock {
    public static final MapCodec<ForgeBlock> CODEC = Block.simpleCodec(ForgeBlock::new);

    public ForgeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(IcariaBlockStateProperties.CORNER, (Comparable)((Object)Corner.BOTTOM_FRONT_LEFT))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canDropFromExplosion(BlockState pState, BlockGetter pLevel, BlockPos pPos, Explosion pExplosion) {
        return false;
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public double getFlameX(BlockState pState) {
        return switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case Direction.NORTH -> 0.0;
            case Direction.EAST, Direction.WEST -> 0.5;
            default -> 1.0;
        };
    }

    public double getFlameZ(BlockState pState) {
        return switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case Direction.NORTH, Direction.SOUTH -> 0.5;
            case Direction.EAST -> 0.0;
            default -> 1.0;
        };
    }

    public double getLavaX(BlockState pState) {
        return switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case Direction.NORTH -> -0.5625;
            case Direction.EAST -> 0.3125;
            case Direction.SOUTH -> 1.5625;
            default -> 0.6875;
        };
    }

    public double getLavaZ(BlockState pState) {
        return switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case Direction.NORTH -> 0.6875;
            case Direction.EAST -> -0.5625;
            case Direction.SOUTH -> 0.3125;
            default -> 1.5625;
        };
    }

    public double getSmokeX(BlockState pState) {
        return switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case Direction.NORTH, Direction.EAST -> 0.0;
            default -> 1.0;
        };
    }

    public double getSmokeZ(BlockState pState) {
        return switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case Direction.EAST, Direction.SOUTH -> 0.0;
            default -> 1.0;
        };
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        int n;
        BlockEntity blockEntity = pLevel.getBlockEntity(ForgeBlock.getBlockEntityPosition(pState, pPos));
        if (blockEntity instanceof ForgeBlockEntity) {
            ForgeBlockEntity blockEntity2 = (ForgeBlockEntity)blockEntity;
            n = blockEntity2.getComparatorInput();
        } else {
            n = 0;
        }
        return n;
    }

    public int getLightEmission(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return (Boolean)pState.getValue((Property)BlockStateProperties.LIT) != false ? 13 : 0;
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.getValue((Property)BlockStateProperties.LIT)).booleanValue() && pState.getValue(IcariaBlockStateProperties.CORNER) == Corner.BOTTOM_FRONT_LEFT) {
            pLevel.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pPos.getX() + this.getSmokeX(pState) + pRandom.nextDouble() / 8.0 * (double)(pRandom.nextBoolean() ? 1 : -1), (double)pPos.getY() + 2.0, (double)pPos.getZ() + this.getSmokeZ(pState) + pRandom.nextDouble() / 8.0 * (double)(pRandom.nextBoolean() ? 1 : -1), 0.0, 0.0, 0.0);
            pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pPos.getX() + this.getSmokeX(pState) + pRandom.nextDouble() / 8.0 * (double)(pRandom.nextBoolean() ? 1 : -1), (double)pPos.getY() + 2.0, (double)pPos.getZ() + this.getSmokeZ(pState) + pRandom.nextDouble() / 8.0 * (double)(pRandom.nextBoolean() ? 1 : -1), 0.0, 0.0, 0.0);
            if (((Boolean)IcariaConfig.RENDER_FORGE_ITEMS.get()).booleanValue()) {
                pLevel.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pPos.getX() + this.getFlameX(pState) + pRandom.nextDouble() / 4.0 * (double)(pRandom.nextBoolean() ? 1 : -1), (double)pPos.getY() + 0.25, (double)pPos.getZ() + this.getFlameZ(pState) + pRandom.nextDouble() / 4.0 * (double)(pRandom.nextBoolean() ? 1 : -1), 0.0, 0.0, 0.0);
                pLevel.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, (double)pPos.getX() + this.getFlameX(pState) + pRandom.nextDouble() / 4.0 * (double)(pRandom.nextBoolean() ? 1 : -1), (double)pPos.getY() + 0.25, (double)pPos.getZ() + this.getFlameZ(pState) + pRandom.nextDouble() / 4.0 * (double)(pRandom.nextBoolean() ? 1 : -1), 0.0, 0.0, 0.0);
            }
            if (pRandom.nextDouble() < 0.1) {
                pLevel.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)pPos.getX() + this.getLavaX(pState), (double)pPos.getY() + 0.8125, (double)pPos.getZ() + this.getLavaZ(pState), 0.0, 0.0, 0.0);
                if (((Boolean)IcariaConfig.FORGE_SOUNDS.get()).booleanValue()) {
                    pLevel.playLocalSound((double)pPos.getX() + this.getFlameX(pState), (double)pPos.getY() + 1.0, (double)pPos.getZ() + this.getFlameZ(pState), SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
            }
        }
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{IcariaBlockStateProperties.CORNER, BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.LIT});
    }

    public void onBlockExploded(BlockState pState, Level pLevel, BlockPos pPos, Explosion pExplosion) {
        BlockPos blockPos = ForgeBlock.getBlockEntityPosition(pState, pPos);
        Direction facing = (Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (pLevel.getBlockEntity(blockPos) instanceof ForgeBlockEntity) {
            pLevel.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
        }
        if (pLevel.getBlockEntity(ForgeBlock.getBlockEntityPosition(pState, blockPos)) == null) {
            pLevel.setBlock(blockPos.offset(facing.getCounterClockWise().getNormal()), Blocks.AIR.defaultBlockState(), 3);
            pLevel.setBlock(blockPos.offset(facing.getOpposite().getNormal()), Blocks.AIR.defaultBlockState(), 3);
            pLevel.setBlock(blockPos.offset(facing.getOpposite().getNormal()).offset(facing.getCounterClockWise().getNormal()), Blocks.AIR.defaultBlockState(), 3);
            pLevel.setBlock(blockPos.above(), Blocks.AIR.defaultBlockState(), 3);
            pLevel.setBlock(blockPos.above().offset(facing.getCounterClockWise().getNormal()), Blocks.AIR.defaultBlockState(), 3);
            pLevel.setBlock(blockPos.above().offset(facing.getOpposite().getNormal()), Blocks.AIR.defaultBlockState(), 3);
            pLevel.setBlock(blockPos.above().offset(facing.getOpposite().getNormal()).offset(facing.getCounterClockWise().getNormal()), Blocks.AIR.defaultBlockState(), 3);
        }
        super.onBlockExploded(pState, pLevel, pPos, pExplosion);
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        BlockEntity blockEntity;
        if (pState.getBlock() != pNewState.getBlock() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof ForgeBlockEntity) {
            ForgeBlockEntity blockEntity2 = (ForgeBlockEntity)blockEntity;
            if (pLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pLevel;
                blockEntity2.drops((Level)serverLevel);
                blockEntity2.getRecipesToAwardAndPopExperience(serverLevel, Vec3.atCenterOf((Vec3i)pPos));
                Block.popResource((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)IcariaItems.FORGE.get()));
            }
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        Direction facing = (Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        pLevel.setBlock(pPos.offset(facing.getCounterClockWise().getNormal()), (BlockState)pState.setValue(IcariaBlockStateProperties.CORNER, (Comparable)((Object)Corner.BOTTOM_FRONT_RIGHT)), 3);
        pLevel.setBlock(pPos.offset(facing.getOpposite().getNormal()), (BlockState)pState.setValue(IcariaBlockStateProperties.CORNER, (Comparable)((Object)Corner.BOTTOM_BACK_LEFT)), 3);
        pLevel.setBlock(pPos.offset(facing.getOpposite().getNormal()).offset(facing.getCounterClockWise().getNormal()), (BlockState)pState.setValue(IcariaBlockStateProperties.CORNER, (Comparable)((Object)Corner.BOTTOM_BACK_RIGHT)), 3);
        pLevel.setBlock(pPos.above(), (BlockState)pState.setValue(IcariaBlockStateProperties.CORNER, (Comparable)((Object)Corner.TOP_FRONT_LEFT)), 3);
        pLevel.setBlock(pPos.above().offset(facing.getCounterClockWise().getNormal()), (BlockState)pState.setValue(IcariaBlockStateProperties.CORNER, (Comparable)((Object)Corner.TOP_FRONT_RIGHT)), 3);
        pLevel.setBlock(pPos.above().offset(facing.getOpposite().getNormal()), (BlockState)pState.setValue(IcariaBlockStateProperties.CORNER, (Comparable)((Object)Corner.TOP_BACK_LEFT)), 3);
        pLevel.setBlock(pPos.above().offset(facing.getOpposite().getNormal()).offset(facing.getCounterClockWise().getNormal()), (BlockState)pState.setValue(IcariaBlockStateProperties.CORNER, (Comparable)((Object)Corner.TOP_BACK_RIGHT)), 3);
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        if (pState.getValue(IcariaBlockStateProperties.CORNER) == Corner.BOTTOM_FRONT_LEFT) {
            return new ForgeBlockEntity(pPos, pState);
        }
        return new ForgeRedirectorBlockEntity(pPos, pState);
    }

    public static BlockPos getBlockEntityPosition(BlockState pState, BlockPos pPos) {
        Direction facing = (Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (pState.getValue(IcariaBlockStateProperties.CORNER) == Corner.TOP_BACK_RIGHT) {
            return pPos.below().offset(facing.getNormal()).offset(facing.getClockWise().getNormal());
        }
        if (pState.getValue(IcariaBlockStateProperties.CORNER) == Corner.TOP_BACK_LEFT) {
            return pPos.below().offset(facing.getNormal());
        }
        if (pState.getValue(IcariaBlockStateProperties.CORNER) == Corner.TOP_FRONT_RIGHT) {
            return pPos.below().offset(facing.getClockWise().getNormal());
        }
        if (pState.getValue(IcariaBlockStateProperties.CORNER) == Corner.TOP_FRONT_LEFT) {
            return pPos.below();
        }
        if (pState.getValue(IcariaBlockStateProperties.CORNER) == Corner.BOTTOM_BACK_RIGHT) {
            return pPos.offset(facing.getNormal()).offset(facing.getClockWise().getNormal());
        }
        if (pState.getValue(IcariaBlockStateProperties.CORNER) == Corner.BOTTOM_BACK_LEFT) {
            return pPos.offset(facing.getNormal());
        }
        if (pState.getValue(IcariaBlockStateProperties.CORNER) == Corner.BOTTOM_FRONT_RIGHT) {
            return pPos.offset(facing.getClockWise().getNormal());
        }
        return pPos;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockPos blockPos = pContext.getClickedPos();
        Direction facing = pContext.getHorizontalDirection().getOpposite();
        Level level = pContext.getLevel();
        if (blockPos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(blockPos.offset(facing.getCounterClockWise().getNormal())).canBeReplaced(pContext) && level.getBlockState(blockPos.offset(facing.getOpposite().getNormal())).canBeReplaced(pContext) && level.getBlockState(blockPos.offset(facing.getOpposite().getNormal()).offset(facing.getCounterClockWise().getNormal())).canBeReplaced(pContext) && level.getBlockState(blockPos.above()).canBeReplaced(pContext) && level.getBlockState(blockPos.above().offset(facing.getCounterClockWise().getNormal())).canBeReplaced(pContext) && level.getBlockState(blockPos.above().offset(facing.getOpposite().getNormal())).canBeReplaced(pContext) && level.getBlockState(blockPos.above().offset(facing.getOpposite().getNormal()).offset(facing.getCounterClockWise().getNormal())).canBeReplaced(pContext)) {
            return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
        }
        return null;
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        BlockState state = (BlockState)pState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pMirror.mirror((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        return pMirror == Mirror.NONE ? state : (BlockState)state.setValue(IcariaBlockStateProperties.CORNER, (Comparable)((Object)((Corner)((Object)state.getValue(IcariaBlockStateProperties.CORNER))).getOpposite()));
    }

    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockPos blockPos = ForgeBlock.getBlockEntityPosition(pState, pPos);
        Direction facing = (Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (pLevel.getBlockEntity(blockPos) instanceof ForgeBlockEntity) {
            pLevel.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
        }
        if (pLevel.getBlockEntity(ForgeBlock.getBlockEntityPosition(pState, blockPos)) == null) {
            pLevel.setBlock(blockPos.offset(facing.getCounterClockWise().getNormal()), Blocks.AIR.defaultBlockState(), 3);
            pLevel.setBlock(blockPos.offset(facing.getOpposite().getNormal()), Blocks.AIR.defaultBlockState(), 3);
            pLevel.setBlock(blockPos.offset(facing.getOpposite().getNormal()).offset(facing.getCounterClockWise().getNormal()), Blocks.AIR.defaultBlockState(), 3);
            pLevel.setBlock(blockPos.above(), Blocks.AIR.defaultBlockState(), 3);
            pLevel.setBlock(blockPos.above().offset(facing.getCounterClockWise().getNormal()), Blocks.AIR.defaultBlockState(), 3);
            pLevel.setBlock(blockPos.above().offset(facing.getOpposite().getNormal()), Blocks.AIR.defaultBlockState(), 3);
            pLevel.setBlock(blockPos.above().offset(facing.getOpposite().getNormal()).offset(facing.getCounterClockWise().getNormal()), Blocks.AIR.defaultBlockState(), 3);
        }
        return super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pResult) {
        BlockPos blockEntityPosition = ForgeBlock.getBlockEntityPosition(pState, pPos);
        BlockEntity blockEntity = pLevel.getBlockEntity(blockEntityPosition);
        if (!pLevel.isClientSide() && pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            if (blockEntity instanceof ForgeBlockEntity || blockEntity instanceof ForgeRedirectorBlockEntity) {
                serverPlayer.openMenu((MenuProvider)new ForgeMenuProvider(blockEntityPosition), blockEntityPosition);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Corner)((Object)pState.getValue(IcariaBlockStateProperties.CORNER))) {
            default -> throw new MatchException(null, null);
            case Corner.BOTTOM_FRONT_LEFT -> {
                switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    case NORTH: {
                        yield IcariaShapes.ForgeShapes.BOTTOM_FRONT_LEFT_NORTH;
                    }
                    case EAST: {
                        yield IcariaShapes.ForgeShapes.BOTTOM_FRONT_LEFT_EAST;
                    }
                    case SOUTH: {
                        yield IcariaShapes.ForgeShapes.BOTTOM_FRONT_LEFT_SOUTH;
                    }
                }
                yield IcariaShapes.ForgeShapes.BOTTOM_FRONT_LEFT_WEST;
            }
            case Corner.BOTTOM_FRONT_RIGHT -> {
                switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    case NORTH: {
                        yield IcariaShapes.ForgeShapes.BOTTOM_FRONT_RIGHT_NORTH;
                    }
                    case EAST: {
                        yield IcariaShapes.ForgeShapes.BOTTOM_FRONT_RIGHT_EAST;
                    }
                    case SOUTH: {
                        yield IcariaShapes.ForgeShapes.BOTTOM_FRONT_RIGHT_SOUTH;
                    }
                }
                yield IcariaShapes.ForgeShapes.BOTTOM_FRONT_RIGHT_WEST;
            }
            case Corner.BOTTOM_BACK_LEFT -> {
                switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    case NORTH: {
                        yield IcariaShapes.ForgeShapes.BOTTOM_BACK_LEFT_NORTH;
                    }
                    case EAST: {
                        yield IcariaShapes.ForgeShapes.BOTTOM_BACK_LEFT_EAST;
                    }
                    case SOUTH: {
                        yield IcariaShapes.ForgeShapes.BOTTOM_BACK_LEFT_SOUTH;
                    }
                }
                yield IcariaShapes.ForgeShapes.BOTTOM_BACK_LEFT_WEST;
            }
            case Corner.BOTTOM_BACK_RIGHT -> {
                switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    case NORTH: {
                        yield IcariaShapes.ForgeShapes.BOTTOM_BACK_RIGHT_NORTH;
                    }
                    case EAST: {
                        yield IcariaShapes.ForgeShapes.BOTTOM_BACK_RIGHT_EAST;
                    }
                    case SOUTH: {
                        yield IcariaShapes.ForgeShapes.BOTTOM_BACK_RIGHT_SOUTH;
                    }
                }
                yield IcariaShapes.ForgeShapes.BOTTOM_BACK_RIGHT_WEST;
            }
            case Corner.TOP_FRONT_LEFT -> {
                switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    case NORTH: {
                        yield IcariaShapes.ForgeShapes.TOP_FRONT_LEFT_NORTH;
                    }
                    case EAST: {
                        yield IcariaShapes.ForgeShapes.TOP_FRONT_LEFT_EAST;
                    }
                    case SOUTH: {
                        yield IcariaShapes.ForgeShapes.TOP_FRONT_LEFT_SOUTH;
                    }
                }
                yield IcariaShapes.ForgeShapes.TOP_FRONT_LEFT_WEST;
            }
            case Corner.TOP_FRONT_RIGHT -> {
                switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    case NORTH: {
                        yield IcariaShapes.ForgeShapes.TOP_FRONT_RIGHT_NORTH;
                    }
                    case EAST: {
                        yield IcariaShapes.ForgeShapes.TOP_FRONT_RIGHT_EAST;
                    }
                    case SOUTH: {
                        yield IcariaShapes.ForgeShapes.TOP_FRONT_RIGHT_SOUTH;
                    }
                }
                yield IcariaShapes.ForgeShapes.TOP_FRONT_RIGHT_WEST;
            }
            case Corner.TOP_BACK_LEFT -> {
                switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    case NORTH: {
                        yield IcariaShapes.ForgeShapes.TOP_BACK_LEFT_NORTH;
                    }
                    case EAST: {
                        yield IcariaShapes.ForgeShapes.TOP_BACK_LEFT_EAST;
                    }
                    case SOUTH: {
                        yield IcariaShapes.ForgeShapes.TOP_BACK_LEFT_SOUTH;
                    }
                }
                yield IcariaShapes.ForgeShapes.TOP_BACK_LEFT_WEST;
            }
            case Corner.TOP_BACK_RIGHT -> {
                switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    case NORTH: {
                        yield IcariaShapes.ForgeShapes.TOP_BACK_RIGHT_NORTH;
                    }
                    case EAST: {
                        yield IcariaShapes.ForgeShapes.TOP_BACK_RIGHT_EAST;
                    }
                    case SOUTH: {
                        yield IcariaShapes.ForgeShapes.TOP_BACK_RIGHT_SOUTH;
                    }
                }
                yield IcariaShapes.ForgeShapes.TOP_BACK_RIGHT_WEST;
            }
        };
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return !pLevel.isClientSide() ? BaseEntityBlock.createTickerHelper(pBlockEntityType, IcariaBlockEntityTypes.FORGE.get(), ForgeBlockEntity::tick) : null;
    }
}

