/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.properties.Moss;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.registry.IcariaPlacedFeatures;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.lighting.BlockLightEngine;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GrassyMarlBlock
extends Block
implements BonemealableBlock {
    public GrassyMarlBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(IcariaBlockStateProperties.MOSS, (Comparable)((Object)Moss.NONE)));
    }

    public boolean canBeGrass(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos abovePos = pPos.above();
        BlockState aboveState = pLevel.getBlockState(abovePos);
        if (aboveState.is(IcariaBlocks.FOREST_MOSS.get()) || aboveState.is(IcariaBlocks.SCRUBLAND_MOSS.get()) || aboveState.is(IcariaBlocks.STEPPE_MOSS.get())) {
            return true;
        }
        if (aboveState.getFluidState().getAmount() == 8) {
            return false;
        }
        return BlockLightEngine.getLightBlockInto((BlockGetter)pLevel, (BlockState)pState, (BlockPos)pPos, (BlockState)aboveState, (BlockPos)abovePos, (Direction)Direction.UP, (int)aboveState.getLightBlock((BlockGetter)pLevel, abovePos)) < pLevel.getMaxLightLevel();
    }

    public boolean canPropagate(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return this.canBeGrass(pState, pLevel, pPos) && !pLevel.getFluidState(pPos.above()).is(FluidTags.WATER);
    }

    public boolean isBonemealSuccess(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public boolean isValidBonemealTarget(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return pLevel.getBlockState(pPos.above()).isAir();
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{IcariaBlockStateProperties.MOSS});
    }

    public void performBonemeal(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        Block block = IcariaBlocks.GRASSY_MARL.get().defaultBlockState().getBlock();
        BlockPos abovePos = pPos.above();
        Optional optional = pLevel.registryAccess().registryOrThrow(Registries.PLACED_FEATURE).getHolder(IcariaPlacedFeatures.ICARIA_BONEMEAL);
        BlockState aboveState = pLevel.getBlockState(abovePos);
        block0: for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < i / 16; ++j) {
                if (!pLevel.getBlockState((abovePos = abovePos.offset(pRandom.nextInt(3) - 1, (pRandom.nextInt(3) - 1) * pRandom.nextInt(3) / 2, pRandom.nextInt(3) - 1)).below()).is((Block)this) || pLevel.getBlockState(abovePos).isCollisionShapeFullBlock((BlockGetter)pLevel, abovePos)) continue block0;
            }
            if (aboveState.is(block) && pRandom.nextInt(10) == 0 && block instanceof BonemealableBlock) {
                BonemealableBlock bonemealableBlock = (BonemealableBlock)block;
                bonemealableBlock.performBonemeal(pLevel, pRandom, abovePos, aboveState);
            }
            if (!aboveState.isAir() || optional.isEmpty()) continue;
            ((PlacedFeature)((Holder.Reference)optional.get()).value()).place((WorldGenLevel)pLevel, pLevel.getChunkSource().getGenerator(), pRandom, abovePos);
        }
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (this.canBeGrass(pState, (LevelReader)pLevel, pPos)) {
            if (pLevel.isAreaLoaded(pPos, 3)) {
                for (int i = 0; i < 4; ++i) {
                    BlockState blockState = this.defaultBlockState();
                    BlockPos blockPos = pPos.offset(pRandom.nextInt(3) - 1, pRandom.nextInt(5) - 3, pRandom.nextInt(3) - 1);
                    BlockPos abovePos = blockPos.above();
                    if (!this.canPropagate(blockState, (LevelReader)pLevel, blockPos) || !pLevel.getBlockState(blockPos).is(IcariaBlocks.MARL.get())) continue;
                    if (pLevel.getBlockState(abovePos).is(IcariaBlocks.FOREST_MOSS.get())) {
                        pLevel.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue(IcariaBlockStateProperties.MOSS, (Comparable)((Object)Moss.FOREST)));
                        continue;
                    }
                    if (pLevel.getBlockState(abovePos).is(IcariaBlocks.SCRUBLAND_MOSS.get())) {
                        pLevel.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue(IcariaBlockStateProperties.MOSS, (Comparable)((Object)Moss.SCRUBLAND)));
                        continue;
                    }
                    if (pLevel.getBlockState(abovePos).is(IcariaBlocks.STEPPE_MOSS.get())) {
                        pLevel.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue(IcariaBlockStateProperties.MOSS, (Comparable)((Object)Moss.STEPPE)));
                        continue;
                    }
                    pLevel.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue(IcariaBlockStateProperties.MOSS, (Comparable)((Object)Moss.NONE)));
                }
            }
        } else if (pLevel.isAreaLoaded(pPos, 1)) {
            pLevel.setBlockAndUpdate(pPos, IcariaBlocks.MARL.get().defaultBlockState());
        }
    }

    public BlockState getToolModifiedState(BlockState pState, UseOnContext pContext, ItemAbility pToolAction, boolean pSimulate) {
        if (pToolAction.equals(ItemAbilities.HOE_TILL) && pContext.getLevel().getBlockState(pContext.getClickedPos().above()).isAir()) {
            return IcariaBlocks.FARMLAND.get().defaultBlockState();
        }
        return null;
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (pDirection == Direction.UP) {
            if (pNeighborState.is(IcariaBlocks.FOREST_MOSS.get())) {
                pLevel.setBlock(pCurrentPos, (BlockState)pState.setValue(IcariaBlockStateProperties.MOSS, (Comparable)((Object)Moss.FOREST)), 3);
            } else if (pNeighborState.is(IcariaBlocks.SCRUBLAND_MOSS.get())) {
                pLevel.setBlock(pCurrentPos, (BlockState)pState.setValue(IcariaBlockStateProperties.MOSS, (Comparable)((Object)Moss.SCRUBLAND)), 3);
            } else if (pNeighborState.is(IcariaBlocks.STEPPE_MOSS.get())) {
                pLevel.setBlock(pCurrentPos, (BlockState)pState.setValue(IcariaBlockStateProperties.MOSS, (Comparable)((Object)Moss.STEPPE)), 3);
            } else {
                pLevel.setBlock(pCurrentPos, (BlockState)pState.setValue(IcariaBlockStateProperties.MOSS, (Comparable)((Object)Moss.NONE)), 3);
            }
        }
        return super.updateShape(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }
}

