/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.registry.IcariaShapes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GreekFireBlock
extends Block {
    public GreekFireBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.AGE_15, (Comparable)Integer.valueOf(0)));
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos belowPos = pPos.below();
        return pLevel.getBlockState(belowPos).isFaceSturdy((BlockGetter)pLevel, belowPos, Direction.UP);
    }

    public boolean isNearRain(Level pLevel, BlockPos pPos) {
        return pLevel.isRainingAt(pPos) || pLevel.isRainingAt(pPos.west()) || pLevel.isRainingAt(pPos.east()) || pLevel.isRainingAt(pPos.north()) || pLevel.isRainingAt(pPos.south());
    }

    public int getFireTickDelay(RandomSource pRandom) {
        return pRandom.nextInt(10) + 30;
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pRandom.nextInt(24) == 0) {
            pLevel.playLocalSound((double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, pRandom.nextFloat() + 1.0f, pRandom.nextFloat() * 0.7f + 0.3f, false);
        }
        for (int i = 0; i < 3; ++i) {
            pLevel.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pPos.getX() + pRandom.nextDouble(), (double)pPos.getY() + pRandom.nextDouble() * 0.5 + 0.5, (double)pPos.getZ() + pRandom.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.AGE_15});
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        super.entityInside(pState, pLevel, pPos, pEntity);
        if (!pEntity.fireImmune()) {
            pEntity.setRemainingFireTicks(pEntity.getRemainingFireTicks() + 1);
            if (pEntity.getRemainingFireTicks() == 0) {
                pEntity.igniteForSeconds(8.0f);
            }
        }
        pEntity.hurt(pLevel.damageSources().inFire(), 1.5f);
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        pLevel.scheduleTick(pPos, (Block)this, this.getFireTickDelay(pLevel.random));
    }

    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pLevel.isClientSide()) {
            pLevel.levelEvent(null, 1009, pPos, 0);
        }
        return super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        pLevel.scheduleTick(pPos, (Block)this, this.getFireTickDelay(pLevel.random));
        if (pLevel.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) {
            int i = (Integer)pState.getValue((Property)BlockStateProperties.AGE_15);
            if (pLevel.isRaining() && this.isNearRain((Level)pLevel, pPos) && pRandom.nextFloat() < 0.2f + (float)i * 0.03f) {
                pLevel.removeBlock(pPos, false);
            } else {
                int j = Math.min(15, i + pRandom.nextInt(3) / 2);
                if (i != j) {
                    pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)BlockStateProperties.AGE_15, (Comparable)Integer.valueOf(j)), 4);
                }
                if (i > 3) {
                    pLevel.removeBlock(pPos, false);
                }
            }
        }
    }

    public BlockState getStateWithAge(int pAge) {
        BlockState blockState = IcariaBlocks.GREEK_FIRE.get().defaultBlockState();
        return blockState.is(IcariaBlocks.GREEK_FIRE.get()) ? (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_15, (Comparable)Integer.valueOf(pAge)) : blockState;
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        return this.canSurvive(pState, (LevelReader)pLevel, pCurrentPos) ? this.getStateWithAge((Integer)pState.getValue((Property)BlockStateProperties.AGE_15)) : Blocks.AIR.defaultBlockState();
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return IcariaShapes.Y1;
    }
}

