/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.entity.GrinderBlockEntity;
import com.axanthic.icaria.common.entity.GrinderRedirectorBlockEntity;
import com.axanthic.icaria.common.menu.provider.GrinderMenuProvider;
import com.axanthic.icaria.common.properties.Side;
import com.axanthic.icaria.common.registry.IcariaBlockEntityTypes;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.registry.IcariaShapes;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GrinderBlock
extends BaseEntityBlock {
    public static final MapCodec<GrinderBlock> CODEC = Block.simpleCodec(GrinderBlock::new);

    public GrinderBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)IcariaBlockStateProperties.GRINDER_GRINDING, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue(IcariaBlockStateProperties.SIDE, (Comparable)((Object)Side.LEFT)));
    }

    public boolean canDropFromExplosion(BlockState pState, BlockGetter pLevel, BlockPos pPos, Explosion pExplosion) {
        return false;
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public double getX(BlockState pState) {
        return switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case Direction.EAST -> 1.25;
            case Direction.WEST -> -0.25;
            default -> 0.5;
        };
    }

    public double getZ(BlockState pState) {
        return switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case Direction.NORTH -> -0.25;
            case Direction.SOUTH -> 1.25;
            default -> 0.5;
        };
    }

    public double getSpeedX(BlockState pState) {
        return switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case Direction.EAST -> 0.25;
            case Direction.WEST -> -0.25;
            default -> 0.0;
        };
    }

    public double getSpeedZ(BlockState pState) {
        return switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case Direction.NORTH -> -0.25;
            case Direction.SOUTH -> 0.25;
            default -> 0.0;
        };
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        int n;
        BlockEntity blockEntity = pLevel.getBlockEntity(GrinderBlock.getBlockEntityPosition(pState, pPos));
        if (blockEntity instanceof GrinderBlockEntity) {
            GrinderBlockEntity blockEntity2 = (GrinderBlockEntity)blockEntity;
            n = blockEntity2.getComparatorInput();
        } else {
            n = 0;
        }
        return n;
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockEntity blockEntity;
        if (((Boolean)pState.getValue((Property)IcariaBlockStateProperties.GRINDER_GRINDING)).booleanValue() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof GrinderBlockEntity) {
            GrinderBlockEntity blockEntity2 = (GrinderBlockEntity)blockEntity;
            ItemStack itemStack = blockEntity2.inputHandler.getStackInSlot(0);
            if (!itemStack.isEmpty()) {
                pLevel.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, itemStack), (double)pPos.getX() + 0.5, (double)pPos.getY() + 1.0, (double)pPos.getZ() + 0.5, 0.0, 0.25, 0.0);
                pLevel.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, itemStack), (double)pPos.getX() + this.getX(pState), (double)pPos.getY() + 0.25, (double)pPos.getZ() + this.getZ(pState), this.getSpeedX(pState), -0.25, this.getSpeedZ(pState));
            }
        }
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{IcariaBlockStateProperties.GRINDER_GRINDING, BlockStateProperties.HORIZONTAL_FACING, IcariaBlockStateProperties.SIDE});
    }

    public void onBlockExploded(BlockState pState, Level pLevel, BlockPos pPos, Explosion pExplosion) {
        BlockPos blockPos = GrinderBlock.getBlockEntityPosition(pState, pPos);
        Direction facing = (Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        pLevel.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
        pLevel.setBlock(blockPos.offset(facing.getCounterClockWise().getNormal()), Blocks.AIR.defaultBlockState(), 3);
        super.onBlockExploded(pState, pLevel, pPos, pExplosion);
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.getBlock() != pNewState.getBlock() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof GrinderBlockEntity) {
            GrinderBlockEntity blockEntity2 = (GrinderBlockEntity)blockEntity;
            if (pLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pLevel;
                blockEntity2.drops((Level)serverLevel);
                blockEntity2.getRecipesToAwardAndPopExperience(serverLevel, Vec3.atCenterOf((Vec3i)pPos));
                Block.popResource((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)IcariaItems.GRINDER.get()));
            }
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        Direction facing = (Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        pLevel.setBlock(pPos.offset(facing.getCounterClockWise().getNormal()), (BlockState)pState.setValue(IcariaBlockStateProperties.SIDE, (Comparable)((Object)Side.RIGHT)), 3);
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        if (pState.getValue(IcariaBlockStateProperties.SIDE) == Side.LEFT) {
            return new GrinderBlockEntity(pPos, pState);
        }
        return new GrinderRedirectorBlockEntity(pPos, pState);
    }

    public static BlockPos getBlockEntityPosition(BlockState pState, BlockPos pPos) {
        Direction facing = (Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (pState.getValue(IcariaBlockStateProperties.SIDE) == Side.LEFT) {
            return pPos;
        }
        return pPos.offset(facing.getClockWise().getNormal());
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockPos blockPos = pContext.getClickedPos();
        Direction facing = pContext.getHorizontalDirection().getOpposite();
        Level level = pContext.getLevel();
        if (blockPos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(blockPos.offset(facing.getCounterClockWise().getNormal())).canBeReplaced(pContext)) {
            return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
        }
        return null;
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        BlockState state = (BlockState)pState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pMirror.mirror((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        return pMirror == Mirror.NONE ? state : (BlockState)state.setValue(IcariaBlockStateProperties.SIDE, (Comparable)((Object)((Side)((Object)state.getValue(IcariaBlockStateProperties.SIDE))).getOpposite()));
    }

    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockPos blockPos = GrinderBlock.getBlockEntityPosition(pState, pPos);
        Direction facing = (Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        pLevel.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
        pLevel.setBlock(blockPos.offset(facing.getCounterClockWise().getNormal()), Blocks.AIR.defaultBlockState(), 3);
        return super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pResult) {
        BlockPos blockEntityPosition = GrinderBlock.getBlockEntityPosition(pState, pPos);
        BlockEntity blockEntity = pLevel.getBlockEntity(blockEntityPosition);
        if (!pLevel.isClientSide() && pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            if (blockEntity instanceof GrinderBlockEntity || blockEntity instanceof GrinderRedirectorBlockEntity) {
                serverPlayer.openMenu((MenuProvider)new GrinderMenuProvider(blockEntityPosition), blockEntityPosition);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Side)((Object)pState.getValue(IcariaBlockStateProperties.SIDE))) {
            default -> throw new MatchException(null, null);
            case Side.LEFT -> {
                switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    case NORTH: {
                        yield IcariaShapes.GrinderShapes.LEFT_NORTH;
                    }
                    case EAST: {
                        yield IcariaShapes.GrinderShapes.LEFT_EAST;
                    }
                    case SOUTH: {
                        yield IcariaShapes.GrinderShapes.LEFT_SOUTH;
                    }
                }
                yield IcariaShapes.GrinderShapes.LEFT_WEST;
            }
            case Side.RIGHT -> {
                switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    case NORTH: {
                        yield IcariaShapes.GrinderShapes.RIGHT_NORTH;
                    }
                    case EAST: {
                        yield IcariaShapes.GrinderShapes.RIGHT_EAST;
                    }
                    case SOUTH: {
                        yield IcariaShapes.GrinderShapes.RIGHT_SOUTH;
                    }
                }
                yield IcariaShapes.GrinderShapes.RIGHT_WEST;
            }
        };
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return !pLevel.isClientSide() ? BaseEntityBlock.createTickerHelper(pBlockEntityType, IcariaBlockEntityTypes.GRINDER.get(), GrinderBlockEntity::tick) : null;
    }
}

