/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.entity.HyliasterEntity;
import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class HyliastrumOreBlock
extends Block {
    public HyliastrumOreBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public void spawnAfterBreak(BlockState pState, ServerLevel pLevel, BlockPos pPos, ItemStack pStack, boolean pDropExperience) {
        super.spawnAfterBreak(pState, pLevel, pPos, pStack, pDropExperience);
        HyliasterEntity entity = (HyliasterEntity)IcariaEntityTypes.HYLIASTER.get().create((Level)pLevel);
        HolderLookup.RegistryLookup registryLookup = pLevel.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        if (pLevel.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && pStack.getEnchantmentLevel((Holder)registryLookup.getOrThrow(Enchantments.SILK_TOUCH)) == 0 && entity != null) {
            entity.moveTo((double)pPos.getX() + 0.5, pPos.getY(), (double)pPos.getZ() + 0.5, 0.0f, 0.0f);
            entity.setSize(4);
            entity.spawnAnim();
            pLevel.addFreshEntity((Entity)entity);
        }
    }
}

