/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.block.MediterraneanWaterloggedBlock;
import com.axanthic.icaria.common.entity.IcariaBarrelEntity;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import com.axanthic.icaria.common.registry.IcariaFluids;
import com.axanthic.icaria.common.registry.IcariaLootTables;
import com.axanthic.icaria.common.registry.IcariaWoodTypes;
import com.axanthic.icaria.data.tags.IcariaBlockTags;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaBarrelBlock
extends Block
implements MediterraneanWaterloggedBlock,
SimpleWaterloggedBlock {
    public IcariaBarrelBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{IcariaBlockStateProperties.BARREL_FACING, BlockStateProperties.HORIZONTAL_FACING, IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, BlockStateProperties.WATERLOGGED});
    }

    public void onBlockExploded(BlockState pState, Level pLevel, BlockPos pPos, Explosion pExplosion) {
        int x = pPos.getX();
        int y = pPos.getY();
        int z = pPos.getZ();
        if (!pLevel.isClientSide()) {
            if (pState.is(IcariaBlockTags.LOADED_BARRELS)) {
                pExplosion.explode();
                for (int i = -2; i <= 2; ++i) {
                    BlockPos negPos = BlockPos.containing((double)(x - i), (double)(y - i), (double)(z - i));
                    BlockPos posPos = BlockPos.containing((double)(x + i), (double)(y + i), (double)(z + i));
                    for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)negPos, (BlockPos)posPos)) {
                        BlockPos belowPos = blockPos.below();
                        if (pLevel.getRandom().nextInt(10) != 0 || !pLevel.getBlockState(blockPos).isAir() || !pLevel.getBlockState(belowPos).isSolidRender((BlockGetter)pLevel, belowPos)) continue;
                        pLevel.setBlockAndUpdate(blockPos, IcariaBlocks.GREEK_FIRE.get().defaultBlockState());
                    }
                }
            } else if (pState.is(IcariaBlockTags.TAPPED_BARRELS)) {
                for (int i = -1; i <= 1; ++i) {
                    BlockPos negPos = BlockPos.containing((double)(x - i), (double)(y - i), (double)(z - i));
                    BlockPos posPos = BlockPos.containing((double)(x + i), (double)(y + i), (double)(z + i));
                    for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)negPos, (BlockPos)posPos)) {
                        BlockPos belowPos = blockPos.below();
                        if (pLevel.getRandom().nextInt(10) != 0 || !pLevel.getBlockState(blockPos).isAir() || !pLevel.getBlockState(belowPos).isSolidRender((BlockGetter)pLevel, belowPos)) continue;
                        pLevel.setBlockAndUpdate(blockPos, IcariaBlocks.MEDITERRANEAN_WATER.get().defaultBlockState());
                    }
                }
            }
        }
        super.onBlockExploded(pState, pLevel, pPos, pExplosion);
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        pLevel.scheduleTick(pPos, (Block)this, 2);
    }

    public void onProjectileHit(Level pLevel, BlockState pState, BlockHitResult pHit, Projectile pProjectile) {
        BlockPos pos = pHit.getBlockPos();
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        if (!pLevel.isClientSide() && pState.is(IcariaBlockTags.LOADED_BARRELS) && pProjectile.isOnFire()) {
            pLevel.explode(null, (double)x, (double)y, (double)z, 2.0f, Level.ExplosionInteraction.BLOCK);
            for (int i = -2; i <= 2; ++i) {
                BlockPos negPos = BlockPos.containing((double)(x - i), (double)(y - i), (double)(z - i));
                BlockPos posPos = BlockPos.containing((double)(x + i), (double)(y + i), (double)(z + i));
                for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)negPos, (BlockPos)posPos)) {
                    BlockPos belowPos = blockPos.below();
                    if (pLevel.getRandom().nextInt(10) != 0 || !pLevel.getBlockState(blockPos).isAir() || !pLevel.getBlockState(belowPos).isSolidRender((BlockGetter)pLevel, belowPos)) continue;
                    pLevel.setBlockAndUpdate(blockPos, IcariaBlocks.GREEK_FIRE.get().defaultBlockState());
                }
            }
        }
        super.onProjectileHit(pLevel, pState, pHit, pProjectile);
    }

    public void playerDestroy(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @Nullable BlockEntity pBlockEntity, ItemStack pTool) {
        int x = pPos.getX();
        int y = pPos.getY();
        int z = pPos.getZ();
        if (!pLevel.isClientSide()) {
            if (pState.is(IcariaBlockTags.LOADED_BARRELS)) {
                pLevel.explode(null, (double)x, (double)y, (double)z, 2.0f, Level.ExplosionInteraction.BLOCK);
                for (int i = -2; i <= 2; ++i) {
                    BlockPos negPos = BlockPos.containing((double)(x - i), (double)(y - i), (double)(z - i));
                    BlockPos posPos = BlockPos.containing((double)(x + i), (double)(y + i), (double)(z + i));
                    for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)negPos, (BlockPos)posPos)) {
                        BlockPos belowPos = blockPos.below();
                        if (pLevel.getRandom().nextInt(10) != 0 || !pLevel.getBlockState(blockPos).isAir() || !pLevel.getBlockState(belowPos).isSolidRender((BlockGetter)pLevel, belowPos)) continue;
                        pLevel.setBlockAndUpdate(blockPos, IcariaBlocks.GREEK_FIRE.get().defaultBlockState());
                    }
                }
            } else if (pState.is(IcariaBlockTags.TAPPED_BARRELS)) {
                for (int i = -1; i <= 1; ++i) {
                    BlockPos negPos = BlockPos.containing((double)(x - i), (double)(y - i), (double)(z - i));
                    BlockPos posPos = BlockPos.containing((double)(x + i), (double)(y + i), (double)(z + i));
                    for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)negPos, (BlockPos)posPos)) {
                        BlockPos belowPos = blockPos.below();
                        if (pLevel.getRandom().nextInt(10) != 0 || !pLevel.getBlockState(blockPos).isAir() || !pLevel.getBlockState(belowPos).isSolidRender((BlockGetter)pLevel, belowPos)) continue;
                        pLevel.setBlockAndUpdate(blockPos, IcariaBlocks.MEDITERRANEAN_WATER.get().defaultBlockState());
                    }
                }
            }
        }
        super.playerDestroy(pLevel, pPlayer, pPos, pState, pBlockEntity, pTool);
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pLevel.getBlockState(pPos.below()).canBeReplaced()) {
            IcariaBarrelEntity entity = new IcariaBarrelEntity(IcariaEntityTypes.BARREL.get(), (Level)pLevel, pState, pPos);
            entity.moveTo(pPos, 0.0f, 0.0f);
            pLevel.addFreshEntity((Entity)entity);
            pLevel.removeBlock(pPos, false);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Fluid fluidState = pContext.getLevel().getFluidState(pContext.getClickedPos()).getType();
        Direction horizontalDirection = pContext.getHorizontalDirection();
        Direction nearestLookingDirection = pContext.getNearestLookingDirection();
        return nearestLookingDirection.equals((Object)Direction.UP) ? (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)Direction.UP)).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)horizontalDirection.getOpposite())).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)Boolean.valueOf(fluidState == IcariaFluids.MEDITERRANEAN_WATER.get()))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState == Fluids.WATER)) : (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)nearestLookingDirection.getOpposite())).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)horizontalDirection.getOpposite())).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)Boolean.valueOf(fluidState == IcariaFluids.MEDITERRANEAN_WATER.get()))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState == Fluids.WATER));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return (BlockState)((BlockState)pState.setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)pMirror.mirror((Direction)pState.getValue((Property)IcariaBlockStateProperties.BARREL_FACING)))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pMirror.mirror((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)((BlockState)pState.setValue((Property)IcariaBlockStateProperties.BARREL_FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)IcariaBlockStateProperties.BARREL_FACING)))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        pLevel.scheduleTick(pCurrentPos, (Block)this, 2);
        return super.updateShape(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED) != false ? IcariaFluids.MEDITERRANEAN_WATER.get().getSource(false) : ((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState));
    }

    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pResult) {
        if (pLevel.isClientSide() || !pPlayer.getMainHandItem().isEmpty() || !pPlayer.getOffhandItem().isEmpty() || pPlayer.isPassenger() || pPlayer.isVehicle()) {
            return InteractionResult.FAIL;
        }
        IcariaBarrelEntity entity = new IcariaBarrelEntity(IcariaEntityTypes.BARREL.get(), pLevel, pState, pPos);
        entity.moveTo(pPlayer.blockPosition(), 0.0f, 0.0f);
        entity.startRiding((Entity)pPlayer);
        pLevel.addFreshEntity((Entity)entity);
        pLevel.removeBlock(pPos, false);
        pPlayer.displayClientMessage((Component)Component.translatable((String)"message.landsoficaria.barrel"), true);
        return InteractionResult.PASS;
    }

    public ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pResult) {
        int x = pPos.getX();
        int y = pPos.getY();
        int z = pPos.getZ();
        if (!pLevel.isClientSide() && pState.is(IcariaBlockTags.LOADED_BARRELS) && (pStack.is(Items.FIRE_CHARGE) || pStack.is(Items.FLINT_AND_STEEL))) {
            pLevel.explode(null, (double)x, (double)y, (double)z, 2.0f, Level.ExplosionInteraction.BLOCK);
            pPlayer.awardStat(Stats.ITEM_USED.get((Object)pStack.getItem()));
            if (!pPlayer.isCreative()) {
                if (pStack.is(Items.FIRE_CHARGE)) {
                    pStack.shrink(1);
                } else {
                    pStack.hurtAndBreak(1, (LivingEntity)pPlayer, LivingEntity.getSlotForHand((InteractionHand)pHand));
                }
            }
            for (int i = -2; i <= 2; ++i) {
                BlockPos negPos = BlockPos.containing((double)(x - i), (double)(y - i), (double)(z - i));
                BlockPos posPos = BlockPos.containing((double)(x + i), (double)(y + i), (double)(z + i));
                for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)negPos, (BlockPos)posPos)) {
                    BlockPos belowPos = blockPos.below();
                    if (pLevel.getRandom().nextInt(10) != 0 || !pLevel.getBlockState(blockPos).isAir() || !pLevel.getBlockState(belowPos).isSolidRender((BlockGetter)pLevel, belowPos)) continue;
                    pLevel.setBlockAndUpdate(blockPos, IcariaBlocks.GREEK_FIRE.get().defaultBlockState());
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return Shapes.empty();
    }

    public WoodType getType() {
        if (this.defaultBlockState().is(IcariaBlockTags.CYPRESS_BARRELS)) {
            return IcariaWoodTypes.CYPRESS;
        }
        if (this.defaultBlockState().is(IcariaBlockTags.DROUGHTROOT_BARRELS)) {
            return IcariaWoodTypes.DROUGHTROOT;
        }
        if (this.defaultBlockState().is(IcariaBlockTags.FIR_BARRELS)) {
            return IcariaWoodTypes.FIR;
        }
        if (this.defaultBlockState().is(IcariaBlockTags.LAUREL_BARRELS)) {
            return IcariaWoodTypes.LAUREL;
        }
        if (this.defaultBlockState().is(IcariaBlockTags.OLIVE_BARRELS)) {
            return IcariaWoodTypes.OLIVE;
        }
        if (this.defaultBlockState().is(IcariaBlockTags.PLANE_BARRELS)) {
            return IcariaWoodTypes.PLANE;
        }
        return IcariaWoodTypes.POPULUS;
    }

    public List<ItemStack> getDrops(BlockState pState, LootParams.Builder pBuilder) {
        LootParams lootContext = pBuilder.withParameter(LootContextParams.BLOCK_STATE, (Object)pState).create(LootContextParamSets.BLOCK);
        return pState.is(IcariaBlockTags.LOADED_BARRELS) || pState.is(IcariaBlockTags.TAPPED_BARRELS) ? List.of() : lootContext.getLevel().getServer().reloadableRegistries().getLootTable(IcariaLootTables.BARREL_LOOT).getRandomItems(lootContext);
    }
}

