/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.registry.IcariaShapes;
import com.mojang.serialization.MapCodec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaBushBlock
extends BushBlock {
    public static final MapCodec<IcariaBushBlock> CODEC = Block.simpleCodec(IcariaBushBlock::new);

    public IcariaBushBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public boolean canBeReplaced(BlockState pState, BlockPlaceContext pUseContext) {
        return pState.is(BlockTags.REPLACEABLE);
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState blockState = pLevel.getBlockState(pPos.below());
        if (((Object)((Object)this)).equals(IcariaBlocks.NAMDRAKE.get())) {
            return blockState.is(IcariaBlocks.DRY_LAKE_BED.get());
        }
        if (((Object)((Object)this)).equals(IcariaBlocks.MONDANOS.get())) {
            return blockState.is(BlockTags.SAND);
        }
        if (((Object)((Object)this)).equals(IcariaBlocks.BOLBOS.get())) {
            return blockState.is(BlockTags.SAND);
        }
        return blockState.is(BlockTags.DIRT);
    }

    public MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Vec3 vec3 = pState.getOffset(pLevel, pPos);
        return IcariaShapes.UP.move(vec3.x, vec3.y, vec3.z);
    }
}

