/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.registry.IcariaMobEffects;
import com.axanthic.icaria.common.registry.IcariaShapes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaCakeBlock
extends Block {
    public IcariaCakeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)IcariaBlockStateProperties.CAKE_BITE, (Comparable)Integer.valueOf(0)));
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pLevel.getBlockState(pPos.below()).isSolid();
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public boolean isPathfindable(BlockState pState, PathComputationType pType) {
        return false;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        return (4 - (Integer)pState.getValue((Property)IcariaBlockStateProperties.CAKE_BITE)) * 3;
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{IcariaBlockStateProperties.CAKE_BITE});
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        return pDirection == Direction.DOWN && !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pResult) {
        if (!pPlayer.canEat(false)) {
            return InteractionResult.PASS;
        }
        int bite = (Integer)pState.getValue((Property)IcariaBlockStateProperties.CAKE_BITE);
        if (bite < 3) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)IcariaBlockStateProperties.CAKE_BITE, (Comparable)Integer.valueOf(bite + 1)), 3);
        } else {
            pLevel.removeBlock(pPos, false);
        }
        if (pState.is(IcariaBlocks.LAUREL_CHERRY_CAKE.get())) {
            pPlayer.addEffect(new MobEffectInstance(IcariaMobEffects.LIFESTEAL, 600));
        } else if (pState.is(IcariaBlocks.STRAWBERRY_CAKE.get())) {
            pPlayer.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 600));
        } else if (pState.is(IcariaBlocks.PHYSALIS_CAKE.get())) {
            pPlayer.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 600));
        } else if (pState.is(IcariaBlocks.VINE_BERRY_CAKE.get())) {
            pPlayer.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 600));
        } else if (pState.is(IcariaBlocks.VINE_SPROUT_CAKE.get())) {
            pPlayer.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 600));
        }
        if (pState.is(IcariaBlocks.LAUREL_CHERRY_CAKE.get()) && !pLevel.isClientSide()) {
            for (int i = 0; i < 16; ++i) {
                pPlayer.randomTeleport(pPlayer.getX() + (pPlayer.getRandom().nextDouble() - 0.5) * 16.0, Mth.clamp((double)(pPlayer.getY() + (double)(pPlayer.getRandom().nextInt(16) - 8)), (double)pLevel.getMinBuildHeight(), (double)pLevel.getMaxBuildHeight()), pPlayer.getZ() + (pPlayer.getRandom().nextDouble() - 0.5) * 16.0, true);
                if (!pPlayer.isPassenger()) continue;
                pPlayer.stopRiding();
            }
        }
        pPlayer.awardStat(Stats.EAT_CAKE_SLICE);
        pPlayer.getFoodData().eat(2, 0.1f);
        return InteractionResult.SUCCESS;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return IcariaShapes.CAKE[(Integer)pState.getValue((Property)IcariaBlockStateProperties.CAKE_BITE)];
    }
}

