/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.block.MediterraneanWaterloggedBlock;
import com.axanthic.icaria.common.entity.IcariaChestBlockEntity;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaDataComponents;
import com.axanthic.icaria.common.registry.IcariaFluids;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import com.axanthic.icaria.common.util.IcariaChestBlockCombiner;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaChestBlock
extends ChestBlock
implements MediterraneanWaterloggedBlock {
    public IcariaChestBlock(BlockBehaviour.Properties pProperties, Supplier<BlockEntityType<? extends ChestBlockEntity>> pBlockEntityType) {
        super(pProperties, pBlockEntityType);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.CHEST_TYPE, (Comparable)ChestType.SINGLE)).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)IcariaBlockStateProperties.LABEL_UP, (Comparable)Boolean.valueOf(false))).setValue((Property)IcariaBlockStateProperties.LABEL_NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)IcariaBlockStateProperties.LABEL_EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)IcariaBlockStateProperties.LABEL_SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)IcariaBlockStateProperties.LABEL_WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean onDestroyedByPlayer(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, boolean pWillHarvest, FluidState pFluid) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof IcariaChestBlockEntity) {
            IcariaChestBlockEntity blockEntity2 = (IcariaChestBlockEntity)blockEntity;
            this.dropLabel(pPos, pState, pLevel, blockEntity2.getLabelUp(), blockEntity2.getColorUp(), blockEntity2.getStyleUp(), IcariaBlockStateProperties.LABEL_UP);
            this.dropLabel(pPos, pState, pLevel, blockEntity2.getLabelNorth(), blockEntity2.getColorNorth(), blockEntity2.getStyleNorth(), IcariaBlockStateProperties.LABEL_NORTH);
            this.dropLabel(pPos, pState, pLevel, blockEntity2.getLabelEast(), blockEntity2.getColorEast(), blockEntity2.getStyleEast(), IcariaBlockStateProperties.LABEL_EAST);
            this.dropLabel(pPos, pState, pLevel, blockEntity2.getLabelSouth(), blockEntity2.getColorSouth(), blockEntity2.getStyleSouth(), IcariaBlockStateProperties.LABEL_SOUTH);
            this.dropLabel(pPos, pState, pLevel, blockEntity2.getLabelWest(), blockEntity2.getColorWest(), blockEntity2.getStyleWest(), IcariaBlockStateProperties.LABEL_WEST);
        }
        return super.onDestroyedByPlayer(pState, pLevel, pPos, pPlayer, pWillHarvest, pFluid);
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.CHEST_TYPE, BlockStateProperties.HORIZONTAL_FACING, IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, IcariaBlockStateProperties.LABEL_UP, IcariaBlockStateProperties.LABEL_NORTH, IcariaBlockStateProperties.LABEL_EAST, IcariaBlockStateProperties.LABEL_SOUTH, IcariaBlockStateProperties.LABEL_WEST, BlockStateProperties.WATERLOGGED});
    }

    public void dropLabel(BlockPos pPos, Direction pDirection, Level pLevel, String pLabel, int pColor, boolean pStyle) {
        ItemStack itemStack = new ItemStack((ItemLike)IcariaItems.CHEST_LABEL.get());
        itemStack.set(IcariaDataComponents.COLOR, (Object)pColor);
        itemStack.set(IcariaDataComponents.LABEL, (Object)pLabel);
        itemStack.set(IcariaDataComponents.STYLE, (Object)pStyle);
        Block.popResourceFromFace((Level)pLevel, (BlockPos)pPos, (Direction)pDirection, (ItemStack)itemStack);
    }

    public void dropLabel(BlockPos pPos, BlockState pState, Level pLevel, String pLabel, int pColor, boolean pStyle, BooleanProperty pProperty) {
        ItemStack itemStack = new ItemStack((ItemLike)IcariaItems.CHEST_LABEL.get());
        if (((Boolean)pState.getValue((Property)pProperty)).booleanValue()) {
            itemStack.set(IcariaDataComponents.COLOR, (Object)pColor);
            itemStack.set(IcariaDataComponents.LABEL, (Object)pLabel);
            itemStack.set(IcariaDataComponents.STYLE, (Object)pStyle);
            Block.popResource((Level)pLevel, (BlockPos)pPos, (ItemStack)itemStack);
        }
    }

    public void onBlockExploded(BlockState pState, Level pLevel, BlockPos pPos, Explosion pExplosion) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof IcariaChestBlockEntity) {
            IcariaChestBlockEntity blockEntity2 = (IcariaChestBlockEntity)blockEntity;
            this.dropLabel(pPos, pState, pLevel, blockEntity2.getLabelUp(), blockEntity2.getColorUp(), blockEntity2.getStyleUp(), IcariaBlockStateProperties.LABEL_UP);
            this.dropLabel(pPos, pState, pLevel, blockEntity2.getLabelNorth(), blockEntity2.getColorNorth(), blockEntity2.getStyleNorth(), IcariaBlockStateProperties.LABEL_NORTH);
            this.dropLabel(pPos, pState, pLevel, blockEntity2.getLabelEast(), blockEntity2.getColorEast(), blockEntity2.getStyleEast(), IcariaBlockStateProperties.LABEL_EAST);
            this.dropLabel(pPos, pState, pLevel, blockEntity2.getLabelSouth(), blockEntity2.getColorSouth(), blockEntity2.getStyleSouth(), IcariaBlockStateProperties.LABEL_SOUTH);
            this.dropLabel(pPos, pState, pLevel, blockEntity2.getLabelWest(), blockEntity2.getColorWest(), blockEntity2.getStyleWest(), IcariaBlockStateProperties.LABEL_WEST);
        }
        super.onBlockExploded(pState, pLevel, pPos, pExplosion);
    }

    public void playApplySound(Level pLevel, BlockPos pPos) {
        pLevel.playSound(null, pPos, IcariaSoundEvents.CHEST_LABEL_APPLY, SoundSource.BLOCKS);
    }

    public void playClearSound(Level pLevel, BlockPos pPos) {
        pLevel.playSound(null, pPos, IcariaSoundEvents.CHEST_LABEL_CLEAR, SoundSource.BLOCKS);
    }

    public void playDyeSound(Level pLevel, BlockPos pPos) {
        pLevel.playSound(null, pPos, SoundEvents.DYE_USE, SoundSource.BLOCKS);
    }

    public void playInkSacSound(Level pLevel, BlockPos pPos) {
        pLevel.playSound(null, pPos, SoundEvents.INK_SAC_USE, SoundSource.BLOCKS);
    }

    public void playGlowInkSacSound(Level pLevel, BlockPos pPos) {
        pLevel.playSound(null, pPos, SoundEvents.GLOW_INK_SAC_USE, SoundSource.BLOCKS);
    }

    public void shrinkStack(boolean pCreative, ItemStack pStack) {
        if (!pCreative) {
            pStack.shrink(1);
        }
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new IcariaChestBlockEntity(pPos, pState);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)super.getStateForPlacement(pContext).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)Boolean.valueOf(pContext.getLevel().getFluidState(pContext.getClickedPos()).getType() == IcariaFluids.MEDITERRANEAN_WATER.get()));
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED) != false ? IcariaFluids.MEDITERRANEAN_WATER.get().getSource(false) : super.getFluidState(pState);
    }

    public ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pResult) {
        IcariaChestBlockEntity blockEntity;
        boolean creative = pPlayer.isCreative();
        Direction direction = pResult.getDirection();
        ItemStack stack = pPlayer.getItemInHand(pHand);
        Integer color = (Integer)stack.getOrDefault(IcariaDataComponents.COLOR, (Object)0);
        String label = (String)stack.getOrDefault(IcariaDataComponents.LABEL, (Object)"");
        Boolean style = (Boolean)stack.getOrDefault(IcariaDataComponents.STYLE, (Object)false);
        BlockEntity blockEntity2 = pLevel.getBlockEntity(pPos);
        if (blockEntity2 instanceof IcariaChestBlockEntity && !(blockEntity = (IcariaChestBlockEntity)blockEntity2).getWaxed()) {
            if (stack.is(IcariaItems.CHEST_LABEL.get())) {
                if (direction.equals((Object)Direction.UP)) {
                    if (!((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_UP)).booleanValue()) {
                        this.playApplySound(pLevel, pPos);
                        this.shrinkStack(creative, stack);
                        pPlayer.awardStat(Stats.ITEM_USED.get((Object)IcariaItems.CHEST_LABEL.get()));
                        pLevel.setBlock(pPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.CHEST_TYPE, (Comparable)((ChestType)pState.getValue((Property)BlockStateProperties.CHEST_TYPE)))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)))).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED)))).setValue((Property)IcariaBlockStateProperties.LABEL_UP, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.LABEL_NORTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_NORTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_EAST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_EAST)))).setValue((Property)IcariaBlockStateProperties.LABEL_SOUTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_SOUTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_WEST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_WEST)))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED))), 3);
                        blockEntity.setColorUp(color);
                        blockEntity.setLabelUp(label);
                        blockEntity.setStyleUp(style);
                        blockEntity.setChanged();
                        return ItemInteractionResult.CONSUME;
                    }
                    if (!(color.equals(blockEntity.getColorUp()) && label.equals(blockEntity.getLabelUp()) && style.equals(blockEntity.getStyleUp()))) {
                        this.playApplySound(pLevel, pPos);
                        this.dropLabel(pPos, direction, pLevel, blockEntity.getLabelUp(), blockEntity.getColorUp(), blockEntity.getStyleUp());
                        this.shrinkStack(creative, stack);
                        pPlayer.awardStat(Stats.ITEM_USED.get((Object)IcariaItems.CHEST_LABEL.get()));
                        pLevel.setBlock(pPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.CHEST_TYPE, (Comparable)((ChestType)pState.getValue((Property)BlockStateProperties.CHEST_TYPE)))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)))).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED)))).setValue((Property)IcariaBlockStateProperties.LABEL_UP, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.LABEL_NORTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_NORTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_EAST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_EAST)))).setValue((Property)IcariaBlockStateProperties.LABEL_SOUTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_SOUTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_WEST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_WEST)))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED))), 3);
                        blockEntity.setColorUp(color);
                        blockEntity.setLabelUp(label);
                        blockEntity.setStyleUp(style);
                        blockEntity.setChanged();
                        return ItemInteractionResult.CONSUME;
                    }
                } else if (direction.equals((Object)Direction.NORTH)) {
                    if (!((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_NORTH)).booleanValue()) {
                        this.playApplySound(pLevel, pPos);
                        this.shrinkStack(creative, stack);
                        pPlayer.awardStat(Stats.ITEM_USED.get((Object)IcariaItems.CHEST_LABEL.get()));
                        pLevel.setBlock(pPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.CHEST_TYPE, (Comparable)((ChestType)pState.getValue((Property)BlockStateProperties.CHEST_TYPE)))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)))).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED)))).setValue((Property)IcariaBlockStateProperties.LABEL_UP, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_UP)))).setValue((Property)IcariaBlockStateProperties.LABEL_NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.LABEL_EAST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_EAST)))).setValue((Property)IcariaBlockStateProperties.LABEL_SOUTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_SOUTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_WEST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_WEST)))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED))), 3);
                        blockEntity.setColorNorth(color);
                        blockEntity.setLabelNorth(label);
                        blockEntity.setStyleNorth(style);
                        blockEntity.setChanged();
                        return ItemInteractionResult.CONSUME;
                    }
                    if (!(color.equals(blockEntity.getColorNorth()) && label.equals(blockEntity.getLabelNorth()) && style.equals(blockEntity.getStyleNorth()))) {
                        this.playApplySound(pLevel, pPos);
                        this.dropLabel(pPos, direction, pLevel, blockEntity.getLabelNorth(), blockEntity.getColorNorth(), blockEntity.getStyleNorth());
                        this.shrinkStack(creative, stack);
                        pPlayer.awardStat(Stats.ITEM_USED.get((Object)IcariaItems.CHEST_LABEL.get()));
                        pLevel.setBlock(pPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.CHEST_TYPE, (Comparable)((ChestType)pState.getValue((Property)BlockStateProperties.CHEST_TYPE)))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)))).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED)))).setValue((Property)IcariaBlockStateProperties.LABEL_UP, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_UP)))).setValue((Property)IcariaBlockStateProperties.LABEL_NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.LABEL_EAST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_EAST)))).setValue((Property)IcariaBlockStateProperties.LABEL_SOUTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_SOUTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_WEST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_WEST)))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED))), 3);
                        blockEntity.setColorNorth(color);
                        blockEntity.setLabelNorth(label);
                        blockEntity.setStyleNorth(style);
                        blockEntity.setChanged();
                        return ItemInteractionResult.CONSUME;
                    }
                } else if (direction.equals((Object)Direction.EAST)) {
                    if (!((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_EAST)).booleanValue()) {
                        this.playApplySound(pLevel, pPos);
                        this.shrinkStack(creative, stack);
                        pPlayer.awardStat(Stats.ITEM_USED.get((Object)IcariaItems.CHEST_LABEL.get()));
                        pLevel.setBlock(pPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.CHEST_TYPE, (Comparable)((ChestType)pState.getValue((Property)BlockStateProperties.CHEST_TYPE)))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)))).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED)))).setValue((Property)IcariaBlockStateProperties.LABEL_UP, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_UP)))).setValue((Property)IcariaBlockStateProperties.LABEL_NORTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_NORTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.LABEL_SOUTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_SOUTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_WEST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_WEST)))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED))), 3);
                        blockEntity.setColorEast(color);
                        blockEntity.setLabelEast(label);
                        blockEntity.setStyleEast(style);
                        blockEntity.setChanged();
                        return ItemInteractionResult.CONSUME;
                    }
                    if (!(color.equals(blockEntity.getColorEast()) && label.equals(blockEntity.getLabelEast()) && style.equals(blockEntity.getStyleEast()))) {
                        this.playApplySound(pLevel, pPos);
                        this.dropLabel(pPos, direction, pLevel, blockEntity.getLabelEast(), blockEntity.getColorEast(), blockEntity.getStyleEast());
                        this.shrinkStack(creative, stack);
                        pPlayer.awardStat(Stats.ITEM_USED.get((Object)IcariaItems.CHEST_LABEL.get()));
                        pLevel.setBlock(pPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.CHEST_TYPE, (Comparable)((ChestType)pState.getValue((Property)BlockStateProperties.CHEST_TYPE)))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)))).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED)))).setValue((Property)IcariaBlockStateProperties.LABEL_UP, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_UP)))).setValue((Property)IcariaBlockStateProperties.LABEL_NORTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_NORTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.LABEL_SOUTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_SOUTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_WEST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_WEST)))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED))), 3);
                        blockEntity.setColorEast(color);
                        blockEntity.setLabelEast(label);
                        blockEntity.setStyleEast(style);
                        blockEntity.setChanged();
                        return ItemInteractionResult.CONSUME;
                    }
                } else if (direction.equals((Object)Direction.SOUTH)) {
                    if (!((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_SOUTH)).booleanValue()) {
                        this.playApplySound(pLevel, pPos);
                        this.shrinkStack(creative, stack);
                        pPlayer.awardStat(Stats.ITEM_USED.get((Object)IcariaItems.CHEST_LABEL.get()));
                        pLevel.setBlock(pPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.CHEST_TYPE, (Comparable)((ChestType)pState.getValue((Property)BlockStateProperties.CHEST_TYPE)))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)))).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED)))).setValue((Property)IcariaBlockStateProperties.LABEL_UP, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_UP)))).setValue((Property)IcariaBlockStateProperties.LABEL_NORTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_NORTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_EAST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_EAST)))).setValue((Property)IcariaBlockStateProperties.LABEL_SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.LABEL_WEST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_WEST)))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED))), 3);
                        blockEntity.setColorSouth(color);
                        blockEntity.setLabelSouth(label);
                        blockEntity.setStyleSouth(style);
                        blockEntity.setChanged();
                        return ItemInteractionResult.CONSUME;
                    }
                    if (!(color.equals(blockEntity.getColorSouth()) && label.equals(blockEntity.getLabelSouth()) && style.equals(blockEntity.getStyleSouth()))) {
                        this.playApplySound(pLevel, pPos);
                        this.dropLabel(pPos, direction, pLevel, blockEntity.getLabelSouth(), blockEntity.getColorSouth(), blockEntity.getStyleSouth());
                        this.shrinkStack(creative, stack);
                        pPlayer.awardStat(Stats.ITEM_USED.get((Object)IcariaItems.CHEST_LABEL.get()));
                        pLevel.setBlock(pPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.CHEST_TYPE, (Comparable)((ChestType)pState.getValue((Property)BlockStateProperties.CHEST_TYPE)))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)))).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED)))).setValue((Property)IcariaBlockStateProperties.LABEL_UP, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_UP)))).setValue((Property)IcariaBlockStateProperties.LABEL_NORTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_NORTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_EAST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_EAST)))).setValue((Property)IcariaBlockStateProperties.LABEL_SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.LABEL_WEST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_WEST)))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED))), 3);
                        blockEntity.setColorSouth(color);
                        blockEntity.setLabelSouth(label);
                        blockEntity.setStyleSouth(style);
                        blockEntity.setChanged();
                        return ItemInteractionResult.CONSUME;
                    }
                } else if (direction.equals((Object)Direction.WEST)) {
                    if (!((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_WEST)).booleanValue()) {
                        this.playApplySound(pLevel, pPos);
                        this.shrinkStack(creative, stack);
                        pPlayer.awardStat(Stats.ITEM_USED.get((Object)IcariaItems.CHEST_LABEL.get()));
                        pLevel.setBlock(pPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.CHEST_TYPE, (Comparable)((ChestType)pState.getValue((Property)BlockStateProperties.CHEST_TYPE)))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)))).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED)))).setValue((Property)IcariaBlockStateProperties.LABEL_UP, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_UP)))).setValue((Property)IcariaBlockStateProperties.LABEL_NORTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_NORTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_EAST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_EAST)))).setValue((Property)IcariaBlockStateProperties.LABEL_SOUTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_SOUTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_WEST, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED))), 3);
                        blockEntity.setColorWest(color);
                        blockEntity.setLabelWest(label);
                        blockEntity.setStyleWest(style);
                        blockEntity.setChanged();
                        return ItemInteractionResult.CONSUME;
                    }
                    if (!(color.equals(blockEntity.getColorWest()) && label.equals(blockEntity.getLabelWest()) && style.equals(blockEntity.getStyleWest()))) {
                        this.playApplySound(pLevel, pPos);
                        this.dropLabel(pPos, direction, pLevel, blockEntity.getLabelWest(), blockEntity.getColorWest(), blockEntity.getStyleWest());
                        this.shrinkStack(creative, stack);
                        pPlayer.awardStat(Stats.ITEM_USED.get((Object)IcariaItems.CHEST_LABEL.get()));
                        pLevel.setBlock(pPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.CHEST_TYPE, (Comparable)((ChestType)pState.getValue((Property)BlockStateProperties.CHEST_TYPE)))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)))).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED)))).setValue((Property)IcariaBlockStateProperties.LABEL_UP, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_UP)))).setValue((Property)IcariaBlockStateProperties.LABEL_NORTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_NORTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_EAST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_EAST)))).setValue((Property)IcariaBlockStateProperties.LABEL_SOUTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_SOUTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_WEST, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED))), 3);
                        blockEntity.setColorWest(color);
                        blockEntity.setLabelWest(label);
                        blockEntity.setStyleWest(style);
                        blockEntity.setChanged();
                        return ItemInteractionResult.CONSUME;
                    }
                }
            } else {
                Item item = stack.getItem();
                if (item instanceof DyeItem) {
                    DyeItem dyeItem = (DyeItem)item;
                    if (direction.equals((Object)Direction.UP)) {
                        if (((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_UP)).booleanValue() && dyeItem.getDyeColor().getTextColor() != blockEntity.getColorUp()) {
                            this.shrinkStack(creative, stack);
                            this.playDyeSound(pLevel, pPos);
                            pPlayer.awardStat(Stats.ITEM_USED.get((Object)dyeItem));
                            blockEntity.setColorUp(dyeItem.getDyeColor().getTextColor());
                            blockEntity.setChanged();
                            return ItemInteractionResult.CONSUME;
                        }
                    } else if (direction.equals((Object)Direction.NORTH)) {
                        if (((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_NORTH)).booleanValue() && dyeItem.getDyeColor().getTextColor() != blockEntity.getColorNorth()) {
                            this.shrinkStack(creative, stack);
                            this.playDyeSound(pLevel, pPos);
                            pPlayer.awardStat(Stats.ITEM_USED.get((Object)dyeItem));
                            blockEntity.setColorNorth(dyeItem.getDyeColor().getTextColor());
                            blockEntity.setChanged();
                            return ItemInteractionResult.CONSUME;
                        }
                    } else if (direction.equals((Object)Direction.EAST)) {
                        if (((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_EAST)).booleanValue() && dyeItem.getDyeColor().getTextColor() != blockEntity.getColorEast()) {
                            this.shrinkStack(creative, stack);
                            this.playDyeSound(pLevel, pPos);
                            pPlayer.awardStat(Stats.ITEM_USED.get((Object)dyeItem));
                            blockEntity.setColorEast(dyeItem.getDyeColor().getTextColor());
                            blockEntity.setChanged();
                            return ItemInteractionResult.CONSUME;
                        }
                    } else if (direction.equals((Object)Direction.SOUTH)) {
                        if (((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_SOUTH)).booleanValue() && dyeItem.getDyeColor().getTextColor() != blockEntity.getColorSouth()) {
                            this.shrinkStack(creative, stack);
                            this.playDyeSound(pLevel, pPos);
                            pPlayer.awardStat(Stats.ITEM_USED.get((Object)dyeItem));
                            blockEntity.setColorSouth(dyeItem.getDyeColor().getTextColor());
                            blockEntity.setChanged();
                            return ItemInteractionResult.CONSUME;
                        }
                    } else if (direction.equals((Object)Direction.WEST) && ((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_WEST)).booleanValue() && dyeItem.getDyeColor().getTextColor() != blockEntity.getColorWest()) {
                        this.shrinkStack(creative, stack);
                        this.playDyeSound(pLevel, pPos);
                        pPlayer.awardStat(Stats.ITEM_USED.get((Object)dyeItem));
                        blockEntity.setColorWest(dyeItem.getDyeColor().getTextColor());
                        blockEntity.setChanged();
                        return ItemInteractionResult.CONSUME;
                    }
                } else if (stack.is(Items.INK_SAC)) {
                    if (direction.equals((Object)Direction.UP)) {
                        if (((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_UP)).booleanValue() && blockEntity.getStyleUp()) {
                            this.shrinkStack(creative, stack);
                            this.playInkSacSound(pLevel, pPos);
                            pPlayer.awardStat(Stats.ITEM_USED.get((Object)Items.GLOW_INK_SAC));
                            blockEntity.setStyleUp(false);
                            blockEntity.setChanged();
                            return ItemInteractionResult.CONSUME;
                        }
                    } else if (direction.equals((Object)Direction.NORTH)) {
                        if (((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_NORTH)).booleanValue() && blockEntity.getStyleNorth()) {
                            this.shrinkStack(creative, stack);
                            this.playInkSacSound(pLevel, pPos);
                            pPlayer.awardStat(Stats.ITEM_USED.get((Object)Items.GLOW_INK_SAC));
                            blockEntity.setStyleNorth(false);
                            blockEntity.setChanged();
                            return ItemInteractionResult.CONSUME;
                        }
                    } else if (direction.equals((Object)Direction.EAST)) {
                        if (((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_EAST)).booleanValue() && blockEntity.getStyleEast()) {
                            this.shrinkStack(creative, stack);
                            this.playInkSacSound(pLevel, pPos);
                            pPlayer.awardStat(Stats.ITEM_USED.get((Object)Items.GLOW_INK_SAC));
                            blockEntity.setStyleEast(false);
                            blockEntity.setChanged();
                            return ItemInteractionResult.CONSUME;
                        }
                    } else if (direction.equals((Object)Direction.SOUTH)) {
                        if (((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_SOUTH)).booleanValue() && blockEntity.getStyleSouth()) {
                            this.shrinkStack(creative, stack);
                            this.playInkSacSound(pLevel, pPos);
                            pPlayer.awardStat(Stats.ITEM_USED.get((Object)Items.GLOW_INK_SAC));
                            blockEntity.setStyleSouth(false);
                            blockEntity.setChanged();
                            return ItemInteractionResult.CONSUME;
                        }
                    } else if (direction.equals((Object)Direction.WEST) && ((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_WEST)).booleanValue() && blockEntity.getStyleWest()) {
                        this.shrinkStack(creative, stack);
                        this.playInkSacSound(pLevel, pPos);
                        pPlayer.awardStat(Stats.ITEM_USED.get((Object)Items.GLOW_INK_SAC));
                        blockEntity.setStyleWest(false);
                        blockEntity.setChanged();
                        return ItemInteractionResult.CONSUME;
                    }
                } else if (stack.is(Items.GLOW_INK_SAC)) {
                    if (direction.equals((Object)Direction.UP)) {
                        if (((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_UP)).booleanValue() && !blockEntity.getStyleUp()) {
                            this.shrinkStack(creative, stack);
                            this.playGlowInkSacSound(pLevel, pPos);
                            pPlayer.awardStat(Stats.ITEM_USED.get((Object)Items.GLOW_INK_SAC));
                            blockEntity.setStyleUp(true);
                            blockEntity.setChanged();
                            return ItemInteractionResult.CONSUME;
                        }
                    } else if (direction.equals((Object)Direction.NORTH)) {
                        if (((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_NORTH)).booleanValue() && !blockEntity.getStyleNorth()) {
                            this.shrinkStack(creative, stack);
                            this.playGlowInkSacSound(pLevel, pPos);
                            pPlayer.awardStat(Stats.ITEM_USED.get((Object)Items.GLOW_INK_SAC));
                            blockEntity.setStyleNorth(true);
                            blockEntity.setChanged();
                            return ItemInteractionResult.CONSUME;
                        }
                    } else if (direction.equals((Object)Direction.EAST)) {
                        if (((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_EAST)).booleanValue() && !blockEntity.getStyleEast()) {
                            this.shrinkStack(creative, stack);
                            this.playGlowInkSacSound(pLevel, pPos);
                            pPlayer.awardStat(Stats.ITEM_USED.get((Object)Items.GLOW_INK_SAC));
                            blockEntity.setStyleEast(true);
                            blockEntity.setChanged();
                            return ItemInteractionResult.CONSUME;
                        }
                    } else if (direction.equals((Object)Direction.SOUTH)) {
                        if (((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_SOUTH)).booleanValue() && !blockEntity.getStyleSouth()) {
                            this.shrinkStack(creative, stack);
                            this.playGlowInkSacSound(pLevel, pPos);
                            pPlayer.awardStat(Stats.ITEM_USED.get((Object)Items.GLOW_INK_SAC));
                            blockEntity.setStyleSouth(true);
                            blockEntity.setChanged();
                            return ItemInteractionResult.CONSUME;
                        }
                    } else if (direction.equals((Object)Direction.WEST) && ((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_WEST)).booleanValue() && !blockEntity.getStyleWest()) {
                        this.shrinkStack(creative, stack);
                        this.playGlowInkSacSound(pLevel, pPos);
                        pPlayer.awardStat(Stats.ITEM_USED.get((Object)Items.GLOW_INK_SAC));
                        blockEntity.setStyleWest(true);
                        blockEntity.setChanged();
                        return ItemInteractionResult.CONSUME;
                    }
                } else {
                    if (stack.is(Items.HONEYCOMB)) {
                        pLevel.levelEvent(null, 3003, pPos, 0);
                        blockEntity.setWaxed(true);
                        blockEntity.setChanged();
                        return ItemInteractionResult.CONSUME;
                    }
                    if (stack.isEmpty() && pPlayer.isShiftKeyDown()) {
                        if (direction.equals((Object)Direction.UP)) {
                            if (((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_UP)).booleanValue()) {
                                this.playClearSound(pLevel, pPos);
                                this.dropLabel(pPos, direction, pLevel, blockEntity.getLabelUp(), blockEntity.getColorUp(), blockEntity.getStyleUp());
                                pLevel.setBlock(pPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.CHEST_TYPE, (Comparable)((ChestType)pState.getValue((Property)BlockStateProperties.CHEST_TYPE)))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)))).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED)))).setValue((Property)IcariaBlockStateProperties.LABEL_UP, (Comparable)Boolean.valueOf(false))).setValue((Property)IcariaBlockStateProperties.LABEL_NORTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_NORTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_EAST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_EAST)))).setValue((Property)IcariaBlockStateProperties.LABEL_SOUTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_SOUTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_WEST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_WEST)))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED))), 3);
                                blockEntity.setColorUp(0);
                                blockEntity.setLabelUp(null);
                                blockEntity.setStyleUp(false);
                                blockEntity.setChanged();
                            }
                        } else if (direction.equals((Object)Direction.NORTH)) {
                            if (((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_NORTH)).booleanValue()) {
                                this.playClearSound(pLevel, pPos);
                                this.dropLabel(pPos, direction, pLevel, blockEntity.getLabelNorth(), blockEntity.getColorNorth(), blockEntity.getStyleNorth());
                                pLevel.setBlock(pPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.CHEST_TYPE, (Comparable)((ChestType)pState.getValue((Property)BlockStateProperties.CHEST_TYPE)))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)))).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED)))).setValue((Property)IcariaBlockStateProperties.LABEL_UP, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_UP)))).setValue((Property)IcariaBlockStateProperties.LABEL_NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)IcariaBlockStateProperties.LABEL_EAST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_EAST)))).setValue((Property)IcariaBlockStateProperties.LABEL_SOUTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_SOUTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_WEST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_WEST)))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED))), 3);
                                blockEntity.setColorNorth(0);
                                blockEntity.setLabelNorth(null);
                                blockEntity.setStyleNorth(false);
                                blockEntity.setChanged();
                            }
                        } else if (direction.equals((Object)Direction.EAST)) {
                            if (((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_EAST)).booleanValue()) {
                                this.playClearSound(pLevel, pPos);
                                this.dropLabel(pPos, direction, pLevel, blockEntity.getLabelEast(), blockEntity.getColorEast(), blockEntity.getStyleEast());
                                pLevel.setBlock(pPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.CHEST_TYPE, (Comparable)((ChestType)pState.getValue((Property)BlockStateProperties.CHEST_TYPE)))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)))).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED)))).setValue((Property)IcariaBlockStateProperties.LABEL_UP, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_UP)))).setValue((Property)IcariaBlockStateProperties.LABEL_NORTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_NORTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)IcariaBlockStateProperties.LABEL_SOUTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_SOUTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_WEST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_WEST)))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED))), 3);
                                blockEntity.setColorEast(0);
                                blockEntity.setLabelEast(null);
                                blockEntity.setStyleEast(false);
                                blockEntity.setChanged();
                            }
                        } else if (direction.equals((Object)Direction.SOUTH)) {
                            if (((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_SOUTH)).booleanValue()) {
                                this.playClearSound(pLevel, pPos);
                                this.dropLabel(pPos, direction, pLevel, blockEntity.getLabelSouth(), blockEntity.getColorSouth(), blockEntity.getStyleSouth());
                                pLevel.setBlock(pPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.CHEST_TYPE, (Comparable)((ChestType)pState.getValue((Property)BlockStateProperties.CHEST_TYPE)))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)))).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED)))).setValue((Property)IcariaBlockStateProperties.LABEL_UP, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_UP)))).setValue((Property)IcariaBlockStateProperties.LABEL_NORTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_NORTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_EAST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_EAST)))).setValue((Property)IcariaBlockStateProperties.LABEL_SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)IcariaBlockStateProperties.LABEL_WEST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_WEST)))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED))), 3);
                                blockEntity.setColorSouth(0);
                                blockEntity.setLabelSouth(null);
                                blockEntity.setStyleSouth(false);
                                blockEntity.setChanged();
                            }
                        } else if (direction.equals((Object)Direction.WEST) && ((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_WEST)).booleanValue()) {
                            this.playClearSound(pLevel, pPos);
                            this.dropLabel(pPos, direction, pLevel, blockEntity.getLabelWest(), blockEntity.getColorWest(), blockEntity.getStyleWest());
                            pLevel.setBlock(pPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.CHEST_TYPE, (Comparable)((ChestType)pState.getValue((Property)BlockStateProperties.CHEST_TYPE)))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)))).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED)))).setValue((Property)IcariaBlockStateProperties.LABEL_UP, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_UP)))).setValue((Property)IcariaBlockStateProperties.LABEL_NORTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_NORTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_EAST, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_EAST)))).setValue((Property)IcariaBlockStateProperties.LABEL_SOUTH, (Comparable)((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LABEL_SOUTH)))).setValue((Property)IcariaBlockStateProperties.LABEL_WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED))), 3);
                            blockEntity.setColorWest(0);
                            blockEntity.setLabelWest(null);
                            blockEntity.setStyleWest(false);
                            blockEntity.setChanged();
                        }
                        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
                    }
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public MenuProvider getMenuProvider(BlockState pState, Level pLevel, BlockPos pPos) {
        return ((Optional)this.combine(pState, pLevel, pPos, false).apply((DoubleBlockCombiner.Combiner)new IcariaChestBlockCombiner())).orElse(null);
    }
}

