/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.entity.ForestHagEntity;
import com.axanthic.icaria.common.registry.IcariaBiomes;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import com.axanthic.icaria.common.registry.IcariaItems;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaLogBlock
extends RotatedPillarBlock {
    public IcariaLogBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y)).setValue((Property)IcariaBlockStateProperties.PLAYER_PLACED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean onDestroyedByPlayer(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, boolean pWillHarvest, FluidState pFluid) {
        if (pLevel.getRandom().nextInt(50) == 0 && !pPlayer.isCreative() && !pPlayer.getItemBySlot(EquipmentSlot.HEAD).is(IcariaItems.LAUREL_WREATH.get())) {
            if (!((Boolean)pState.getValue((Property)IcariaBlockStateProperties.PLAYER_PLACED)).booleanValue()) {
                EntityType<ForestHagEntity> entityType = IcariaEntityTypes.CYPRESS_FOREST_HAG.get();
                if (pState.is((Block)IcariaBlocks.DROUGHTROOT_LOG.get())) {
                    entityType = IcariaEntityTypes.DROUGHTROOT_FOREST_HAG.get();
                } else if (pState.is((Block)IcariaBlocks.FIR_LOG.get())) {
                    entityType = IcariaEntityTypes.FIR_FOREST_HAG.get();
                } else if (pState.is((Block)IcariaBlocks.LAUREL_LOG.get())) {
                    entityType = IcariaEntityTypes.LAUREL_FOREST_HAG.get();
                } else if (pState.is((Block)IcariaBlocks.OLIVE_LOG.get())) {
                    entityType = IcariaEntityTypes.OLIVE_FOREST_HAG.get();
                } else if (pState.is((Block)IcariaBlocks.PLANE_LOG.get())) {
                    entityType = IcariaEntityTypes.PLANE_FOREST_HAG.get();
                } else if (pState.is((Block)IcariaBlocks.POPULUS_LOG.get())) {
                    entityType = IcariaEntityTypes.POPULUS_FOREST_HAG.get();
                }
                ForestHagEntity entity = (ForestHagEntity)entityType.create(pLevel);
                BlockPos blockPos = pPlayer.blockPosition();
                Direction direction = pPlayer.getDirection();
                BlockPos spawnPos = new BlockPos(blockPos.relative(direction.getOpposite(), 12).getX(), blockPos.getY(), blockPos.relative(direction.getOpposite(), 12).getZ());
                if (entity != null && !pLevel.getBiome(spawnPos).is(IcariaBiomes.VOID) && pLevel.getBlockState(spawnPos).isAir()) {
                    entity.moveTo(spawnPos, 0.0f, 0.0f);
                    entity.setTarget((LivingEntity)pPlayer);
                    entity.spawnAnim();
                    pLevel.addFreshEntity((Entity)entity);
                }
            }
            for (ForestHagEntity entity : pLevel.getEntitiesOfClass(ForestHagEntity.class, new AABB(pPos).inflate(12.0))) {
                entity.setTarget((LivingEntity)pPlayer);
            }
        }
        return super.onDestroyedByPlayer(pState, pLevel, pPos, pPlayer, pWillHarvest, pFluid);
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.AXIS, IcariaBlockStateProperties.PLAYER_PLACED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)pContext.getClickedFace().getAxis())).setValue((Property)IcariaBlockStateProperties.PLAYER_PLACED, (Comparable)Boolean.valueOf(true));
    }
}

