/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.entity.CivilianRevenantEntity;
import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.registry.IcariaDimensions;
import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import com.axanthic.icaria.common.registry.IcariaParticleTypes;
import com.axanthic.icaria.common.registry.IcariaPoiTypes;
import com.axanthic.icaria.common.registry.IcariaShapes;
import com.axanthic.icaria.common.util.IcariaPortalShape;
import com.axanthic.icaria.data.tags.IcariaBlockTags;
import java.util.Comparator;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.BlockUtil;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaPortalBlock
extends Block
implements Portal {
    public IcariaPortalBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)Direction.Axis.X));
    }

    public boolean canSet(ServerLevel pLevel, BlockPos pPos) {
        AABB aabbNorth = AABB.ofSize((Vec3)pPos.above(3).north().getCenter(), (double)2.0, (double)6.0, (double)2.0);
        AABB aabbEast = AABB.ofSize((Vec3)pPos.above(3).east().getCenter(), (double)2.0, (double)6.0, (double)2.0);
        AABB aabbSouth = AABB.ofSize((Vec3)pPos.above(3).south().getCenter(), (double)2.0, (double)6.0, (double)2.0);
        AABB aabbWest = AABB.ofSize((Vec3)pPos.above(3).west().getCenter(), (double)2.0, (double)6.0, (double)2.0);
        boolean testNorth = pLevel.getBlockStates(aabbNorth).allMatch(pState -> pState.is(IcariaBlockTags.PORTAL_REPLACE_BLOCKS));
        boolean testEast = pLevel.getBlockStates(aabbEast).allMatch(pState -> pState.is(IcariaBlockTags.PORTAL_REPLACE_BLOCKS));
        boolean testSouth = pLevel.getBlockStates(aabbSouth).allMatch(pState -> pState.is(IcariaBlockTags.PORTAL_REPLACE_BLOCKS));
        boolean testWest = pLevel.getBlockStates(aabbWest).allMatch(pState -> pState.is(IcariaBlockTags.PORTAL_REPLACE_BLOCKS));
        return testNorth && testEast && testSouth && testWest;
    }

    public boolean checkBelow(ServerLevel pLevel, BlockPos pPos) {
        return pLevel.getBlockState(pPos.below()).is(BlockTags.DIRT) || pLevel.getBlockState(pPos.below()).is(BlockTags.SAND);
    }

    public boolean skipRendering(BlockState pState, BlockState pAdjacentBlockState, Direction pDirection) {
        return pAdjacentBlockState.is((Block)this);
    }

    public int getY(ServerLevel pLevel, BlockPos pPos) {
        return Mth.clamp((int)pLevel.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pPos.getX(), pPos.getZ()), (int)(pLevel.dimension() == IcariaDimensions.ICARIA ? 84 : 64), (int)(pLevel.getHeight() - 5));
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        CivilianRevenantEntity spawn;
        BlockPos blockPos = pPos.below();
        EntityType<CivilianRevenantEntity> revenant = IcariaEntityTypes.CIVILIAN_REVENANT.get();
        if (pLevel.dimension() != IcariaDimensions.ICARIA && pLevel.dimensionType().natural() && pLevel.getBlockState(blockPos).isValidSpawn((BlockGetter)pLevel, blockPos, revenant) && pLevel.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && pRandom.nextInt(2000) == 0 && (spawn = (CivilianRevenantEntity)revenant.spawn(pLevel, pPos, MobSpawnType.STRUCTURE)) != null) {
            spawn.setPortalCooldown();
        }
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pRandom.nextInt(100) == 0) {
            pLevel.playLocalSound((double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, SoundEvents.PORTAL_AMBIENT, SoundSource.BLOCKS, 0.5f, pRandom.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (double)pPos.getX() + pRandom.nextDouble();
            double d1 = (double)pPos.getY() + pRandom.nextDouble();
            double d2 = (double)pPos.getZ() + pRandom.nextDouble();
            double d3 = ((double)pRandom.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)pRandom.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)pRandom.nextFloat() - 0.5) * 0.5;
            int j = pRandom.nextInt(2) * 2 - 1;
            if (!pLevel.getBlockState(pPos.west()).is((Block)this) && !pLevel.getBlockState(pPos.east()).is((Block)this)) {
                d0 = (double)pPos.getX() + 0.5 + 0.25 * (double)j;
                d3 = (double)pRandom.nextFloat() * 2.0 * (double)j;
            } else {
                d2 = (double)pPos.getZ() + 0.5 + 0.25 * (double)j;
                d5 = (double)pRandom.nextFloat() * 2.0 * (double)j;
            }
            pLevel.addParticle((ParticleOptions)IcariaParticleTypes.PORTAL.get(), d0, d1, d2, d3, d4, d5);
        }
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.HORIZONTAL_AXIS});
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pEntity.canUsePortal(false)) {
            pEntity.setAsInsidePortal((Portal)this, pPos);
        }
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return switch (pRotation) {
            case Rotation.CLOCKWISE_90, Rotation.COUNTERCLOCKWISE_90 -> {
                switch ((Direction.Axis)pState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
                    case X: {
                        yield (BlockState)pState.setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        yield (BlockState)pState.setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                yield pState;
            }
            default -> pState;
        };
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        Direction.Axis axis = pDirection.getAxis();
        Direction.Axis horizontalAxis = (Direction.Axis)pState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
        IcariaPortalShape portalShape = new IcariaPortalShape(pLevel, pPos, horizontalAxis);
        boolean flag = axis.isHorizontal() && horizontalAxis != axis;
        return !flag && !portalShape.isComplete() && !pNeighborState.is((Block)this) && !pNeighborState.is(IcariaBlockTags.PORTAL_BLOCKS) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public DimensionTransition getPortalDestination(ServerLevel pLevel, Entity pEntity, BlockPos pPos) {
        ResourceKey<Level> resourceKey = pLevel.dimension() == IcariaDimensions.ICARIA ? Level.OVERWORLD : IcariaDimensions.ICARIA;
        ServerLevel serverLevel = pLevel.getServer().getLevel(resourceKey);
        if (serverLevel != null) {
            WorldBorder worldBorder = serverLevel.getWorldBorder();
            BlockPos blockPos = worldBorder.clampToBounds(pEntity.getX(), pEntity.getY(), pEntity.getZ());
            return this.getExitPortal(serverLevel, pEntity, pPos, blockPos, worldBorder);
        }
        return null;
    }

    @Nullable
    public DimensionTransition getExitPortal(ServerLevel pLevel, Entity pEntity, BlockPos pPos, BlockPos pExitPos, WorldBorder pWorldBorder) {
        BlockUtil.FoundRectangle foundRectangle;
        DimensionTransition.PostDimensionTransition dimensionTransition;
        Optional<BlockPos> oldPortal = this.findClosestPortalPosition(pLevel, pExitPos, pWorldBorder);
        if (oldPortal.isPresent()) {
            BlockPos blockPos = oldPortal.get();
            BlockState blockState = pLevel.getBlockState(blockPos);
            dimensionTransition = DimensionTransition.PLAY_PORTAL_SOUND.then(entity -> entity.placePortalTicket(blockPos));
            foundRectangle = BlockUtil.getLargestRectangleAround((BlockPos)blockPos, (Direction.Axis)((Direction.Axis)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, pos -> pLevel.getBlockState(pos) == blockState);
        } else {
            Direction.Axis axis = pEntity.level().getBlockState(pPos).getOptionalValue((Property)BlockStateProperties.HORIZONTAL_AXIS).orElse(Direction.Axis.X);
            Optional<BlockUtil.FoundRectangle> newPortal = this.createPortal(pLevel, pExitPos, axis);
            if (newPortal.isEmpty()) {
                return null;
            }
            foundRectangle = newPortal.get();
            dimensionTransition = DimensionTransition.PLAY_PORTAL_SOUND.then(DimensionTransition.PLACE_PORTAL_TICKET);
        }
        return this.getDimensionTransitionFromExit(pEntity, pPos, foundRectangle, pLevel, dimensionTransition);
    }

    public Optional<BlockUtil.FoundRectangle> createPortal(ServerLevel pLevel, BlockPos pPos, Direction.Axis pAxis) {
        int i;
        BlockPos.MutableBlockPos mutablePos2;
        double d = 0.0;
        BlockPos blockPos = BlockPos.ZERO;
        Direction direction = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)pAxis);
        for (BlockPos.MutableBlockPos mutablePos2 : BlockPos.spiralAround((BlockPos)pPos, (int)64, (Direction)Direction.NORTH, (Direction)Direction.EAST)) {
            double e;
            int y = this.getY(pLevel, (BlockPos)mutablePos2);
            mutablePos2.setY(y);
            if (!this.checkBelow(pLevel, (BlockPos)mutablePos2) || !this.canSet(pLevel, (BlockPos)mutablePos2) || !(d > (e = pPos.distSqr((Vec3i)mutablePos2))) && d != 0.0) continue;
            d = e;
            blockPos = mutablePos2.immutable();
        }
        BlockUtil.FoundRectangle foundRectangle = new BlockUtil.FoundRectangle(blockPos.immutable(), 3, 4);
        mutablePos2 = pPos.mutable();
        for (i = -1; i < 4; ++i) {
            for (int j = -1; j < 0; ++j) {
                mutablePos2.setWithOffset((Vec3i)blockPos, i * direction.getStepX(), j, i * direction.getStepZ());
                pLevel.setBlockAndUpdate((BlockPos)mutablePos2, pLevel.getBlockState(blockPos.below()));
            }
        }
        for (i = -1; i < 0; ++i) {
            for (int j = 0; j < 3; ++j) {
                mutablePos2.setWithOffset((Vec3i)blockPos, i * direction.getStepX(), j, i * direction.getStepZ());
                pLevel.setBlockAndUpdate((BlockPos)mutablePos2, (BlockState)IcariaBlocks.DOLOMITE_PILLAR.get().defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y));
            }
        }
        for (i = 3; i < 4; ++i) {
            for (int j = 0; j < 3; ++j) {
                mutablePos2.setWithOffset((Vec3i)blockPos, i * direction.getStepX(), j, i * direction.getStepZ());
                pLevel.setBlockAndUpdate((BlockPos)mutablePos2, (BlockState)IcariaBlocks.DOLOMITE_PILLAR.get().defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y));
            }
        }
        for (i = -1; i < 0; ++i) {
            for (int j = 3; j < 4; ++j) {
                mutablePos2.setWithOffset((Vec3i)blockPos, i * direction.getStepX(), j, i * direction.getStepZ());
                pLevel.setBlockAndUpdate((BlockPos)mutablePos2, (BlockState)IcariaBlocks.DOLOMITE_PILLAR_HEAD.get().defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN));
            }
        }
        for (i = 3; i < 4; ++i) {
            for (int j = 3; j < 4; ++j) {
                mutablePos2.setWithOffset((Vec3i)blockPos, i * direction.getStepX(), j, i * direction.getStepZ());
                pLevel.setBlockAndUpdate((BlockPos)mutablePos2, (BlockState)IcariaBlocks.DOLOMITE_PILLAR_HEAD.get().defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN));
            }
        }
        for (i = -1; i < 1; ++i) {
            for (int j = 4; j < 5; ++j) {
                mutablePos2.setWithOffset((Vec3i)blockPos, i * direction.getStepX(), j, i * direction.getStepZ());
                pLevel.setBlockAndUpdate((BlockPos)mutablePos2, (BlockState)IcariaBlocks.SMOOTH_DOLOMITE_DECO.slab.get().defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM));
            }
        }
        for (i = 2; i < 4; ++i) {
            for (int j = 4; j < 5; ++j) {
                mutablePos2.setWithOffset((Vec3i)blockPos, i * direction.getStepX(), j, i * direction.getStepZ());
                pLevel.setBlockAndUpdate((BlockPos)mutablePos2, (BlockState)IcariaBlocks.SMOOTH_DOLOMITE_DECO.slab.get().defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM));
            }
        }
        for (i = -2; i < -1; ++i) {
            for (int j = 3; j < 4; ++j) {
                mutablePos2.setWithOffset((Vec3i)blockPos, i * direction.getStepX(), j, i * direction.getStepZ());
                pLevel.setBlockAndUpdate((BlockPos)mutablePos2, (BlockState)IcariaBlocks.SMOOTH_DOLOMITE_DECO.slab.get().defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP));
            }
        }
        for (i = 4; i < 5; ++i) {
            for (int j = 3; j < 4; ++j) {
                mutablePos2.setWithOffset((Vec3i)blockPos, i * direction.getStepX(), j, i * direction.getStepZ());
                pLevel.setBlockAndUpdate((BlockPos)mutablePos2, (BlockState)IcariaBlocks.SMOOTH_DOLOMITE_DECO.slab.get().defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                mutablePos2.setWithOffset((Vec3i)blockPos, i * direction.getStepX(), j, i * direction.getStepZ());
                pLevel.setBlockAndUpdate((BlockPos)mutablePos2, (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)pAxis));
            }
        }
        return Optional.of(foundRectangle);
    }

    public DimensionTransition getDimensionTransitionFromExit(Entity pEntity, BlockPos pPos, BlockUtil.FoundRectangle pRectangle, ServerLevel pLevel, DimensionTransition.PostDimensionTransition pPostDimensionTransition) {
        Vec3 vec3;
        Direction.Axis axis;
        BlockState blockState = pEntity.level().getBlockState(pPos);
        if (blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            axis = (Direction.Axis)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
            vec3 = pEntity.getRelativePortalPosition(axis, BlockUtil.getLargestRectangleAround((BlockPos)pPos, (Direction.Axis)axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, pos -> pEntity.level().getBlockState(pos) == blockState));
        } else {
            axis = Direction.Axis.X;
            vec3 = new Vec3(0.5, 0.0, 0.0);
        }
        return this.createDimensionTransition(pLevel, pRectangle, axis, vec3, pEntity, pEntity.getDeltaMovement(), pEntity.getYRot(), pEntity.getXRot(), pPostDimensionTransition);
    }

    public DimensionTransition createDimensionTransition(ServerLevel pLevel, BlockUtil.FoundRectangle pRectangle, Direction.Axis pAxis, Vec3 pOffset, Entity pEntity, Vec3 pSpeed, float pYRot, float pXRot, DimensionTransition.PostDimensionTransition pPostDimensionTransition) {
        EntityDimensions entityDimensions = pEntity.getDimensions(pEntity.getPose());
        BlockPos blockPos = pRectangle.minCorner;
        BlockState blockState = pLevel.getBlockState(blockPos);
        Direction.Axis axis = blockState.getOptionalValue((Property)BlockStateProperties.HORIZONTAL_AXIS).orElse(Direction.Axis.X);
        boolean flag = axis == Direction.Axis.X;
        double d = pRectangle.axis1Size;
        double e = pRectangle.axis2Size;
        double f = pOffset.x() * (d - (double)entityDimensions.width()) + (double)entityDimensions.width() / 2.0;
        double g = pOffset.y() * (e - (double)entityDimensions.height());
        double h = pOffset.z() + 0.5;
        int i = pAxis == axis ? 0 : 90;
        Vec3 vec3 = new Vec3((double)blockPos.getX() + (flag ? f : h), (double)blockPos.getY() + g, (double)blockPos.getZ() + (flag ? h : f));
        return new DimensionTransition(pLevel, IcariaPortalShape.findCollisionFreePosition((Vec3)vec3, (ServerLevel)pLevel, (Entity)pEntity, (EntityDimensions)entityDimensions), pAxis == axis ? pSpeed : new Vec3(pSpeed.z, pSpeed.y, -pSpeed.x), pYRot + (float)i, pXRot, pPostDimensionTransition);
    }

    public Optional<BlockPos> findClosestPortalPosition(ServerLevel pLevel, BlockPos pExitPos, WorldBorder pWorldBorder) {
        int i = 128;
        PoiManager poiManager = pLevel.getPoiManager();
        poiManager.ensureLoadedAndValid((LevelReader)pLevel, pExitPos, i);
        return poiManager.getInSquare(type -> type.is(IcariaPoiTypes.ICARIA_PORTAL), pExitPos, i, PoiManager.Occupancy.ANY).map(PoiRecord::getPos).filter(arg_0 -> ((WorldBorder)pWorldBorder).isWithinBounds(arg_0)).filter(pos -> pLevel.getBlockState(pos).hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)).min(Comparator.comparingDouble(pos -> pos.distSqr((Vec3i)pExitPos)).thenComparingInt(Vec3i::getY));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return pState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS) == Direction.Axis.X ? IcariaShapes.IcariaPortalShapes.X : IcariaShapes.IcariaPortalShapes.Z;
    }
}

