/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.properties.Vine;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.registry.IcariaShapes;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaVineBlock
extends Block {
    public Map<BlockState, VoxelShape> map;
    public static final Map<Direction, BooleanProperty> SET_PROP_FOR_FACE = ImmutableMap.copyOf((Map)((Map)Util.make((Object)Maps.newEnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, BlockStateProperties.NORTH);
        map.put(Direction.EAST, BlockStateProperties.EAST);
        map.put(Direction.SOUTH, BlockStateProperties.SOUTH);
        map.put(Direction.WEST, BlockStateProperties.WEST);
    })));

    public IcariaVineBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(false))).setValue(IcariaBlockStateProperties.VINE, (Comparable)((Object)Vine.NONE)));
        this.map = ImmutableMap.copyOf(this.stateDefinition.getPossibleStates().stream().collect(Collectors.toMap(Function.identity(), IcariaVineBlock::calculateShape)));
    }

    public boolean canBeReplaced(BlockState pState, BlockPlaceContext pUseContext) {
        BlockState blockState = pUseContext.getLevel().getBlockState(pUseContext.getClickedPos());
        return blockState.is((Block)this) ? this.countFaces(blockState) < SET_PROP_FOR_FACE.size() : super.canBeReplaced(pState, pUseContext);
    }

    public boolean canSupportAtFace(BlockGetter pLevel, BlockPos pPos, Direction pDirection) {
        if (pDirection == Direction.DOWN) {
            return false;
        }
        if (IcariaVineBlock.isAcceptableNeighbour(pLevel, pPos.relative(pDirection), pDirection)) {
            return true;
        }
        if (pDirection.getAxis() == Direction.Axis.Y) {
            return false;
        }
        BlockState blockState = pLevel.getBlockState(pPos.above());
        BooleanProperty booleanProperty = SET_PROP_FOR_FACE.get(pDirection);
        return blockState.is((Block)this) && (Boolean)blockState.getValue((Property)booleanProperty) != false;
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState blockState = this.getUpdatedState(pState, (BlockGetter)pLevel, pPos);
        return this.hasFaces(blockState);
    }

    public boolean hasFaces(BlockState pState) {
        return this.countFaces(pState) > 0;
    }

    public static boolean isAcceptableNeighbour(BlockGetter pBlockReader, BlockPos pNeighborPos, Direction pAttachedFace) {
        return MultifaceBlock.canAttachTo((BlockGetter)pBlockReader, (Direction)pAttachedFace, (BlockPos)pNeighborPos, (BlockState)pBlockReader.getBlockState(pNeighborPos));
    }

    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return true;
    }

    public int countFaces(BlockState pState) {
        int i = 0;
        for (BooleanProperty booleanProperty : SET_PROP_FOR_FACE.values()) {
            if (!((Boolean)pState.getValue((Property)booleanProperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.NORTH, BlockStateProperties.EAST, BlockStateProperties.SOUTH, BlockStateProperties.WEST, IcariaBlockStateProperties.VINE});
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pState.is(IcariaBlocks.THORNY_VINE.get())) {
            pEntity.hurt(pLevel.damageSources().cactus(), 1.0f);
        }
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        Direction direction = Direction.getRandom((RandomSource)pRandom);
        BlockPos blockPos = pPos.relative(direction);
        if (pLevel.getGameRules().getBoolean(GameRules.RULE_DO_VINES_SPREAD) && pPos.getY() > pLevel.getMinBuildHeight() + 1 && pLevel.isAreaLoaded(pPos, 0)) {
            if (pRandom.nextInt(4) == 0) {
                if (pState.getValue(IcariaBlockStateProperties.VINE) == Vine.NONE || pState.getValue(IcariaBlockStateProperties.VINE) == Vine.BLOOMING || pState.getValue(IcariaBlockStateProperties.VINE) == Vine.RIPE || pState.getValue(IcariaBlockStateProperties.VINE) == Vine.VINE) {
                    if (pLevel.getBlockState(pPos.below()).isAir()) {
                        if (pRandom.nextInt(8) == 0) {
                            pLevel.setBlockAndUpdate(pPos.below(1), (BlockState)this.setPropForFace(pState).setValue(IcariaBlockStateProperties.VINE, (Comparable)((Object)Vine.DEAD)));
                        } else {
                            pLevel.setBlockAndUpdate(pPos.below(1), (BlockState)this.setPropForFace(pState).setValue(IcariaBlockStateProperties.VINE, (Comparable)((Object)Vine.GROWING)));
                        }
                    } else if (pLevel.getBlockState(pPos.below(2)).isAir() && pLevel.getBlockState(pPos.below()).hasProperty(IcariaBlockStateProperties.VINE) && pLevel.getBlockState(pPos.below()).getValue(IcariaBlockStateProperties.VINE) == Vine.GROWING) {
                        if (pRandom.nextInt(8) == 0) {
                            pLevel.setBlockAndUpdate(pPos.below(2), (BlockState)this.setPropForFace(pState).setValue(IcariaBlockStateProperties.VINE, (Comparable)((Object)Vine.DEAD)));
                        } else {
                            pLevel.setBlockAndUpdate(pPos.below(2), (BlockState)this.setPropForFace(pState).setValue(IcariaBlockStateProperties.VINE, (Comparable)((Object)Vine.GROWING)));
                        }
                        if (pRandom.nextInt(2) == 0) {
                            pLevel.setBlockAndUpdate(pPos.below(1), (BlockState)this.setPropForFace(pState).setValue(IcariaBlockStateProperties.VINE, (Comparable)((Object)Vine.NONE)));
                        } else {
                            pLevel.setBlockAndUpdate(pPos.below(1), (BlockState)this.setPropForFace(pState).setValue(IcariaBlockStateProperties.VINE, (Comparable)((Object)Vine.VINE)));
                        }
                    }
                }
            } else {
                if (direction.getAxis().isHorizontal() && !((Boolean)pState.getValue((Property)IcariaVineBlock.getPropForFace(direction))).booleanValue() && IcariaVineBlock.isAcceptableNeighbour((BlockGetter)pLevel, blockPos, direction)) {
                    pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)IcariaVineBlock.getPropForFace(direction), (Comparable)Boolean.valueOf(true)));
                }
                if (pState.getValue(IcariaBlockStateProperties.VINE) == Vine.NONE) {
                    if (pState.is(IcariaBlocks.BLOOMY_VINE.get())) {
                        if (pRandom.nextInt(2) == 0) {
                            pLevel.setBlockAndUpdate(pPos, (BlockState)this.setPropForFace(pState).setValue(IcariaBlockStateProperties.VINE, (Comparable)((Object)Vine.BLOOMING)));
                        }
                    } else if (pState.is(IcariaBlocks.BRUSHY_VINE.get()) && pRandom.nextInt(2) == 0) {
                        pLevel.setBlockAndUpdate(pPos, (BlockState)this.setPropForFace(pState).setValue(IcariaBlockStateProperties.VINE, (Comparable)((Object)Vine.RIPE)));
                    }
                } else if (pState.getValue(IcariaBlockStateProperties.VINE) == Vine.BLOOMING && pState.is(IcariaBlocks.BLOOMY_VINE.get()) && pRandom.nextInt(2) == 0) {
                    pLevel.setBlockAndUpdate(pPos, (BlockState)this.setPropForFace(pState).setValue(IcariaBlockStateProperties.VINE, (Comparable)((Object)Vine.RIPE)));
                }
            }
        }
    }

    public PathType getBlockPathType(BlockState pState, BlockGetter pLevel, BlockPos pPos, @Nullable Mob pMob) {
        return pState.is(IcariaBlocks.THORNY_VINE.get()) ? PathType.DAMAGE_OTHER : super.getBlockPathType(pState, pLevel, pPos, pMob);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState state = pContext.getLevel().getBlockState(pContext.getClickedPos());
        boolean check = state.is((Block)this);
        BlockState interState = pContext.getLevel().getRandom().nextBoolean() ? this.defaultBlockState() : (BlockState)this.defaultBlockState().setValue(IcariaBlockStateProperties.VINE, (Comparable)((Object)Vine.VINE));
        BlockState finalState = check ? state : interState;
        for (Direction direction : pContext.getNearestLookingDirections()) {
            boolean finalCheck;
            if (direction == Direction.DOWN || direction == Direction.UP) continue;
            BooleanProperty booleanProperty = IcariaVineBlock.getPropForFace(direction);
            boolean bl = finalCheck = check && (Boolean)state.getValue((Property)booleanProperty) != false;
            if (finalCheck || !this.canSupportAtFace((BlockGetter)pContext.getLevel(), pContext.getClickedPos(), direction)) continue;
            return (BlockState)finalState.setValue((Property)booleanProperty, (Comparable)Boolean.valueOf(true));
        }
        return check ? finalState : null;
    }

    public BlockState getUpdatedState(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        BlockState blockstate = null;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanProperty = IcariaVineBlock.getPropForFace(direction);
            if (!((Boolean)pState.getValue((Property)booleanProperty)).booleanValue()) continue;
            boolean flag = this.canSupportAtFace(pLevel, pPos, direction);
            if (!flag) {
                if (blockstate == null) {
                    blockstate = pLevel.getBlockState(pPos.above());
                }
                flag = blockstate.is((Block)this) && (Boolean)blockstate.getValue((Property)booleanProperty) != false;
            }
            pState = (BlockState)pState.setValue((Property)booleanProperty, (Comparable)Boolean.valueOf(flag));
        }
        return pState;
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return switch (pMirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)pState.setValue((Property)BlockStateProperties.NORTH, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.SOUTH)))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)pState.setValue((Property)BlockStateProperties.EAST, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.WEST)))).setValue((Property)BlockStateProperties.WEST, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.EAST)));
            default -> super.mirror(pState, pMirror);
        };
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return switch (pRotation) {
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue((Property)BlockStateProperties.NORTH, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.WEST)))).setValue((Property)BlockStateProperties.EAST, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.NORTH)))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.EAST)))).setValue((Property)BlockStateProperties.WEST, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.SOUTH)));
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue((Property)BlockStateProperties.NORTH, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.SOUTH)))).setValue((Property)BlockStateProperties.EAST, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.WEST)))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.NORTH)))).setValue((Property)BlockStateProperties.WEST, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue((Property)BlockStateProperties.NORTH, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.EAST)))).setValue((Property)BlockStateProperties.EAST, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.SOUTH)))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.WEST)))).setValue((Property)BlockStateProperties.WEST, (Comparable)((Boolean)pState.getValue((Property)BlockStateProperties.NORTH)));
            default -> pState;
        };
    }

    public BlockState setPropForFace(BlockState pState) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty property = IcariaVineBlock.getPropForFace(direction);
            pState = (BlockState)pState.setValue((Property)property, (Comparable)((Boolean)pState.getValue((Property)property)));
        }
        return pState;
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        BlockState interState = this.getUpdatedState(pState, (BlockGetter)pLevel, pCurrentPos);
        BlockState finalState = this.hasFaces(interState) ? interState : Blocks.AIR.defaultBlockState();
        return pFacing != Direction.DOWN ? finalState : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public static BooleanProperty getPropForFace(Direction pDirection) {
        return SET_PROP_FOR_FACE.get(pDirection);
    }

    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pResult) {
        if (pState.is(IcariaBlocks.BLOOMY_VINE.get()) && pState.getValue(IcariaBlockStateProperties.VINE) == Vine.RIPE) {
            pLevel.playSound(null, pPos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS);
            pLevel.setBlockAndUpdate(pPos, (BlockState)this.setPropForFace(pState).setValue(IcariaBlockStateProperties.VINE, (Comparable)((Object)Vine.NONE)));
            Block.popResource((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)IcariaItems.VINEBERRIES.get()));
            return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
        }
        if (pState.is(IcariaBlocks.BRUSHY_VINE.get()) && pState.getValue(IcariaBlockStateProperties.VINE) == Vine.RIPE) {
            pLevel.playSound(null, pPos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS);
            pLevel.setBlockAndUpdate(pPos, (BlockState)this.setPropForFace(pState).setValue(IcariaBlockStateProperties.VINE, (Comparable)((Object)Vine.NONE)));
            Block.popResource((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)IcariaItems.VINE_SPROUT.get()));
            return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
        }
        return InteractionResult.PASS;
    }

    public static VoxelShape calculateShape(BlockState pState) {
        VoxelShape voxelShape = Shapes.empty();
        if (((Boolean)pState.getValue((Property)BlockStateProperties.NORTH)).booleanValue()) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)IcariaShapes.IcariaVineShapes.NORTH);
        }
        if (((Boolean)pState.getValue((Property)BlockStateProperties.EAST)).booleanValue()) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)IcariaShapes.IcariaVineShapes.EAST);
        }
        if (((Boolean)pState.getValue((Property)BlockStateProperties.SOUTH)).booleanValue()) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)IcariaShapes.IcariaVineShapes.SOUTH);
        }
        if (((Boolean)pState.getValue((Property)BlockStateProperties.WEST)).booleanValue()) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)IcariaShapes.IcariaVineShapes.WEST);
        }
        return voxelShape.isEmpty() ? Shapes.block() : voxelShape;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.map.get(pState);
    }
}

