/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.block.MediterraneanWaterloggedBlock;
import com.axanthic.icaria.common.entity.IcariaHangingSignBlockEntity;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaFluids;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaWallHangingSignBlock
extends WallHangingSignBlock
implements MediterraneanWaterloggedBlock {
    public IcariaWallHangingSignBlock(WoodType pType, BlockBehaviour.Properties pProperties) {
        super(pType, pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, BlockStateProperties.WATERLOGGED});
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new IcariaHangingSignBlockEntity(pPos, pState);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState blockState = this.defaultBlockState();
        BlockPos blockPos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        FluidState fluidState = level.getFluidState(blockPos);
        for (Direction direction : pContext.getNearestLookingDirections()) {
            Direction.Axis axis = direction.getAxis();
            if (!axis.isHorizontal() || axis.test(pContext.getClickedFace()) || !(blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction.getOpposite())).canSurvive((LevelReader)level, blockPos) || !this.canPlace(blockState, (LevelReader)level, blockPos)) continue;
            return (BlockState)((BlockState)blockState.setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == IcariaFluids.MEDITERRANEAN_WATER.get()))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        }
        return null;
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED) != false ? IcariaFluids.MEDITERRANEAN_WATER.get().getSource(false) : super.getFluidState(pState);
    }
}

