/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.block.MediterraneanWaterloggedBlock;
import com.axanthic.icaria.common.entity.IcariaSignBlockEntity;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaFluids;
import com.axanthic.icaria.common.registry.IcariaShapes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaWallSignBlock
extends WallSignBlock
implements EntityBlock,
MediterraneanWaterloggedBlock {
    public IcariaWallSignBlock(WoodType pWoodType, BlockBehaviour.Properties pProperties) {
        super(pWoodType, pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.WALL)).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction direction = this.getConnectedDirection(pState);
        BlockPos relativePos = pPos.relative(direction.getOpposite());
        return pLevel.getBlockState(relativePos).isFaceSturdy((BlockGetter)pLevel, relativePos, direction);
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.ATTACH_FACE, BlockStateProperties.HORIZONTAL_FACING, IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, BlockStateProperties.WATERLOGGED});
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new IcariaSignBlockEntity(pPos, pState);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockPos clickedPos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        for (Direction direction : pContext.getNearestLookingDirections()) {
            BlockState blockState = direction.getAxis() == Direction.Axis.Y ? (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pContext.getHorizontalDirection())).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(clickedPos).getType() == IcariaFluids.MEDITERRANEAN_WATER.get()))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(clickedPos).getType() == Fluids.WATER)) : (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.WALL)).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction.getOpposite())).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(clickedPos).getType() == IcariaFluids.MEDITERRANEAN_WATER.get()))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(clickedPos).getType() == Fluids.WATER));
            if (!blockState.canSurvive((LevelReader)pContext.getLevel(), pContext.getClickedPos())) continue;
            return blockState;
        }
        return null;
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return this.getConnectedDirection(pState).getOpposite() == pFacing && !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public Direction getConnectedDirection(BlockState pState) {
        return switch ((AttachFace)pState.getValue((Property)BlockStateProperties.ATTACH_FACE)) {
            case AttachFace.CEILING -> Direction.DOWN;
            case AttachFace.FLOOR -> Direction.UP;
            default -> (Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        };
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED) != false ? IcariaFluids.MEDITERRANEAN_WATER.get().getSource(false) : super.getFluidState(pState);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((AttachFace)pState.getValue((Property)BlockStateProperties.ATTACH_FACE)) {
            case AttachFace.FLOOR -> {
                switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    case NORTH: {
                        yield IcariaShapes.WallSignShapes.FLOOR_NORTH;
                    }
                    case EAST: {
                        yield IcariaShapes.WallSignShapes.FLOOR_EAST;
                    }
                    case SOUTH: {
                        yield IcariaShapes.WallSignShapes.FLOOR_SOUTH;
                    }
                }
                yield IcariaShapes.WallSignShapes.FLOOR_WEST;
            }
            case AttachFace.WALL -> {
                switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    case NORTH: {
                        yield IcariaShapes.WallSignShapes.WALL_NORTH;
                    }
                    case EAST: {
                        yield IcariaShapes.WallSignShapes.WALL_EAST;
                    }
                    case SOUTH: {
                        yield IcariaShapes.WallSignShapes.WALL_SOUTH;
                    }
                }
                yield IcariaShapes.WallSignShapes.WALL_WEST;
            }
            default -> {
                switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    case NORTH: {
                        yield IcariaShapes.WallSignShapes.CEILING_NORTH;
                    }
                    case EAST: {
                        yield IcariaShapes.WallSignShapes.CEILING_EAST;
                    }
                    case SOUTH: {
                        yield IcariaShapes.WallSignShapes.CEILING_SOUTH;
                    }
                }
                yield IcariaShapes.WallSignShapes.CEILING_WEST;
            }
        };
    }
}

