/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.block.IcariaAbstractSkullBlock;
import com.axanthic.icaria.common.registry.IcariaShapes;
import com.axanthic.icaria.common.util.IcariaSkullBlockType;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaWallSkullBlock
extends IcariaAbstractSkullBlock {
    public IcariaWallSkullBlock(float pOffset, IcariaSkullBlockType pType, BlockBehaviour.Properties pProperties) {
        super(pOffset, pType, pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        for (Direction direction : pContext.getNearestLookingDirections()) {
            if (!direction.getAxis().isHorizontal() || pContext.getLevel().getBlockState(pContext.getClickedPos().relative(direction)).canBeReplaced(pContext)) continue;
            return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction.getOpposite());
        }
        return null;
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return (BlockState)pState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pMirror.mirror((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public String getDescriptionId() {
        return this.asItem().getDescriptionId();
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case Direction.NORTH -> IcariaShapes.NORTH;
            case Direction.EAST -> IcariaShapes.EAST;
            case Direction.SOUTH -> IcariaShapes.SOUTH;
            default -> IcariaShapes.WEST;
        };
    }
}

