/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.config.IcariaConfig;
import com.axanthic.icaria.common.entity.KettleBlockEntity;
import com.axanthic.icaria.common.properties.Kettle;
import com.axanthic.icaria.common.registry.IcariaBlockEntityTypes;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.registry.IcariaParticleTypes;
import com.axanthic.icaria.common.registry.IcariaShapes;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import com.axanthic.icaria.data.tags.IcariaItemTags;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class KettleBlock
extends BaseEntityBlock {
    public static final MapCodec<KettleBlock> CODEC = Block.simpleCodec(KettleBlock::new);

    public KettleBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue(IcariaBlockStateProperties.KETTLE, (Comparable)((Object)Kettle.EMPTY))).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canDropFromExplosion(BlockState pState, BlockGetter pLevel, BlockPos pPos, Explosion pExplosion) {
        return false;
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        int n;
        BlockEntity blockEntity = pLevel.getBlockEntity(KettleBlock.getBlockEntityPosition(pState, pPos));
        if (blockEntity instanceof KettleBlockEntity) {
            KettleBlockEntity blockEntity2 = (KettleBlockEntity)blockEntity;
            n = blockEntity2.getComparatorInput();
        } else {
            n = 0;
        }
        return n;
    }

    public int getLightEmission(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return (Boolean)pState.getValue((Property)BlockStateProperties.LIT) != false ? 13 : 0;
    }

    public double getX(BlockState pState) {
        return switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case Direction.NORTH, Direction.SOUTH -> 0.5;
            case Direction.EAST -> 0.65625;
            case Direction.WEST -> 0.34375;
            default -> 1.0;
        };
    }

    public double getZ(BlockState pState) {
        return switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case Direction.NORTH -> 0.34375;
            case Direction.EAST, Direction.WEST -> 0.5;
            case Direction.SOUTH -> 0.65625;
            default -> 1.0;
        };
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
            if (pState.getValue(IcariaBlockStateProperties.KETTLE) == Kettle.ACTIVE) {
                pLevel.addParticle((ParticleOptions)IcariaParticleTypes.STEAM.get(), (double)pPos.getX() + this.getX(pState) + pRandom.nextDouble() / 8.0 * (double)(pRandom.nextBoolean() ? 1 : -1), (double)pPos.getY() + 0.875, (double)pPos.getZ() + this.getZ(pState) + pRandom.nextDouble() / 8.0 * (double)(pRandom.nextBoolean() ? 1 : -1), 0.0, 0.0, 0.0);
                pLevel.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, (double)pPos.getX() + this.getX(pState) + pRandom.nextDouble() / 4.0 * (double)(pRandom.nextBoolean() ? 1 : -1), (double)pPos.getY() + 0.125, (double)pPos.getZ() + this.getZ(pState) + pRandom.nextDouble() / 4.0 * (double)(pRandom.nextBoolean() ? 1 : -1), 0.0, 0.0, 0.0);
                if (((Boolean)IcariaConfig.KETTLE_SOUNDS.get()).booleanValue() && pRandom.nextDouble() < 0.1) {
                    pLevel.playLocalSound(pPos, SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
            } else if (pState.getValue(IcariaBlockStateProperties.KETTLE) == Kettle.BREWING) {
                pLevel.addParticle((ParticleOptions)IcariaParticleTypes.BUBBLE.get(), (double)pPos.getX() + this.getX(pState) + pRandom.nextDouble() / 8.0 * (double)(pRandom.nextBoolean() ? 1 : -1), (double)pPos.getY() + 0.75, (double)pPos.getZ() + this.getZ(pState) + pRandom.nextDouble() / 8.0 * (double)(pRandom.nextBoolean() ? 1 : -1), 0.0, 0.0, 0.0);
                pLevel.addParticle((ParticleOptions)IcariaParticleTypes.STEAM.get(), (double)pPos.getX() + this.getX(pState) + pRandom.nextDouble() / 8.0 * (double)(pRandom.nextBoolean() ? 1 : -1), (double)pPos.getY() + 0.875, (double)pPos.getZ() + this.getZ(pState) + pRandom.nextDouble() / 8.0 * (double)(pRandom.nextBoolean() ? 1 : -1), 0.0, 0.0, 0.0);
                pLevel.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, (double)pPos.getX() + this.getX(pState) + pRandom.nextDouble() / 4.0 * (double)(pRandom.nextBoolean() ? 1 : -1), (double)pPos.getY() + 0.125, (double)pPos.getZ() + this.getZ(pState) + pRandom.nextDouble() / 4.0 * (double)(pRandom.nextBoolean() ? 1 : -1), 0.0, 0.0, 0.0);
                if (((Boolean)IcariaConfig.KETTLE_SOUNDS.get()).booleanValue() && pRandom.nextDouble() < 0.1) {
                    pLevel.playLocalSound(pPos, SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                } else if (((Boolean)IcariaConfig.KETTLE_SOUNDS.get()).booleanValue() && pRandom.nextDouble() > 0.9) {
                    pLevel.playLocalSound(pPos, IcariaSoundEvents.KETTLE_CONCOCT, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
            }
        }
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.DOUBLE_BLOCK_HALF, BlockStateProperties.HORIZONTAL_FACING, IcariaBlockStateProperties.KETTLE, BlockStateProperties.LIT});
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof KettleBlockEntity) {
            KettleBlockEntity kettleBlockEntity = (KettleBlockEntity)blockEntity;
            if (pEntity instanceof ItemEntity) {
                ItemStack item;
                ItemEntity itemEntity = (ItemEntity)pEntity;
                if (pState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER && pState.getValue(IcariaBlockStateProperties.KETTLE) != Kettle.EMPTY && (item = itemEntity.getItem()).is(IcariaItemTags.KETTLE_ITEMS)) {
                    ItemStack itemStack = new ItemStack((ItemLike)item.getItem());
                    item.shrink(1);
                    kettleBlockEntity.resetProgress();
                    kettleBlockEntity.deque.offer(itemStack);
                    pLevel.playSound(null, pPos, IcariaSoundEvents.KETTLE_CONSUME, SoundSource.BLOCKS);
                    pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)((BlockState)pState.setValue(IcariaBlockStateProperties.KETTLE, (Comparable)((Object)Kettle.ACTIVE))).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)));
                    pLevel.setBlockAndUpdate(pPos.above(), (BlockState)((BlockState)((BlockState)pState.setValue(IcariaBlockStateProperties.KETTLE, (Comparable)((Object)Kettle.ACTIVE))).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)));
                }
            }
        }
    }

    public void onBlockExploded(BlockState pState, Level pLevel, BlockPos pPos, Explosion pExplosion) {
        if (pState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
            pLevel.setBlock(pPos.above(), Blocks.AIR.defaultBlockState(), 3);
        } else {
            pLevel.setBlock(pPos.below(), Blocks.AIR.defaultBlockState(), 3);
        }
        super.onBlockExploded(pState, pLevel, pPos, pExplosion);
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.getBlock() != pNewState.getBlock() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof KettleBlockEntity) {
            KettleBlockEntity blockEntity2 = (KettleBlockEntity)blockEntity;
            if (pLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pLevel;
                blockEntity2.drops((Level)serverLevel);
                Block.popResource((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)IcariaItems.KETTLE.get()));
            }
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        pLevel.setBlock(pPos.above(), (BlockState)pState.setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        if (pState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
            return new KettleBlockEntity(pPos, pState);
        }
        return null;
    }

    public static BlockPos getBlockEntityPosition(BlockState pState, BlockPos pPos) {
        if (pState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
            return pPos;
        }
        return pPos.below();
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockPos blockPos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        if (blockPos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(blockPos.above()).canBeReplaced(pContext)) {
            return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
        }
        return null;
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return (BlockState)pState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pMirror.mirror((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (pState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
            pLevel.setBlock(pPos.above(), Blocks.AIR.defaultBlockState(), 3);
        } else {
            pLevel.setBlock(pPos.below(), Blocks.AIR.defaultBlockState(), 3);
        }
        return super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pResult) {
        ItemStack item = pPlayer.getItemInHand(pHand);
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof KettleBlockEntity) {
            KettleBlockEntity kettleBlockEntity = (KettleBlockEntity)blockEntity;
            if (pState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
                if (pState.getValue(IcariaBlockStateProperties.KETTLE) == Kettle.EMPTY) {
                    if (item.is(IcariaItems.MEDITERRANEAN_WATER_BUCKET.get())) {
                        itemStack = new ItemStack((ItemLike)Items.BUCKET);
                        kettleBlockEntity.resetProgress();
                        kettleBlockEntity.deque.clear();
                        pLevel.playSound(null, pPos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS);
                        pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)pState.setValue(IcariaBlockStateProperties.KETTLE, (Comparable)((Object)Kettle.FILLED))).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER));
                        pLevel.setBlockAndUpdate(pPos.above(), (BlockState)((BlockState)pState.setValue(IcariaBlockStateProperties.KETTLE, (Comparable)((Object)Kettle.FILLED))).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER));
                        pPlayer.awardStat(Stats.ITEM_USED.get((Object)IcariaItems.MEDITERRANEAN_WATER_BUCKET.get()));
                        if (!pPlayer.isCreative()) {
                            pPlayer.setItemInHand(pHand, itemStack);
                        }
                        return ItemInteractionResult.SUCCESS;
                    }
                } else {
                    if (item.is(IcariaItemTags.KETTLE_ITEMS)) {
                        itemStack = new ItemStack((ItemLike)item.getItem());
                        kettleBlockEntity.resetProgress();
                        kettleBlockEntity.deque.offer(itemStack);
                        pLevel.playSound(null, pPos, IcariaSoundEvents.KETTLE_CONSUME, SoundSource.BLOCKS);
                        pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)((BlockState)pState.setValue(IcariaBlockStateProperties.KETTLE, (Comparable)((Object)Kettle.ACTIVE))).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)));
                        pLevel.setBlockAndUpdate(pPos.above(), (BlockState)((BlockState)((BlockState)pState.setValue(IcariaBlockStateProperties.KETTLE, (Comparable)((Object)Kettle.ACTIVE))).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)));
                        pPlayer.awardStat(Stats.ITEM_USED.get((Object)item.getItem()));
                        if (!pPlayer.isCreative()) {
                            item.shrink(1);
                        }
                        return ItemInteractionResult.SUCCESS;
                    }
                    return ItemInteractionResult.FAIL;
                }
                return ItemInteractionResult.FAIL;
            }
            return ItemInteractionResult.FAIL;
        }
        return ItemInteractionResult.FAIL;
    }

    public MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((DoubleBlockHalf)pState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)) {
            default -> throw new MatchException(null, null);
            case DoubleBlockHalf.UPPER -> {
                switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    case NORTH: {
                        yield IcariaShapes.KettleShapes.UPPER_NORTH;
                    }
                    case EAST: {
                        yield IcariaShapes.KettleShapes.UPPER_EAST;
                    }
                    case SOUTH: {
                        yield IcariaShapes.KettleShapes.UPPER_SOUTH;
                    }
                }
                yield IcariaShapes.KettleShapes.UPPER_WEST;
            }
            case DoubleBlockHalf.LOWER -> {
                switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    case NORTH: {
                        yield IcariaShapes.KettleShapes.LOWER_NORTH;
                    }
                    case EAST: {
                        yield IcariaShapes.KettleShapes.LOWER_EAST;
                    }
                    case SOUTH: {
                        yield IcariaShapes.KettleShapes.LOWER_SOUTH;
                    }
                }
                yield IcariaShapes.KettleShapes.LOWER_WEST;
            }
        };
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return !pLevel.isClientSide() ? BaseEntityBlock.createTickerHelper(pBlockEntityType, IcariaBlockEntityTypes.KETTLE.get(), KettleBlockEntity::tick) : null;
    }
}

