/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.config.IcariaConfig;
import com.axanthic.icaria.common.entity.KilnBlockEntity;
import com.axanthic.icaria.common.entity.KilnRedirectorBlockEntity;
import com.axanthic.icaria.common.menu.provider.KilnMenuProvider;
import com.axanthic.icaria.common.registry.IcariaBlockEntityTypes;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.registry.IcariaShapes;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class KilnBlock
extends BaseEntityBlock {
    public static final MapCodec<KilnBlock> CODEC = Block.simpleCodec(KilnBlock::new);

    public KilnBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canDropFromExplosion(BlockState pState, BlockGetter pLevel, BlockPos pPos, Explosion pExplosion) {
        return false;
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        int n;
        BlockEntity blockEntity = pLevel.getBlockEntity(KilnBlock.getBlockEntityPosition(pState, pPos));
        if (blockEntity instanceof KilnBlockEntity) {
            KilnBlockEntity blockEntity2 = (KilnBlockEntity)blockEntity;
            n = blockEntity2.getComparatorInput();
        } else {
            n = 0;
        }
        return n;
    }

    public int getLightEmission(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return (Boolean)pState.getValue((Property)BlockStateProperties.LIT) != false ? 13 : 0;
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.getValue((Property)BlockStateProperties.LIT)).booleanValue() && pState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
            pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pPos.getX() + 0.5 + pRandom.nextDouble() / 8.0 * (double)(pRandom.nextBoolean() ? 1 : -1), (double)pPos.getY() + 2.0, (double)pPos.getZ() + 0.5 + pRandom.nextDouble() / 8.0 * (double)(pRandom.nextBoolean() ? 1 : -1), 0.0, 0.0, 0.0);
            if (((Boolean)IcariaConfig.KILN_SOUNDS.get()).booleanValue() && pRandom.nextDouble() < 0.1) {
                pLevel.playLocalSound((double)pPos.getX() + 0.5, (double)pPos.getY() + 1.0, (double)pPos.getZ() + 0.5, SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            if (((Boolean)IcariaConfig.RENDER_KILN_ITEMS.get()).booleanValue()) {
                pLevel.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, (double)pPos.getX() + 0.5 + pRandom.nextDouble() / 8.0 * (double)(pRandom.nextBoolean() ? 1 : -1), (double)pPos.getY() + 0.25, (double)pPos.getZ() + 0.5 + pRandom.nextDouble() / 8.0 * (double)(pRandom.nextBoolean() ? 1 : -1), 0.0, 0.0, 0.0);
                pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pPos.getX() + 0.5 + pRandom.nextDouble() / 8.0 * (double)(pRandom.nextBoolean() ? 1 : -1), (double)pPos.getY() + 0.75, (double)pPos.getZ() + 0.5 + pRandom.nextDouble() / 8.0 * (double)(pRandom.nextBoolean() ? 1 : -1), 0.0, 0.0, 0.0);
            }
        }
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.DOUBLE_BLOCK_HALF, BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.LIT});
    }

    public void onBlockExploded(BlockState pState, Level pLevel, BlockPos pPos, Explosion pExplosion) {
        if (pState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
            pLevel.setBlock(pPos.above(), Blocks.AIR.defaultBlockState(), 3);
        } else {
            pLevel.setBlock(pPos.below(), Blocks.AIR.defaultBlockState(), 3);
        }
        super.onBlockExploded(pState, pLevel, pPos, pExplosion);
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.getBlock() != pNewState.getBlock() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof KilnBlockEntity) {
            KilnBlockEntity blockEntity2 = (KilnBlockEntity)blockEntity;
            if (pLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pLevel;
                blockEntity2.drops((Level)serverLevel);
                blockEntity2.getRecipesToAwardAndPopExperience(serverLevel, Vec3.atCenterOf((Vec3i)pPos));
                Block.popResource((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)IcariaItems.KILN.get()));
            }
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        pLevel.setBlock(pPos.above(), (BlockState)pState.setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        if (pState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
            return new KilnBlockEntity(pPos, pState);
        }
        return new KilnRedirectorBlockEntity(pPos, pState);
    }

    public static BlockPos getBlockEntityPosition(BlockState pState, BlockPos pPos) {
        if (pState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
            return pPos;
        }
        return pPos.below();
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockPos blockPos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        if (blockPos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(blockPos.above()).canBeReplaced(pContext)) {
            return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
        }
        return null;
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return (BlockState)pState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pMirror.mirror((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (pState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
            pLevel.setBlock(pPos.above(), Blocks.AIR.defaultBlockState(), 3);
        } else {
            pLevel.setBlock(pPos.below(), Blocks.AIR.defaultBlockState(), 3);
        }
        return super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pResult) {
        BlockPos blockEntityPosition = KilnBlock.getBlockEntityPosition(pState, pPos);
        BlockEntity blockEntity = pLevel.getBlockEntity(blockEntityPosition);
        if (!pLevel.isClientSide() && pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            if (blockEntity instanceof KilnBlockEntity || blockEntity instanceof KilnRedirectorBlockEntity) {
                serverPlayer.openMenu((MenuProvider)new KilnMenuProvider(blockEntityPosition), blockEntityPosition);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((DoubleBlockHalf)pState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)) {
            default -> throw new MatchException(null, null);
            case DoubleBlockHalf.UPPER -> {
                switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    case NORTH: {
                        yield IcariaShapes.KilnShapes.UPPER_NORTH;
                    }
                    case EAST: {
                        yield IcariaShapes.KilnShapes.UPPER_EAST;
                    }
                    case SOUTH: {
                        yield IcariaShapes.KilnShapes.UPPER_SOUTH;
                    }
                }
                yield IcariaShapes.KilnShapes.UPPER_WEST;
            }
            case DoubleBlockHalf.LOWER -> {
                switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    case NORTH: {
                        yield IcariaShapes.KilnShapes.LOWER_NORTH;
                    }
                    case EAST: {
                        yield IcariaShapes.KilnShapes.LOWER_EAST;
                    }
                    case SOUTH: {
                        yield IcariaShapes.KilnShapes.LOWER_SOUTH;
                    }
                }
                yield IcariaShapes.KilnShapes.LOWER_WEST;
            }
        };
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return !pLevel.isClientSide() ? BaseEntityBlock.createTickerHelper(pBlockEntityType, IcariaBlockEntityTypes.KILN.get(), KilnBlockEntity::tick) : null;
    }
}

