/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.block.MediterraneanWaterloggedBlock;
import com.axanthic.icaria.common.entity.LootVaseEntity;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import com.axanthic.icaria.common.registry.IcariaFluids;
import com.axanthic.icaria.common.registry.IcariaLootTables;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LootVaseBlock
extends Block
implements MediterraneanWaterloggedBlock,
SimpleWaterloggedBlock {
    public LootVaseBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, BlockStateProperties.WATERLOGGED});
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        pLevel.scheduleTick(pPos, (Block)this, 2);
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pLevel.getBlockState(pPos.below()).canBeReplaced()) {
            LootVaseEntity entity = new LootVaseEntity(IcariaEntityTypes.LOOT_VASE.get(), (Level)pLevel, pState, pPos);
            entity.moveTo(pPos, 0.0f, 0.0f);
            pLevel.addFreshEntity((Entity)entity);
            pLevel.removeBlock(pPos, false);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Fluid fluid = pContext.getLevel().getFluidState(pContext.getClickedPos()).getType();
        return (BlockState)((BlockState)super.getStateForPlacement(pContext).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)Boolean.valueOf(fluid == IcariaFluids.MEDITERRANEAN_WATER.get()))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluid == Fluids.WATER));
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        pLevel.scheduleTick(pCurrentPos, (Block)this, 2);
        return super.updateShape(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED) != false ? IcariaFluids.MEDITERRANEAN_WATER.get().getSource(false) : ((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState));
    }

    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pResult) {
        if (pLevel.isClientSide() || !pPlayer.getMainHandItem().isEmpty() || !pPlayer.getOffhandItem().isEmpty() || pPlayer.isPassenger() || pPlayer.isVehicle()) {
            return InteractionResult.FAIL;
        }
        LootVaseEntity entity = new LootVaseEntity(IcariaEntityTypes.LOOT_VASE.get(), pLevel, pState, pPos);
        entity.moveTo(pPlayer.blockPosition(), 0.0f, 0.0f);
        entity.startRiding((Entity)pPlayer);
        pLevel.addFreshEntity((Entity)entity);
        pLevel.removeBlock(pPos, false);
        pPlayer.displayClientMessage((Component)Component.translatable((String)"message.landsoficaria.loot_vase"), true);
        return InteractionResult.PASS;
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return Shapes.empty();
    }

    public List<ItemStack> getDrops(BlockState pState, LootParams.Builder pBuilder) {
        LootParams lootContext = pBuilder.withParameter(LootContextParams.BLOCK_STATE, (Object)pState).create(LootContextParamSets.BLOCK);
        ResourceKey<LootTable> lootTable = pState.is(IcariaBlocks.RED_LOOT_VASE.get()) ? IcariaLootTables.RED_LOOT_VASE_LOOT : (pState.is(IcariaBlocks.LOST_LOOT_VASE.get()) ? IcariaLootTables.LOST_LOOT_VASE_LOOT : IcariaLootTables.CYAN_LOOT_VASE_LOOT);
        return lootContext.getLevel().getServer().reloadableRegistries().getLootTable(lootTable).getRandomItems(lootContext);
    }
}

