/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.block.IcariaLeavesBlock;
import com.axanthic.icaria.common.properties.Olives;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class OliveLeavesBlock
extends IcariaLeavesBlock {
    public OliveLeavesBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(IcariaBlockStateProperties.OLIVES, (Comparable)((Object)Olives.NONE))).setValue((Property)BlockStateProperties.PERSISTENT, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return true;
    }

    @Override
    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.DISTANCE, IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, IcariaBlockStateProperties.OLIVES, BlockStateProperties.PERSISTENT, BlockStateProperties.WATERLOGGED});
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.randomTick(pState, pLevel, pPos, pRandom);
        if (pRandom.nextInt(100) == 0 && !((Boolean)pState.getValue((Property)BlockStateProperties.PERSISTENT)).booleanValue()) {
            if (pState.getValue(IcariaBlockStateProperties.OLIVES) == Olives.NONE) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue(IcariaBlockStateProperties.OLIVES, (Comparable)((Object)Olives.GREEN)), 2);
            } else if (pState.getValue(IcariaBlockStateProperties.OLIVES) == Olives.GREEN) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue(IcariaBlockStateProperties.OLIVES, (Comparable)((Object)Olives.BLACK)), 2);
            }
        }
    }

    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pResult) {
        if (pState.getValue(IcariaBlockStateProperties.OLIVES) == Olives.GREEN) {
            pLevel.playSound(null, pPos, IcariaSoundEvents.OLIVES_POP, SoundSource.BLOCKS);
            pLevel.setBlock(pPos, (BlockState)pState.setValue(IcariaBlockStateProperties.OLIVES, (Comparable)((Object)Olives.NONE)), 2);
            Block.popResource((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)IcariaItems.GREEN_OLIVES.get()));
            return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
        }
        if (pState.getValue(IcariaBlockStateProperties.OLIVES) == Olives.BLACK) {
            pLevel.playSound(null, pPos, IcariaSoundEvents.OLIVES_POP, SoundSource.BLOCKS);
            pLevel.setBlock(pPos, (BlockState)pState.setValue(IcariaBlockStateProperties.OLIVES, (Comparable)((Object)Olives.NONE)), 2);
            Block.popResource((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)IcariaItems.BLACK_OLIVES.get()));
            return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
        }
        return InteractionResult.PASS;
    }
}

