/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PillarHeadBlock
extends DirectionalBlock {
    public static final MapCodec<PillarHeadBlock> CODEC = Block.simpleCodec(PillarHeadBlock::new);

    public PillarHeadBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH));
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pList, TooltipFlag pFlag) {
        pList.add((Component)Component.translatable((String)"tooltip.landsoficaria.pillar_head.title").withStyle(ChatFormatting.GRAY));
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        if (pContext.getPlayer() != null && pContext.getPlayer().isShiftKeyDown()) {
            return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)pContext.getNearestLookingDirection().getOpposite());
        }
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)pContext.getNearestLookingDirection());
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return (BlockState)pState.setValue((Property)BlockStateProperties.FACING, (Comparable)pMirror.mirror((Direction)pState.getValue((Property)BlockStateProperties.FACING)));
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)BlockStateProperties.FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)BlockStateProperties.FACING)));
    }

    public MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }
}

