/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.block.IcariaBarrelBlock;
import com.axanthic.icaria.common.block.MediterraneanWaterloggedBlock;
import com.axanthic.icaria.common.entity.IcariaBarrelEntity;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import com.axanthic.icaria.common.registry.IcariaFluids;
import com.axanthic.icaria.common.registry.IcariaLootTables;
import com.axanthic.icaria.common.registry.IcariaShapes;
import com.axanthic.icaria.common.registry.IcariaSoundTypes;
import com.axanthic.icaria.common.registry.IcariaWoodTypes;
import com.axanthic.icaria.data.tags.IcariaBlockTags;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class RackBlock
extends Block
implements MediterraneanWaterloggedBlock,
SimpleWaterloggedBlock {
    public RackBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)IcariaBlockStateProperties.LOADED_BARREL, (Comparable)Boolean.valueOf(false))).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)IcariaBlockStateProperties.TAPPED_BARREL, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        return (Boolean)pState.getValue((Property)IcariaBlockStateProperties.FULL_RACK) != false ? 15 : 0;
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{IcariaBlockStateProperties.FULL_RACK, BlockStateProperties.HORIZONTAL_FACING, IcariaBlockStateProperties.LOADED_BARREL, IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, IcariaBlockStateProperties.TAPPED_BARREL, BlockStateProperties.WATERLOGGED});
    }

    public void onBlockExploded(BlockState pState, Level pLevel, BlockPos pPos, Explosion pExplosion) {
        int x = pPos.getX();
        int y = pPos.getY();
        int z = pPos.getZ();
        if (!pLevel.isClientSide()) {
            if (((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LOADED_BARREL)).booleanValue()) {
                pExplosion.explode();
                for (int i = -2; i <= 2; ++i) {
                    BlockPos negPos = BlockPos.containing((double)(x - i), (double)(y - i), (double)(z - i));
                    BlockPos posPos = BlockPos.containing((double)(x + i), (double)(y + i), (double)(z + i));
                    for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)negPos, (BlockPos)posPos)) {
                        BlockPos belowPos = blockPos.below();
                        if (pLevel.getRandom().nextInt(10) != 0 || !pLevel.getBlockState(blockPos).isAir() || !pLevel.getBlockState(belowPos).isSolidRender((BlockGetter)pLevel, belowPos)) continue;
                        pLevel.setBlockAndUpdate(blockPos, IcariaBlocks.GREEK_FIRE.get().defaultBlockState());
                    }
                }
            } else if (((Boolean)pState.getValue((Property)IcariaBlockStateProperties.TAPPED_BARREL)).booleanValue()) {
                for (int i = -1; i <= 1; ++i) {
                    BlockPos negPos = BlockPos.containing((double)(x - i), (double)(y - i), (double)(z - i));
                    BlockPos posPos = BlockPos.containing((double)(x + i), (double)(y + i), (double)(z + i));
                    for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)negPos, (BlockPos)posPos)) {
                        BlockPos belowPos = blockPos.below();
                        if (pLevel.getRandom().nextInt(10) != 0 || !pLevel.getBlockState(blockPos).isAir() || !pLevel.getBlockState(belowPos).isSolidRender((BlockGetter)pLevel, belowPos)) continue;
                        pLevel.setBlockAndUpdate(blockPos, IcariaBlocks.MEDITERRANEAN_WATER.get().defaultBlockState());
                    }
                }
            }
        }
        super.onBlockExploded(pState, pLevel, pPos, pExplosion);
    }

    public void onProjectileHit(Level pLevel, BlockState pState, BlockHitResult pHit, Projectile pProjectile) {
        BlockPos pos = pHit.getBlockPos();
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        if (!pLevel.isClientSide() && ((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LOADED_BARREL)).booleanValue() && pProjectile.isOnFire()) {
            pLevel.explode(null, (double)x, (double)y, (double)z, 2.0f, Level.ExplosionInteraction.BLOCK);
            for (int i = -2; i <= 2; ++i) {
                BlockPos negPos = BlockPos.containing((double)(x - i), (double)(y - i), (double)(z - i));
                BlockPos posPos = BlockPos.containing((double)(x + i), (double)(y + i), (double)(z + i));
                for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)negPos, (BlockPos)posPos)) {
                    BlockPos belowPos = blockPos.below();
                    if (pLevel.getRandom().nextInt(10) != 0 || !pLevel.getBlockState(blockPos).isAir() || !pLevel.getBlockState(belowPos).isSolidRender((BlockGetter)pLevel, belowPos)) continue;
                    pLevel.setBlockAndUpdate(blockPos, IcariaBlocks.GREEK_FIRE.get().defaultBlockState());
                }
            }
        }
        super.onProjectileHit(pLevel, pState, pHit, pProjectile);
    }

    public void playerDestroy(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @Nullable BlockEntity pBlockEntity, ItemStack pTool) {
        int x = pPos.getX();
        int y = pPos.getY();
        int z = pPos.getZ();
        if (!pLevel.isClientSide()) {
            if (((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LOADED_BARREL)).booleanValue()) {
                pLevel.explode(null, (double)x, (double)y, (double)z, 2.0f, Level.ExplosionInteraction.BLOCK);
                for (int i = -2; i <= 2; ++i) {
                    BlockPos negPos = BlockPos.containing((double)(x - i), (double)(y - i), (double)(z - i));
                    BlockPos posPos = BlockPos.containing((double)(x + i), (double)(y + i), (double)(z + i));
                    for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)negPos, (BlockPos)posPos)) {
                        BlockPos belowPos = blockPos.below();
                        if (pLevel.getRandom().nextInt(10) != 0 || !pLevel.getBlockState(blockPos).isAir() || !pLevel.getBlockState(belowPos).isSolidRender((BlockGetter)pLevel, belowPos)) continue;
                        pLevel.setBlockAndUpdate(blockPos, IcariaBlocks.GREEK_FIRE.get().defaultBlockState());
                    }
                }
            } else if (((Boolean)pState.getValue((Property)IcariaBlockStateProperties.TAPPED_BARREL)).booleanValue()) {
                for (int i = -1; i <= 1; ++i) {
                    BlockPos negPos = BlockPos.containing((double)(x - i), (double)(y - i), (double)(z - i));
                    BlockPos posPos = BlockPos.containing((double)(x + i), (double)(y + i), (double)(z + i));
                    for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)negPos, (BlockPos)posPos)) {
                        BlockPos belowPos = blockPos.below();
                        if (pLevel.getRandom().nextInt(10) != 0 || !pLevel.getBlockState(blockPos).isAir() || !pLevel.getBlockState(belowPos).isSolidRender((BlockGetter)pLevel, belowPos)) continue;
                        pLevel.setBlockAndUpdate(blockPos, IcariaBlocks.MEDITERRANEAN_WATER.get().defaultBlockState());
                    }
                }
            }
        }
        super.playerDestroy(pLevel, pPlayer, pPos, pState, pBlockEntity, pTool);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Fluid fluidState = pContext.getLevel().getFluidState(pContext.getClickedPos()).getType();
        Direction horizontalDirection = pContext.getHorizontalDirection();
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)horizontalDirection.getOpposite())).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)Boolean.valueOf(fluidState == IcariaFluids.MEDITERRANEAN_WATER.get()))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState == Fluids.WATER));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return (BlockState)pState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pMirror.mirror((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED) != false ? IcariaFluids.MEDITERRANEAN_WATER.get().getSource(false) : ((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState));
    }

    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pResult) {
        if (pLevel.isClientSide() || !pPlayer.getMainHandItem().isEmpty() || !pPlayer.getOffhandItem().isEmpty() || pPlayer.isPassenger() || pPlayer.isVehicle() || !((Boolean)pState.getValue((Property)IcariaBlockStateProperties.FULL_RACK)).booleanValue()) {
            return InteractionResult.FAIL;
        }
        IcariaBarrelEntity entity = new IcariaBarrelEntity(IcariaEntityTypes.BARREL.get(), pLevel, pState, pPos);
        entity.moveTo(pPlayer.blockPosition(), 0.0f, 0.0f);
        entity.startRiding((Entity)pPlayer);
        pLevel.addFreshEntity((Entity)entity);
        pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)((BlockState)pState.setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(false))).setValue((Property)IcariaBlockStateProperties.LOADED_BARREL, (Comparable)Boolean.valueOf(false))).setValue((Property)IcariaBlockStateProperties.TAPPED_BARREL, (Comparable)Boolean.valueOf(false)));
        pPlayer.displayClientMessage((Component)Component.translatable((String)"message.landsoficaria.barrel"), true);
        return InteractionResult.PASS;
    }

    public ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pResult) {
        Block negPos;
        Item item = pStack.getItem();
        int x = pPos.getX();
        int y = pPos.getY();
        int z = pPos.getZ();
        if (!pLevel.isClientSide() && ((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LOADED_BARREL)).booleanValue() && (pStack.is(Items.FIRE_CHARGE) || pStack.is(Items.FLINT_AND_STEEL))) {
            pLevel.explode(null, (double)x, (double)y, (double)z, 2.0f, Level.ExplosionInteraction.BLOCK);
            pPlayer.awardStat(Stats.ITEM_USED.get((Object)item));
            if (!pPlayer.isCreative()) {
                if (pStack.is(Items.FIRE_CHARGE)) {
                    pStack.shrink(1);
                } else {
                    pStack.hurtAndBreak(1, (LivingEntity)pPlayer, LivingEntity.getSlotForHand((InteractionHand)pHand));
                }
            }
            for (int i = -2; i <= 2; ++i) {
                negPos = BlockPos.containing((double)(x - i), (double)(y - i), (double)(z - i));
                BlockPos posPos = BlockPos.containing((double)(x + i), (double)(y + i), (double)(z + i));
                for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)negPos, (BlockPos)posPos)) {
                    BlockPos belowPos = blockPos.below();
                    if (pLevel.getRandom().nextInt(10) != 0 || !pLevel.getBlockState(blockPos).isAir() || !pLevel.getBlockState(belowPos).isSolidRender((BlockGetter)pLevel, belowPos)) continue;
                    pLevel.setBlockAndUpdate(blockPos, IcariaBlocks.GREEK_FIRE.get().defaultBlockState());
                }
            }
        }
        if (!((Boolean)pState.getValue((Property)IcariaBlockStateProperties.FULL_RACK)).booleanValue() && (negPos = Block.byItem((Item)item)) instanceof IcariaBarrelBlock) {
            IcariaBarrelBlock block = (IcariaBarrelBlock)negPos;
            if (this.getType() == block.getType()) {
                BlockState state = block.defaultBlockState();
                pLevel.playSound(null, pPos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS);
                pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)((BlockState)pState.setValue((Property)IcariaBlockStateProperties.FULL_RACK, (Comparable)Boolean.valueOf(true))).setValue((Property)IcariaBlockStateProperties.LOADED_BARREL, (Comparable)Boolean.valueOf(state.is(IcariaBlockTags.LOADED_BARRELS)))).setValue((Property)IcariaBlockStateProperties.TAPPED_BARREL, (Comparable)Boolean.valueOf(state.is(IcariaBlockTags.TAPPED_BARRELS))));
                if (!pPlayer.isCreative()) {
                    pStack.shrink(1);
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public SoundType getSoundType(BlockState pState, LevelReader pLevel, BlockPos pPos, @Nullable Entity pEntity) {
        return (Boolean)pState.getValue((Property)IcariaBlockStateProperties.FULL_RACK) != false ? IcariaSoundTypes.BARREL : super.getSoundType(pState, pLevel, pPos, pEntity);
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (Boolean)pState.getValue((Property)IcariaBlockStateProperties.FULL_RACK) != false ? Shapes.block() : IcariaShapes.Y4;
    }

    public WoodType getType() {
        if (this.defaultBlockState().is(IcariaBlockTags.CYPRESS_RACKS)) {
            return IcariaWoodTypes.CYPRESS;
        }
        if (this.defaultBlockState().is(IcariaBlockTags.DROUGHTROOT_RACKS)) {
            return IcariaWoodTypes.DROUGHTROOT;
        }
        if (this.defaultBlockState().is(IcariaBlockTags.FIR_RACKS)) {
            return IcariaWoodTypes.FIR;
        }
        if (this.defaultBlockState().is(IcariaBlockTags.LAUREL_RACKS)) {
            return IcariaWoodTypes.LAUREL;
        }
        if (this.defaultBlockState().is(IcariaBlockTags.OLIVE_RACKS)) {
            return IcariaWoodTypes.OLIVE;
        }
        if (this.defaultBlockState().is(IcariaBlockTags.PLANE_RACKS)) {
            return IcariaWoodTypes.PLANE;
        }
        return IcariaWoodTypes.POPULUS;
    }

    public List<ItemStack> getDrops(BlockState pState, LootParams.Builder pBuilder) {
        LootParams lootContext = pBuilder.withParameter(LootContextParams.BLOCK_STATE, (Object)pState).create(LootContextParamSets.BLOCK);
        return ((Boolean)pState.getValue((Property)IcariaBlockStateProperties.FULL_RACK)).booleanValue() ? (((Boolean)pState.getValue((Property)IcariaBlockStateProperties.LOADED_BARREL)).booleanValue() || ((Boolean)pState.getValue((Property)IcariaBlockStateProperties.TAPPED_BARREL)).booleanValue() ? List.of() : lootContext.getLevel().getServer().reloadableRegistries().getLootTable(IcariaLootTables.BARREL_LOOT).getRandomItems(lootContext)) : List.of(new ItemStack((ItemLike)this));
    }
}

