/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.block.MediterraneanWaterloggedBlock;
import com.axanthic.icaria.common.entity.StorageVaseBlockEntity;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaFluids;
import com.axanthic.icaria.common.registry.IcariaShapes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class StorageVaseBlock
extends Block
implements EntityBlock,
MediterraneanWaterloggedBlock,
SimpleWaterloggedBlock {
    public StorageVaseBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)pLevel.getBlockEntity(pPos));
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, BlockStateProperties.WATERLOGGED});
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.getBlock() != pNewState.getBlock() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof StorageVaseBlockEntity) {
            StorageVaseBlockEntity blockEntity2 = (StorageVaseBlockEntity)blockEntity;
            Containers.dropContents((Level)pLevel, (BlockPos)pPos, (Container)blockEntity2);
            pLevel.updateNeighbourForOutputSignal(pPos, (Block)this);
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new StorageVaseBlockEntity(pPos, pState);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Fluid fluid = pContext.getLevel().getFluidState(pContext.getClickedPos()).getType();
        return (BlockState)((BlockState)super.getStateForPlacement(pContext).setValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED, (Comparable)Boolean.valueOf(fluid == IcariaFluids.MEDITERRANEAN_WATER.get()))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluid == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)IcariaBlockStateProperties.MEDITERRANEAN_WATERLOGGED) != false ? IcariaFluids.MEDITERRANEAN_WATER.get().getSource(false) : ((Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState));
    }

    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pResult) {
        BlockEntity blockEntity;
        if (!pLevel.isClientSide() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof StorageVaseBlockEntity) {
            StorageVaseBlockEntity storageVaseBlockEntity = (StorageVaseBlockEntity)blockEntity;
            pPlayer.openMenu((MenuProvider)storageVaseBlockEntity);
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return IcariaShapes.STORAGE_VASE;
    }
}

