/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.block.IcariaBushBlock;
import com.axanthic.icaria.common.properties.Ripe;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaItems;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class StrawberryBushBlock
extends IcariaBushBlock {
    public StrawberryBushBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(IcariaBlockStateProperties.RIPE, (Comparable)((Object)Ripe.NONE)));
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return true;
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{IcariaBlockStateProperties.RIPE});
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.randomTick(pState, pLevel, pPos, pRandom);
        if (pRandom.nextInt(100) == 0 && pState.getValue(IcariaBlockStateProperties.RIPE) == Ripe.NONE) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue(IcariaBlockStateProperties.RIPE, (Comparable)((Object)Ripe.RIPE)), 2);
        }
    }

    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pResult) {
        if (pState.getValue(IcariaBlockStateProperties.RIPE) == Ripe.RIPE) {
            pLevel.playSound(null, pPos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS);
            pLevel.setBlock(pPos, (BlockState)pState.setValue(IcariaBlockStateProperties.RIPE, (Comparable)((Object)Ripe.NONE)), 2);
            Block.popResource((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)IcariaItems.STRAWBERRIES.get()));
            return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
        }
        return InteractionResult.PASS;
    }
}

