/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.properties.VerticalCorner;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaLootTables;
import com.axanthic.icaria.common.registry.IcariaShapes;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TripleBarrelRackBlock
extends Block {
    public TripleBarrelRackBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.BOTTOM_LEFT)));
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, IcariaBlockStateProperties.VERTICAL_CORNER});
    }

    public void onBlockExploded(BlockState pState, Level pLevel, BlockPos pPos, Explosion pExplosion) {
        BlockPos blockPos = TripleBarrelRackBlock.getPlacedBlockPosition(pState, pPos);
        Direction facing = (Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        pLevel.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
        pLevel.setBlock(blockPos.offset(facing.getCounterClockWise().getNormal()), Blocks.AIR.defaultBlockState(), 3);
        pLevel.setBlock(blockPos.above(), Blocks.AIR.defaultBlockState(), 3);
        pLevel.setBlock(blockPos.above().offset(facing.getCounterClockWise().getNormal()), Blocks.AIR.defaultBlockState(), 3);
        super.onBlockExploded(pState, pLevel, pPos, pExplosion);
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (pState.getBlock() != pNewState.getBlock() && pState.getValue(IcariaBlockStateProperties.VERTICAL_CORNER) == VerticalCorner.BOTTOM_LEFT) {
            Block.dropResources((BlockState)pState, (Level)pLevel, (BlockPos)pPos);
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockPos blockPos = TripleBarrelRackBlock.getPlacedBlockPosition(pState, pPos);
        Direction facing = (Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        pLevel.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
        pLevel.setBlock(blockPos.offset(facing.getCounterClockWise().getNormal()), Blocks.AIR.defaultBlockState(), 3);
        pLevel.setBlock(blockPos.above(), Blocks.AIR.defaultBlockState(), 3);
        pLevel.setBlock(blockPos.above().offset(facing.getCounterClockWise().getNormal()), Blocks.AIR.defaultBlockState(), 3);
        return super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        Direction facing = (Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        pLevel.setBlock(pPos.offset(facing.getCounterClockWise().getNormal()), (BlockState)pState.setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.BOTTOM_RIGHT)), 3);
        pLevel.setBlock(pPos.above(), (BlockState)pState.setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.TOP_LEFT)), 3);
        pLevel.setBlock(pPos.above().offset(facing.getCounterClockWise().getNormal()), (BlockState)pState.setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)VerticalCorner.TOP_RIGHT)), 3);
    }

    public static BlockPos getPlacedBlockPosition(BlockState pState, BlockPos pPos) {
        Direction facing = (Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (pState.getValue(IcariaBlockStateProperties.VERTICAL_CORNER) == VerticalCorner.TOP_RIGHT) {
            return pPos.below().offset(facing.getClockWise().getNormal());
        }
        if (pState.getValue(IcariaBlockStateProperties.VERTICAL_CORNER) == VerticalCorner.TOP_LEFT) {
            return pPos.below();
        }
        if (pState.getValue(IcariaBlockStateProperties.VERTICAL_CORNER) == VerticalCorner.BOTTOM_RIGHT) {
            return pPos.offset(facing.getClockWise().getNormal());
        }
        return pPos;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockPos blockPos = pContext.getClickedPos();
        Direction facing = pContext.getHorizontalDirection().getOpposite();
        Level level = pContext.getLevel();
        if (blockPos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(blockPos.offset(facing.getCounterClockWise().getNormal())).canBeReplaced(pContext) && level.getBlockState(blockPos.above()).canBeReplaced(pContext) && level.getBlockState(blockPos.above().offset(facing.getCounterClockWise().getNormal())).canBeReplaced(pContext)) {
            return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
        }
        return null;
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        BlockState state = (BlockState)pState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pMirror.mirror((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        return pMirror == Mirror.NONE ? state : (BlockState)state.setValue(IcariaBlockStateProperties.VERTICAL_CORNER, (Comparable)((Object)((VerticalCorner)((Object)state.getValue(IcariaBlockStateProperties.VERTICAL_CORNER))).getOpposite()));
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((VerticalCorner)((Object)pState.getValue(IcariaBlockStateProperties.VERTICAL_CORNER))) {
            default -> throw new MatchException(null, null);
            case VerticalCorner.BOTTOM_LEFT -> {
                switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    case NORTH: {
                        yield IcariaShapes.TripleBarrelRackShapes.BOTTOM_LEFT_NORTH;
                    }
                    case EAST: {
                        yield IcariaShapes.TripleBarrelRackShapes.BOTTOM_LEFT_EAST;
                    }
                    case SOUTH: {
                        yield IcariaShapes.TripleBarrelRackShapes.BOTTOM_LEFT_SOUTH;
                    }
                }
                yield IcariaShapes.TripleBarrelRackShapes.BOTTOM_LEFT_WEST;
            }
            case VerticalCorner.BOTTOM_RIGHT -> {
                switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    case NORTH: {
                        yield IcariaShapes.TripleBarrelRackShapes.BOTTOM_RIGHT_NORTH;
                    }
                    case EAST: {
                        yield IcariaShapes.TripleBarrelRackShapes.BOTTOM_RIGHT_EAST;
                    }
                    case SOUTH: {
                        yield IcariaShapes.TripleBarrelRackShapes.BOTTOM_RIGHT_SOUTH;
                    }
                }
                yield IcariaShapes.TripleBarrelRackShapes.BOTTOM_RIGHT_WEST;
            }
            case VerticalCorner.TOP_LEFT -> {
                switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    case NORTH: {
                        yield IcariaShapes.TripleBarrelRackShapes.TOP_LEFT_NORTH;
                    }
                    case EAST: {
                        yield IcariaShapes.TripleBarrelRackShapes.TOP_LEFT_EAST;
                    }
                    case SOUTH: {
                        yield IcariaShapes.TripleBarrelRackShapes.TOP_LEFT_SOUTH;
                    }
                }
                yield IcariaShapes.TripleBarrelRackShapes.TOP_LEFT_WEST;
            }
            case VerticalCorner.TOP_RIGHT -> {
                switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    case NORTH: {
                        yield IcariaShapes.TripleBarrelRackShapes.TOP_RIGHT_NORTH;
                    }
                    case EAST: {
                        yield IcariaShapes.TripleBarrelRackShapes.TOP_RIGHT_EAST;
                    }
                    case SOUTH: {
                        yield IcariaShapes.TripleBarrelRackShapes.TOP_RIGHT_SOUTH;
                    }
                }
                yield IcariaShapes.TripleBarrelRackShapes.TOP_RIGHT_WEST;
            }
        };
    }

    public List<ItemStack> getDrops(BlockState pState, LootParams.Builder pBuilder) {
        LootParams lootContext = pBuilder.withParameter(LootContextParams.BLOCK_STATE, (Object)pState).create(LootContextParamSets.BLOCK);
        return lootContext.getLevel().getServer().reloadableRegistries().getLootTable(IcariaLootTables.BARREL_LOOT).getRandomItems(lootContext);
    }
}

