/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.block;

import com.axanthic.icaria.common.entity.TroughBlockEntity;
import com.axanthic.icaria.common.properties.Trough;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.registry.IcariaShapes;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TroughBlock
extends Block
implements EntityBlock {
    public TroughBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue(IcariaBlockStateProperties.TROUGH, (Comparable)((Object)Trough.NONE))).setValue((Property)IcariaBlockStateProperties.TROUGH_FILL, (Comparable)Integer.valueOf(0)));
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        return (Integer)pState.getValue((Property)IcariaBlockStateProperties.TROUGH_FILL);
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, IcariaBlockStateProperties.TROUGH, IcariaBlockStateProperties.TROUGH_FILL});
    }

    public void setStack(InteractionHand pHand, Item pItem, Player pPlayer) {
        if (!pPlayer.isCreative()) {
            pPlayer.setItemInHand(pHand, new ItemStack((ItemLike)pItem));
        }
    }

    public void shrinkStack(ItemStack pStack, Player pPlayer) {
        if (!pPlayer.isCreative()) {
            pStack.shrink(1);
        }
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new TroughBlockEntity(pPos, pState);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return (BlockState)pState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pMirror.mirror((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pResult) {
        Integer fill = (Integer)pState.getValue((Property)IcariaBlockStateProperties.TROUGH_FILL);
        ItemStack item = pPlayer.getItemInHand(pHand);
        if (fill < 9) {
            if (pStack.is(Items.WATER_BUCKET)) {
                if (pState.getValue(IcariaBlockStateProperties.TROUGH) == Trough.NONE) {
                    pLevel.playSound(null, pPos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS);
                    pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)pState.setValue(IcariaBlockStateProperties.TROUGH, (Comparable)((Object)Trough.WATER))).setValue((Property)IcariaBlockStateProperties.TROUGH_FILL, (Comparable)Integer.valueOf(9)));
                    pPlayer.awardStat(Stats.ITEM_USED.get((Object)Items.WATER_BUCKET));
                    this.setStack(pHand, Items.BUCKET, pPlayer);
                    return ItemInteractionResult.CONSUME;
                }
            } else if (pStack.is(IcariaItems.MEDITERRANEAN_WATER_BUCKET.get())) {
                if (pState.getValue(IcariaBlockStateProperties.TROUGH) == Trough.NONE) {
                    pLevel.playSound(null, pPos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS);
                    pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)pState.setValue(IcariaBlockStateProperties.TROUGH, (Comparable)((Object)Trough.MEDITERRANEAN_WATER))).setValue((Property)IcariaBlockStateProperties.TROUGH_FILL, (Comparable)Integer.valueOf(9)));
                    pPlayer.awardStat(Stats.ITEM_USED.get((Object)IcariaItems.MEDITERRANEAN_WATER_BUCKET.get()));
                    this.setStack(pHand, Items.BUCKET, pPlayer);
                    return ItemInteractionResult.CONSUME;
                }
            } else if (pStack.is(IcariaItems.ONION.get())) {
                if (pState.getValue(IcariaBlockStateProperties.TROUGH) == Trough.NONE || pState.getValue(IcariaBlockStateProperties.TROUGH) == Trough.ONION) {
                    pLevel.playSound(null, pPos, IcariaSoundEvents.TROUGH_FILL, SoundSource.BLOCKS);
                    pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)pState.setValue(IcariaBlockStateProperties.TROUGH, (Comparable)((Object)Trough.ONION))).setValue((Property)IcariaBlockStateProperties.TROUGH_FILL, (Comparable)Integer.valueOf(fill + 1)));
                    pPlayer.awardStat(Stats.ITEM_USED.get((Object)IcariaItems.ONION.get()));
                    this.shrinkStack(item, pPlayer);
                    return ItemInteractionResult.CONSUME;
                }
            } else if (pStack.is(IcariaItems.SPELT.get())) {
                if (pState.getValue(IcariaBlockStateProperties.TROUGH) == Trough.NONE || pState.getValue(IcariaBlockStateProperties.TROUGH) == Trough.SPELT) {
                    pLevel.playSound(null, pPos, IcariaSoundEvents.TROUGH_FILL, SoundSource.BLOCKS);
                    pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)pState.setValue(IcariaBlockStateProperties.TROUGH, (Comparable)((Object)Trough.SPELT))).setValue((Property)IcariaBlockStateProperties.TROUGH_FILL, (Comparable)Integer.valueOf(fill + 1)));
                    pPlayer.awardStat(Stats.ITEM_USED.get((Object)IcariaItems.SPELT.get()));
                    this.shrinkStack(item, pPlayer);
                    return ItemInteractionResult.CONSUME;
                }
            } else if (pStack.is(IcariaItems.VINEBERRIES.get()) && (pState.getValue(IcariaBlockStateProperties.TROUGH) == Trough.NONE || pState.getValue(IcariaBlockStateProperties.TROUGH) == Trough.VINEBERRIES)) {
                pLevel.playSound(null, pPos, IcariaSoundEvents.TROUGH_FILL, SoundSource.BLOCKS);
                pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)pState.setValue(IcariaBlockStateProperties.TROUGH, (Comparable)((Object)Trough.VINEBERRIES))).setValue((Property)IcariaBlockStateProperties.TROUGH_FILL, (Comparable)Integer.valueOf(fill + 1)));
                pPlayer.awardStat(Stats.ITEM_USED.get((Object)IcariaItems.VINEBERRIES.get()));
                this.shrinkStack(item, pPlayer);
                return ItemInteractionResult.CONSUME;
            }
        } else if (pStack.is(Items.BUCKET)) {
            if (pState.getValue(IcariaBlockStateProperties.TROUGH) == Trough.WATER) {
                pLevel.playSound(null, pPos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS);
                pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)pState.setValue(IcariaBlockStateProperties.TROUGH, (Comparable)((Object)Trough.NONE))).setValue((Property)IcariaBlockStateProperties.TROUGH_FILL, (Comparable)Integer.valueOf(0)));
                pPlayer.awardStat(Stats.ITEM_USED.get((Object)Items.BUCKET));
                this.setStack(pHand, Items.WATER_BUCKET, pPlayer);
                return ItemInteractionResult.CONSUME;
            }
            if (pState.getValue(IcariaBlockStateProperties.TROUGH) == Trough.MEDITERRANEAN_WATER) {
                pLevel.playSound(null, pPos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS);
                pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)pState.setValue(IcariaBlockStateProperties.TROUGH, (Comparable)((Object)Trough.NONE))).setValue((Property)IcariaBlockStateProperties.TROUGH_FILL, (Comparable)Integer.valueOf(0)));
                pPlayer.awardStat(Stats.ITEM_USED.get((Object)Items.BUCKET));
                this.setStack(pHand, IcariaItems.MEDITERRANEAN_WATER_BUCKET.get(), pPlayer);
                return ItemInteractionResult.CONSUME;
            }
        }
        if (fill > 3) {
            if (pStack.is(Items.GLASS_BOTTLE) && pState.getValue(IcariaBlockStateProperties.TROUGH) == Trough.WATER) {
                pLevel.playSound(null, pPos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS);
                pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)pState.setValue(IcariaBlockStateProperties.TROUGH, (Comparable)((Object)Trough.WATER))).setValue((Property)IcariaBlockStateProperties.TROUGH_FILL, (Comparable)Integer.valueOf(fill - 3)));
                pPlayer.awardStat(Stats.ITEM_USED.get((Object)Items.GLASS_BOTTLE));
                if (!pPlayer.isCreative()) {
                    pPlayer.setItemInHand(pHand, PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER));
                }
                return ItemInteractionResult.CONSUME;
            }
        } else if (fill > 2 && pStack.is(Items.GLASS_BOTTLE) && pState.getValue(IcariaBlockStateProperties.TROUGH) == Trough.WATER) {
            pLevel.playSound(null, pPos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS);
            pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)pState.setValue(IcariaBlockStateProperties.TROUGH, (Comparable)((Object)Trough.NONE))).setValue((Property)IcariaBlockStateProperties.TROUGH_FILL, (Comparable)Integer.valueOf(0)));
            pPlayer.awardStat(Stats.ITEM_USED.get((Object)Items.GLASS_BOTTLE));
            if (!pPlayer.isCreative()) {
                pPlayer.setItemInHand(pHand, PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER));
            }
            return ItemInteractionResult.CONSUME;
        }
        if (fill < 7 && pStack.is(Items.POTION) && ((PotionContents)pStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).is(Potions.WATER) && (pState.getValue(IcariaBlockStateProperties.TROUGH) == Trough.NONE || pState.getValue(IcariaBlockStateProperties.TROUGH) == Trough.WATER)) {
            pLevel.playSound(null, pPos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS);
            pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)pState.setValue(IcariaBlockStateProperties.TROUGH, (Comparable)((Object)Trough.WATER))).setValue((Property)IcariaBlockStateProperties.TROUGH_FILL, (Comparable)Integer.valueOf(fill + 3)));
            pPlayer.awardStat(Stats.ITEM_USED.get((Object)Items.POTION));
            this.setStack(pHand, Items.GLASS_BOTTLE, pPlayer);
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.FAIL;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case Direction.NORTH -> IcariaShapes.TroughShapes.NORTH;
            case Direction.EAST -> IcariaShapes.TroughShapes.EAST;
            case Direction.SOUTH -> IcariaShapes.TroughShapes.SOUTH;
            default -> IcariaShapes.TroughShapes.WEST;
        };
    }
}

