/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.config;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaConfig {
    public static ModConfigSpec.BooleanValue RENDER_CRYSTAL_RAYS;
    public static ModConfigSpec.BooleanValue RENDER_FORGE_ITEMS;
    public static ModConfigSpec.BooleanValue RENDER_GRINDER_GEARS;
    public static ModConfigSpec.BooleanValue RENDER_KETTLE_ITEMS;
    public static ModConfigSpec.BooleanValue RENDER_KILN_ITEMS;
    public static ModConfigSpec.BooleanValue FORGE_SOUNDS;
    public static ModConfigSpec.BooleanValue GRINDER_SOUNDS;
    public static ModConfigSpec.BooleanValue KETTLE_SOUNDS;
    public static ModConfigSpec.BooleanValue KILN_SOUNDS;
    public static ModConfigSpec.BooleanValue SPAWN_ARACHNIDS;
    public static ModConfigSpec.IntValue RENDER_DISTANCE_CRYSTAL_RAYS;
    public static ModConfigSpec.IntValue RENDER_DISTANCE_FORGE_ITEMS;
    public static ModConfigSpec.IntValue RENDER_DISTANCE_GRINDER_GEARS;
    public static ModConfigSpec.IntValue RENDER_DISTANCE_KETTLE_ITEMS;
    public static ModConfigSpec.IntValue RENDER_DISTANCE_KILN_ITEMS;

    public static void registerClientConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.translation("configuration.landsoficaria.render_settings").comment("Render Settings").push("renderSettings");
        RENDER_CRYSTAL_RAYS = builder.translation("configuration.landsoficaria.render_crystal").comment("Default: true. Whether a Crystal should render rays.").define("renderCrystal", true);
        RENDER_FORGE_ITEMS = builder.translation("configuration.landsoficaria.render_forge").comment("Default: true. Whether a Forge should render items.").define("renderForge", true);
        RENDER_GRINDER_GEARS = builder.translation("configuration.landsoficaria.render_grinder").comment("Default: true. Whether a Grinder should render gears.").define("renderGrinder", true);
        RENDER_KETTLE_ITEMS = builder.translation("configuration.landsoficaria.render_kettle").comment("Default: true. Whether a Kettle should render items.").define("renderKettle", true);
        RENDER_KILN_ITEMS = builder.translation("configuration.landsoficaria.render_kiln").comment("Default: true. Whether a Kiln should render items.").define("renderKiln", true);
        RENDER_DISTANCE_CRYSTAL_RAYS = builder.translation("configuration.landsoficaria.crystal_distance").comment("Default: 256. Whether a Crystal should render rays based on distance to a player.").defineInRange("crystalDistance", 256, 64, 1024);
        RENDER_DISTANCE_FORGE_ITEMS = builder.translation("configuration.landsoficaria.forge_distance").comment("Default: 256. Whether a Forge should render items based on distance to a player.").defineInRange("forgeDistance", 256, 64, 1024);
        RENDER_DISTANCE_GRINDER_GEARS = builder.translation("configuration.landsoficaria.grinder_distance").comment("Default: 256. Whether a Grinder should render gears based on distance to a player.").defineInRange("grinderDistance", 256, 64, 1024);
        RENDER_DISTANCE_KETTLE_ITEMS = builder.translation("configuration.landsoficaria.kettle_distance").comment("Default: 256. Whether a Kettle should render items based on distance to a player.").defineInRange("kettleDistance", 256, 64, 1024);
        RENDER_DISTANCE_KILN_ITEMS = builder.translation("configuration.landsoficaria.kiln_distance").comment("Default: 256. Whether a Kiln should render items based on distance to a player.").defineInRange("kilnDistance", 256, 64, 1024);
        builder.pop();
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)builder.build());
    }

    public static void registerCommonConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.translation("configuration.landsoficaria.sound_settings").comment("Sound Settings").push("soundSettings");
        FORGE_SOUNDS = builder.translation("configuration.landsoficaria.forge_sounds").comment("Default: true. Whether a Forge should play sounds.").define("forgeSounds", true);
        GRINDER_SOUNDS = builder.translation("configuration.landsoficaria.grinder_sounds").comment("Default: true. Whether a Grinder should play sounds.").define("grinderSounds", true);
        KETTLE_SOUNDS = builder.translation("configuration.landsoficaria.kettle_sounds").comment("Default: true. Whether a Kettle should play sounds.").define("kettleSounds", true);
        KILN_SOUNDS = builder.translation("configuration.landsoficaria.kiln_sounds").comment("Default: true. Whether a Kiln should play sounds.").define("kilnSounds", true);
        builder.pop();
        builder.translation("configuration.landsoficaria.spawn_settings").comment("Spawn Settings").push("spawnSettings");
        SPAWN_ARACHNIDS = builder.translation("configuration.landsoficaria.spawn_arachnids").comment("Default: true. Whether arachnids should spawn.").define("spawnArachnids", true);
        builder.pop();
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)builder.build());
    }

    public static void registerServerConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)builder.build());
    }
}

