/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.entity.ArachneEntity;
import com.axanthic.icaria.common.goal.IcariaArachnidTargetGoal;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import com.axanthic.icaria.data.tags.IcariaBlockTags;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ArachneDroneEntity
extends ArachneEntity {
    public int maxSize = 4;
    public int minSize = 1;
    public float aabbMult = 0.25f;
    public float renderMult = 0.15f;
    public float shadowMult = 0.15f;
    public float sizeMult = 0.75f;
    public float sizeMultInverted = 0.25f;
    public static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.defineId(ArachneDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Integer> SIZE = SynchedEntityData.defineId(ArachneDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ArachneDroneEntity(EntityType<? extends ArachneDroneEntity> pType, Level pLevel) {
        super((EntityType<? extends ArachneEntity>)pType, pLevel);
    }

    @Override
    public boolean canBeAffected(MobEffectInstance pEffectInstance) {
        return super.canBeAffected(pEffectInstance) && !pEffectInstance.is(MobEffects.POISON);
    }

    public boolean isBaby() {
        return this.getSize() < this.maxSize;
    }

    public boolean isClimbing() {
        return ((Byte)this.entityData.get(CLIMBING) & 1) != 0;
    }

    public boolean onClimbable() {
        return this.isClimbing();
    }

    @Override
    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return true;
    }

    public float getSizeInverted() {
        return (float)this.getSize() * -1.0f + 5.0f;
    }

    public float getScaleForRender() {
        return this.getScaleFromSize() * this.renderMult;
    }

    public float getScaleForShadow() {
        return this.getScaleFromSize() * this.shadowMult;
    }

    public float getScaleFromSize() {
        return this.getSizeWithMultInverted() + this.getSizeWithMult();
    }

    public float getSizeWithMult() {
        return (float)this.getSize() * this.sizeMult;
    }

    public float getSizeWithMultInverted() {
        return this.getSizeInverted() * this.sizeMultInverted;
    }

    public float getVoicePitch() {
        return this.getSizeWithMultInverted() + 0.75f;
    }

    public int getSize() {
        return (Integer)this.entityData.get(SIZE);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Size", this.getSize());
    }

    public void aiStep() {
        super.aiStep();
        if (this.isAlive()) {
            this.setSize(this.getSize());
        }
    }

    public void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(CLIMBING, (Object)0);
        pBuilder.define(SIZE, (Object)this.minSize);
    }

    @Override
    public void makeStuckInBlock(BlockState pState, Vec3 pMotionMultiplier) {
        if (!pState.is(IcariaBlockTags.COBWEB_BLOCKS)) {
            super.makeStuckInBlock(pState, pMotionMultiplier);
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        super.onSyncedDataUpdated(pKey);
        if (SIZE.equals(pKey)) {
            this.refreshDimensions();
        }
    }

    @Override
    public void playStepSound(BlockPos pPos, BlockState pState) {
        this.playSound(IcariaSoundEvents.ARACHNE_DRONE_STEP, 0.1f, 1.0f);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setSize(pCompound.getInt("Size"));
    }

    @Override
    public void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new LeapAtTargetGoal((Mob)this, 0.25f));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.001f));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f, 0.025f, false));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, new IcariaArachnidTargetGoal<Player>((Mob)this, Player.class, true, true));
    }

    public void setClimbing(boolean pClimbing) {
        byte b = (Byte)this.entityData.get(CLIMBING);
        b = pClimbing ? (byte)(b | 1) : (byte)(b & 0xFFFFFFFE);
        this.entityData.set(CLIMBING, (Object)b);
    }

    public void setSize(int pSize) {
        int size = Mth.clamp((int)pSize, (int)this.minSize, (int)this.maxSize);
        this.refreshDimensions();
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue((double)size);
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)(size * size));
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue((double)size * 0.04 + 0.1);
        this.entityData.set(SIZE, (Object)size);
        this.xpReward = size + 1;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            this.setClimbing(this.horizontalCollision);
        }
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.MAX_HEALTH, 16.0).add(Attributes.MOVEMENT_SPEED, 0.1);
    }

    public EntityDimensions getDefaultDimensions(Pose pPose) {
        float scale = this.getScaleFromSize() * this.aabbMult;
        return this.getType().getDimensions().scale(scale);
    }

    public PathNavigation createNavigation(Level pLevel) {
        return new WallClimberNavigation((Mob)this, pLevel);
    }

    @Override
    public SoundEvent getAmbientSound() {
        return IcariaSoundEvents.ARACHNE_DRONE_AMBIENT;
    }

    @Override
    public SoundEvent getDeathSound() {
        return IcariaSoundEvents.ARACHNE_DRONE_DEATH;
    }

    @Override
    public SoundEvent getHurtSound(DamageSource pDamageSource) {
        return IcariaSoundEvents.ARACHNE_DRONE_HURT;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        this.setSize(this.random.nextIntBetweenInclusive(1, 4));
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }
}

