/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.entity.IcariaArachnidEntity;
import com.axanthic.icaria.common.goal.ArachneHurtByTargetGoal;
import com.axanthic.icaria.common.goal.IcariaArachnidTargetGoal;
import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import com.axanthic.icaria.data.tags.IcariaBlockTags;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ArachneEntity
extends IcariaArachnidEntity {
    public AnimationState attackAnimationState = new AnimationState();

    public ArachneEntity(EntityType<? extends ArachneEntity> pType, Level pLevel) {
        super(pType, pLevel);
        this.xpReward = 10;
    }

    public boolean canBeAffected(MobEffectInstance pEffectInstance) {
        return super.canBeAffected(pEffectInstance) && !pEffectInstance.is(MobEffects.POISON);
    }

    public boolean doHurtTarget(Entity pEntity) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        return super.doHurtTarget(pEntity);
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return false;
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 4) {
            this.attackAnimationState.start(this.tickCount);
        } else {
            super.handleEntityEvent(pId);
        }
    }

    public void makeStuckInBlock(BlockState pState, Vec3 pMotionMultiplier) {
        if (!pState.is(IcariaBlockTags.COBWEB_BLOCKS)) {
            super.makeStuckInBlock(pState, pMotionMultiplier);
        }
    }

    public void playStepSound(BlockPos pPos, BlockState pState) {
        this.playSound(IcariaSoundEvents.ARACHNE_STEP, 0.1f, 1.0f);
    }

    public void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.001f));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f, 0.025f, false));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new ArachneHurtByTargetGoal(this).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, new IcariaArachnidTargetGoal<Player>((Mob)this, Player.class, true, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.FOLLOW_RANGE, 64.0).add(Attributes.MAX_HEALTH, 128.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public InteractionResult mobInteract(Player pPlayer, InteractionHand pHand) {
        ItemStack itemStack = pPlayer.getItemInHand(pHand);
        if (this.getType() == IcariaEntityTypes.ARACHNE.get() && itemStack.is(IcariaItems.EMPTY_VIAL.get())) {
            ItemStack filledResult = ItemUtils.createFilledResult((ItemStack)itemStack, (Player)pPlayer, (ItemStack)IcariaItems.ARACHNE_VENOM_VIAL.get().getDefaultInstance());
            this.setTarget((LivingEntity)pPlayer);
            pPlayer.awardStat(Stats.ITEM_USED.get((Object)IcariaItems.EMPTY_VIAL.get()));
            pPlayer.playSound(IcariaSoundEvents.VIAL_FILL);
            pPlayer.setItemInHand(pHand, filledResult);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(pPlayer, pHand);
    }

    public SoundEvent getAmbientSound() {
        return IcariaSoundEvents.ARACHNE_AMBIENT;
    }

    public SoundEvent getDeathSound() {
        return IcariaSoundEvents.ARACHNE_DEATH;
    }

    public SoundEvent getHurtSound(DamageSource pDamageSource) {
        return IcariaSoundEvents.ARACHNE_HURT;
    }
}

