/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.item.BidentItem;
import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BidentEntity
extends AbstractArrow {
    public static final EntityDataAccessor<Boolean> DEALT = SynchedEntityData.defineId(BidentEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.defineId(BidentEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);

    public BidentEntity(EntityType<? extends BidentEntity> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public BidentEntity(Level pLevel, LivingEntity pEntity, ItemStack pStack) {
        super(IcariaEntityTypes.BIDENT.get(), pEntity, pLevel, pStack, null);
        this.setDealt(false);
        this.setStack(pStack);
    }

    public boolean getDealt() {
        return (Boolean)this.getEntityData().get(DEALT);
    }

    public boolean shouldRender(double pX, double pY, double pZ) {
        return true;
    }

    public boolean tryPickup(Player pPlayer) {
        return super.tryPickup(pPlayer) || this.isNoPhysics() && this.ownedBy((Entity)pPlayer) && pPlayer.getInventory().add(this.getPickupItem());
    }

    public float getWaterInertia() {
        return 0.99f;
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("Dealt", this.getDealt());
        pCompound.put("Stack", this.getStack().save((HolderLookup.Provider)this.registryAccess()));
    }

    public void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DEALT, (Object)false);
        pBuilder.define(STACK, (Object)new ItemStack((ItemLike)this.getDefaultPickupItem().getItem()));
    }

    public void onHitEntity(EntityHitResult pResult) {
        float damage = 1.0f;
        ItemStack item = this.getStack();
        Entity owner = this.getOwner();
        Entity target = pResult.getEntity();
        Item item2 = item.getItem();
        if (item2 instanceof BidentItem) {
            BidentItem bidentItem = (BidentItem)item2;
            damage += bidentItem.getTier().getAttackDamageBonus() + 3.5f;
        }
        if (target.hurt(this.damageSources().trident((Entity)this, (Entity)(owner == null ? this : owner)), damage) && target.getType() == EntityType.ENDERMAN) {
            return;
        }
        this.playSound(IcariaSoundEvents.BIDENT_HIT);
        this.setDealt(true);
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
    }

    public void playerTouch(Player pEntity) {
        if (this.getOwner() == null || this.ownedBy((Entity)pEntity)) {
            super.playerTouch(pEntity);
        }
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setDealt(pCompound.getBoolean("Dealt"));
        ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)pCompound.getCompound("Stack")).ifPresent(this::setStack);
    }

    public void setDealt(boolean pDealt) {
        this.getEntityData().set(DEALT, (Object)pDealt);
    }

    public void setStack(ItemStack pStack) {
        this.getEntityData().set(STACK, (Object)pStack.copy());
    }

    public void tickDespawn() {
        if (this.pickup != AbstractArrow.Pickup.ALLOWED) {
            super.tickDespawn();
        }
    }

    public EntityHitResult findHitEntity(Vec3 pStartVec, Vec3 pEndVec) {
        return this.getDealt() ? null : super.findHitEntity(pStartVec, pEndVec);
    }

    public ItemStack getStack() {
        return (ItemStack)this.getEntityData().get(STACK);
    }

    public ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)IcariaItems.CHERT_TOOLS.bident.get());
    }

    public SoundEvent getDefaultHitGroundSoundEvent() {
        return IcariaSoundEvents.BIDENT_HIT_GROUND;
    }
}

