/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BubbleSpellEntity
extends ThrowableProjectile {
    public int minAge = 200;
    public int maxAge = 400;
    public static final EntityDataAccessor<Integer> AGE = SynchedEntityData.defineId(BubbleSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public BubbleSpellEntity(EntityType<? extends BubbleSpellEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean isInWater() {
        return false;
    }

    public double getDefaultGravity() {
        return 0.0;
    }

    public int getAge() {
        return (Integer)this.entityData.get(AGE);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Age", this.getAge());
    }

    public void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(AGE, (Object)0);
    }

    public void onHitBlock(BlockHitResult pResult) {
        super.onHitBlock(pResult);
        this.pop();
    }

    public void onHitEntity(EntityHitResult pResult) {
        Entity entity = pResult.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.hurt(this.damageSources().magic(), 2.0f);
            this.pop();
        }
    }

    public void pop() {
        this.discard();
        this.playSound(IcariaSoundEvents.BUBBLE_SPELL_POP);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setAge(pCompound.getInt("Age"));
    }

    public void setAge(int pAge) {
        this.entityData.set(AGE, (Object)pAge);
    }

    public void tick() {
        super.tick();
        int age = this.getAge();
        if (age < this.getRandom().nextIntBetweenInclusive(this.minAge, this.maxAge)) {
            this.setAge(++age);
        } else {
            this.pop();
        }
    }
}

