/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.entity.IcariaAnimalEntity;
import com.axanthic.icaria.common.goal.IcariaAnimalHurtByTargetGoal;
import com.axanthic.icaria.common.goal.IcariaBreedGoal;
import com.axanthic.icaria.common.goal.IcariaEatGoal;
import com.axanthic.icaria.common.goal.IcariaFollowParentGoal;
import com.axanthic.icaria.common.goal.IcariaPanicGoal;
import com.axanthic.icaria.common.properties.Trough;
import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CapellaEntity
extends IcariaAnimalEntity {
    public int eatAnimationTick;
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState eatingAnimationState = new AnimationState();
    public IcariaEatGoal eatBlockGoal;

    public CapellaEntity(EntityType<? extends CapellaEntity> pType, Level pLevel) {
        super((EntityType<? extends IcariaAnimalEntity>)pType, pLevel, 0.25f, 0.35f, 0.15f, 0.75f, 0.25f);
    }

    public boolean doHurtTarget(Entity pEntity) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        return super.doHurtTarget(pEntity);
    }

    @Override
    public boolean isFood(ItemStack pStack) {
        return pStack.is(IcariaItems.VINEBERRIES.get());
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide()) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
    }

    public void customServerAiStep() {
        super.customServerAiStep();
        this.eatAnimationTick = this.eatBlockGoal.getEatAnimationTick();
    }

    @Override
    public void handleEntityEvent(byte pId) {
        if (pId == 4) {
            this.attackAnimationState.start(this.tickCount);
        } else if (pId == 10) {
            this.eatAnimationTick = 40;
            this.eatingAnimationState.start(this.tickCount);
        } else {
            super.handleEntityEvent(pId);
        }
    }

    public void playStepSound(BlockPos pPos, BlockState pState) {
        this.playSound(IcariaSoundEvents.CAPELLA_STEP, 0.1f, 1.0f);
    }

    public void registerGoals() {
        this.eatBlockGoal = new IcariaEatGoal(this, Trough.VINEBERRIES);
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new IcariaPanicGoal(this, 1.5));
        this.goalSelector.addGoal(3, (Goal)new IcariaBreedGoal(this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(5, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)IcariaItems.VINEBERRIES.get()}), false));
        this.goalSelector.addGoal(6, (Goal)new IcariaFollowParentGoal(this, 1.0));
        this.goalSelector.addGoal(7, (Goal)this.eatBlockGoal);
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.001f));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f, 0.025f, false));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new IcariaAnimalHurtByTargetGoal(this, 1.5).setAlertOthers(new Class[0]));
    }

    @Override
    public void setSize(int pSize) {
        super.setSize(pSize);
        int size = Mth.clamp((int)pSize, (int)this.minSize, (int)this.maxSize);
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue((double)size);
        this.getAttribute(Attributes.ATTACK_KNOCKBACK).setBaseValue((double)size * 0.5);
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)(size * size));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ATTACK_KNOCKBACK, 2.0).add(Attributes.MAX_HEALTH, 16.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    @Override
    public CapellaEntity getBreedOffspring(ServerLevel pLevel, IcariaAnimalEntity pEntity) {
        return (CapellaEntity)IcariaEntityTypes.CAPELLA.get().create((Level)pLevel);
    }

    public SoundEvent getAmbientSound() {
        return IcariaSoundEvents.CAPELLA_AMBIENT;
    }

    public SoundEvent getDeathSound() {
        return IcariaSoundEvents.CAPELLA_DEATH;
    }

    public SoundEvent getHurtSound(DamageSource pDamageSource) {
        return IcariaSoundEvents.CAPELLA_HURT;
    }
}

