/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.entity.CrawlerRevenantEntity;
import com.axanthic.icaria.common.entity.RevenantEntity;
import com.axanthic.icaria.common.goal.CaptainRevenantSummonGoal;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import com.axanthic.icaria.common.util.IcariaSummonSpellTypes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CaptainRevenantEntity
extends RevenantEntity {
    public int maxUnequips = 40;
    public int minUnequips = 0;
    public int maxRallying = 120;
    public int minRallying = 0;
    public int maxReequips = 40;
    public int minReequips = 0;
    public AnimationState unequipsAnimationState = new AnimationState();
    public AnimationState rallyingAnimationState = new AnimationState();
    public AnimationState reequipsAnimationState = new AnimationState();
    public static final EntityDataAccessor<Byte> SPELL = SynchedEntityData.defineId(CaptainRevenantEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Integer> UNEQUIPS = SynchedEntityData.defineId(CaptainRevenantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> RALLYING = SynchedEntityData.defineId(CaptainRevenantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> REEQUIPS = SynchedEntityData.defineId(CaptainRevenantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public TargetingConditions targetingConditions = TargetingConditions.forCombat().range(16.0);

    public CaptainRevenantEntity(EntityType<? extends CaptainRevenantEntity> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public boolean doSummoning() {
        return !this.onUnequips() && !this.onRallying() && !this.onReequips() && this.getLastHurtByPlayerTime() > 0 && this.level().getNearbyEntities(CrawlerRevenantEntity.class, this.targetingConditions, (LivingEntity)this, this.getBoundingBox().inflate(16.0)).size() <= 2;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.doSummoning()) {
            this.setUnequips(this.maxUnequips);
        }
        return super.hurt(pSource, pAmount);
    }

    public boolean isPushable() {
        return false;
    }

    public boolean onRallying() {
        return this.getRallying() > this.minRallying;
    }

    public boolean onReequips() {
        return this.getReequips() > this.minReequips;
    }

    public boolean onUnequips() {
        return this.getUnequips() > this.minUnequips;
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return false;
    }

    public int getLastHurtByPlayerTime() {
        return this.lastHurtByPlayerTime;
    }

    public int getRallying() {
        return (Integer)this.entityData.get(RALLYING);
    }

    public int getReequips() {
        return (Integer)this.entityData.get(REEQUIPS);
    }

    public int getUnequips() {
        return (Integer)this.entityData.get(UNEQUIPS);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Unequips", this.getUnequips());
        pCompound.putInt("Rallying", this.getRallying());
        pCompound.putInt("Reequips", this.getReequips());
    }

    public void aiStep() {
        int reequips;
        super.aiStep();
        if (this.onUnequips()) {
            int unequips = this.getUnequips();
            if (unequips > this.minUnequips) {
                this.setUnequips(--unequips);
                this.setRallying(this.maxRallying);
            }
        } else if (this.onRallying()) {
            int rallying = this.getRallying();
            if (rallying > this.minRallying) {
                this.setRallying(--rallying);
                this.setReequips(this.maxReequips);
            }
        } else if (this.onReequips() && (reequips = this.getReequips()) > this.minReequips) {
            this.setReequips(--reequips);
        }
    }

    public void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(SPELL, (Object)0);
        pBuilder.define(UNEQUIPS, (Object)this.minUnequips);
        pBuilder.define(RALLYING, (Object)this.minRallying);
        pBuilder.define(REEQUIPS, (Object)this.minReequips);
    }

    @Override
    public void playStepSound(BlockPos pPos, BlockState pState) {
        this.playSound(IcariaSoundEvents.CAPTAIN_REVENANT_STEP, 0.1f, 1.0f);
    }

    public void populateDefaultEquipmentSlots(RandomSource pRandom, DifficultyInstance pDifficulty) {
        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)IcariaItems.ORICHALCUM_ARMOR.helmet.get()));
        this.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)IcariaItems.ORICHALCUM_ARMOR.chestplate.get()));
        if (pRandom.nextInt(6) == 0) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)IcariaItems.ORICHALCUM_TOOLS.bident.get()));
        } else {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)IcariaItems.ORICHALCUM_TOOLS.sword.get()));
        }
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setUnequips(pCompound.getInt("Unequips"));
        this.setRallying(pCompound.getInt("Rallying"));
        this.setReequips(pCompound.getInt("Reequips"));
    }

    @Override
    public void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(3, (Goal)new CaptainRevenantSummonGoal(this));
        this.goalSelector.addGoal(4, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.001f));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f, 0.025f, false));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, true));
    }

    public void setCasting(IcariaSummonSpellTypes pSpell) {
        this.entityData.set(SPELL, (Object)((byte)pSpell.id));
    }

    public void setRallying(int pCooldown) {
        int ticks = Mth.clamp((int)pCooldown, (int)this.minRallying, (int)this.maxRallying);
        this.entityData.set(RALLYING, (Object)ticks);
    }

    public void setReequips(int pCooldown) {
        int ticks = Mth.clamp((int)pCooldown, (int)this.minReequips, (int)this.maxReequips);
        this.entityData.set(REEQUIPS, (Object)ticks);
    }

    public void setUnequips(int pCooldown) {
        int ticks = Mth.clamp((int)pCooldown, (int)this.minUnequips, (int)this.maxUnequips);
        this.entityData.set(UNEQUIPS, (Object)ticks);
    }

    public void stopMove() {
        if (this.onUnequips() || this.onRallying() || this.onReequips()) {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
        } else {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.25);
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            if (this.onUnequips()) {
                this.unequipsAnimationState.startIfStopped(this.tickCount);
                this.reequipsAnimationState.stop();
            } else if (this.onRallying()) {
                this.rallyingAnimationState.startIfStopped(this.tickCount);
                this.unequipsAnimationState.stop();
            } else if (this.onReequips()) {
                this.reequipsAnimationState.startIfStopped(this.tickCount);
                this.rallyingAnimationState.stop();
            }
        } else {
            this.stopMove();
        }
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MAX_HEALTH, 100.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    @Override
    public SoundEvent getDeathSound() {
        return IcariaSoundEvents.CAPTAIN_REVENANT_DEATH;
    }

    @Override
    public SoundEvent getHurtSound(DamageSource pDamageSource) {
        return IcariaSoundEvents.CAPTAIN_REVENANT_HURT;
    }
}

