/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.entity.RevenantEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CrawlerRevenantEntity
extends RevenantEntity {
    public int maxTick = 60;
    public int minTick = 0;
    public static final EntityDataAccessor<Integer> TICK = SynchedEntityData.defineId(CrawlerRevenantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public CrawlerRevenantEntity(EntityType<? extends CrawlerRevenantEntity> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public boolean canRide(Entity pVehicle) {
        return false;
    }

    public boolean onTick() {
        return this.getTick() < this.maxTick;
    }

    public float getShadowStrength() {
        return (float)this.getTick() / (float)this.maxTick;
    }

    public int getTick() {
        return (Integer)this.entityData.get(TICK);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Tick", this.getTick());
    }

    public void aiStep() {
        int tick;
        super.aiStep();
        if (this.isAlive() && (tick = this.getTick()) < this.maxTick) {
            this.setTick(++tick);
        }
    }

    public void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(TICK, (Object)this.minTick);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setTick(pCompound.getInt("Tick"));
    }

    public void setTick(int pSize) {
        int tick = Mth.clamp((int)pSize, (int)this.minTick, (int)this.maxTick);
        this.entityData.set(TICK, (Object)tick);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.tickParticlePlusSounds();
        }
    }

    public void tickParticlePlusSounds() {
        if (this.onTick()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), this.getBlockStateOn().getSoundType((LevelReader)this.level(), this.blockPosition(), (Entity)this).getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            for (int i = 0; i < 15; ++i) {
                double x = this.getX() + (double)Mth.randomBetween((RandomSource)this.getRandom(), (float)-0.75f, (float)0.75f);
                double y = this.getY();
                double z = this.getZ() + (double)Mth.randomBetween((RandomSource)this.getRandom(), (float)-0.75f, (float)0.75f);
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.getBlockStateOn()), x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.125);
    }
}

