/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.entity.AeternaeEntity;
import com.axanthic.icaria.common.entity.ArganHoundEntity;
import com.axanthic.icaria.common.entity.CapellaEntity;
import com.axanthic.icaria.common.entity.CatoblepasEntity;
import com.axanthic.icaria.common.entity.CerverEntity;
import com.axanthic.icaria.common.entity.SowEntity;
import com.axanthic.icaria.common.goal.CrocottaTargetGoal;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CrocottaEntity
extends Monster {
    public AnimationState attackAnimationState = new AnimationState();

    public CrocottaEntity(EntityType<? extends CrocottaEntity> pType, Level pLevel) {
        super(pType, pLevel);
        this.xpReward = 5;
    }

    public boolean doHurtTarget(Entity pEntity) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        return super.doHurtTarget(pEntity);
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 4) {
            this.attackAnimationState.start(this.tickCount);
        } else {
            super.handleEntityEvent(pId);
        }
    }

    public void playStepSound(BlockPos pPos, BlockState pState) {
        this.playSound(IcariaSoundEvents.CROCOTTA_STEP, 0.1f, 1.0f);
    }

    public void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new LeapAtTargetGoal((Mob)this, 0.25f));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.001f));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f, 0.025f, false));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, new CrocottaTargetGoal<Player>((Mob)this, Player.class, true, true));
        this.targetSelector.addGoal(2, new CrocottaTargetGoal<AeternaeEntity>((Mob)this, AeternaeEntity.class, true, true));
        this.targetSelector.addGoal(2, new CrocottaTargetGoal<ArganHoundEntity>((Mob)this, ArganHoundEntity.class, true, true));
        this.targetSelector.addGoal(2, new CrocottaTargetGoal<CapellaEntity>((Mob)this, CapellaEntity.class, true, true));
        this.targetSelector.addGoal(2, new CrocottaTargetGoal<CatoblepasEntity>((Mob)this, CatoblepasEntity.class, true, true));
        this.targetSelector.addGoal(2, new CrocottaTargetGoal<CerverEntity>((Mob)this, CerverEntity.class, true, true));
        this.targetSelector.addGoal(2, new CrocottaTargetGoal<SowEntity>((Mob)this, SowEntity.class, true, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.MAX_HEALTH, 16.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public SoundEvent getAmbientSound() {
        return IcariaSoundEvents.CROCOTTA_AMBIENT;
    }

    public SoundEvent getDeathSound() {
        return IcariaSoundEvents.CROCOTTA_DEATH;
    }

    public SoundEvent getHurtSound(DamageSource pDamageSource) {
        return IcariaSoundEvents.CROCOTTA_HURT;
    }
}

