/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FloatingBlockEntity
extends Entity {
    public int minTick = 0;
    public int maxTick = 100;
    public static final EntityDataAccessor<BlockPos> BLOCK_POS = SynchedEntityData.defineId(FloatingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    public static final EntityDataAccessor<BlockState> BLOCK_STATE = SynchedEntityData.defineId(FloatingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);
    public static final EntityDataAccessor<Integer> TICK = SynchedEntityData.defineId(FloatingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public FloatingBlockEntity(EntityType<? extends FloatingBlockEntity> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public FloatingBlockEntity(EntityType<? extends FloatingBlockEntity> pType, Level pLevel, BlockState pState, BlockPos pPos) {
        this(pType, pLevel);
        this.setBlockPos(pPos);
        this.setBlockState(pState);
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, DamageSource pSource) {
        float amount = Math.min(this.fallDistance, 40.0f);
        AABB boundingBox = this.getBoundingBox();
        DamageSource damageSource = this.damageSources().fallingBlock((Entity)this);
        Predicate predicate = EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(EntitySelector.LIVING_ENTITY_STILL_ALIVE);
        this.level().getEntities((Entity)this, boundingBox, predicate).forEach(entity -> entity.hurt(damageSource, amount));
        return true;
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public boolean isAttackable() {
        return false;
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public boolean onlyOpCanSetNbt() {
        return true;
    }

    public int getTick() {
        return (Integer)this.entityData.get(TICK);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        pCompound.put("BlockPos", NbtUtils.writeBlockPos((BlockPos)this.getBlockPos()));
        pCompound.put("BlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.getBlockState()));
        pCompound.putInt("Tick", this.getTick());
    }

    public void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(BLOCK_POS, (Object)BlockPos.ZERO);
        pBuilder.define(BLOCK_STATE, (Object)Blocks.AIR.defaultBlockState());
        pBuilder.define(TICK, (Object)this.minTick);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        NbtUtils.readBlockPos((CompoundTag)pCompound, (String)"BlockPos").ifPresent(this::setBlockPos);
        this.setBlockState(NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)pCompound.getCompound("BlockState")));
        this.setTick(pCompound.getInt("Tick"));
    }

    public void setBlockPos(BlockPos pPos) {
        this.entityData.set(BLOCK_POS, (Object)pPos);
    }

    public void setBlockState(BlockState pState) {
        this.entityData.set(BLOCK_STATE, (Object)pState);
    }

    public void setTick(int pTick) {
        int tick = Mth.clamp((int)pTick, (int)this.minTick, (int)this.maxTick);
        this.entityData.set(TICK, (Object)tick);
    }

    public void tick() {
        super.tick();
        this.move(MoverType.SELF, this.getDeltaMovement());
        int tick = this.getTick();
        if (tick < this.maxTick) {
            this.setTick(++tick);
        } else {
            this.setDeltaMovement(0.0, -0.7, 0.0);
            if (this.onGround()) {
                if (this.level().getBlockState(this.blockPosition()).canBeReplaced() && this.getBlockState().canSurvive((LevelReader)this.level(), this.blockPosition())) {
                    this.level().setBlockAndUpdate(this.blockPosition(), this.getBlockState());
                    this.discard();
                } else if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                    this.spawnAtLocation((ItemLike)this.getBlockState().getBlock());
                    this.discard();
                }
            }
        }
    }

    public BlockPos getBlockPos() {
        return (BlockPos)this.entityData.get(BLOCK_POS);
    }

    public BlockState getBlockState() {
        return (BlockState)this.entityData.get(BLOCK_STATE);
    }

    public Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }
}

