/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.goal.ForestHagPlaceSaplingGoal;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ForestHagEntity
extends Monster {
    public int targetChangeTime;
    public int targetSoundsTime = Integer.MIN_VALUE;
    public static final EntityDataAccessor<Boolean> TARGETING = SynchedEntityData.defineId(ForestHagEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public ForestHagEntity(EntityType<? extends ForestHagEntity> pType, Level pLevel) {
        super(pType, pLevel);
        this.xpReward = 10;
    }

    public boolean doHurtTarget(Entity pEntity) {
        boolean flag = pEntity.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE));
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        if (pEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)pEntity;
            double knockback = this.getAttributeValue(Attributes.ATTACK_KNOCKBACK) - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
            if (flag && knockback > 0.0) {
                pEntity.push(0.0, knockback * 0.5, 0.0);
            }
        }
        return pEntity instanceof LivingEntity && flag;
    }

    public boolean isTargeting() {
        return (Boolean)this.entityData.get(TARGETING);
    }

    public void actuallyHurt(DamageSource pDamageSource, float pDamageAmount) {
        LivingEntity livingEntity;
        Entity entity = pDamageSource.getEntity();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).getMainHandItem().getItem() instanceof AxeItem) {
            pDamageAmount *= 2.0f;
        }
        if (pDamageSource.is(DamageTypes.ON_FIRE)) {
            pDamageAmount *= 2.0f;
        }
        super.actuallyHurt(pDamageSource, pDamageAmount);
    }

    public void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(TARGETING, (Object)false);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        super.onSyncedDataUpdated(pKey);
        if (TARGETING.equals(pKey) && this.isTargeting() && this.level().isClientSide()) {
            this.playTargetSounds();
        }
    }

    public void playTargetSounds() {
        if (this.tickCount >= this.targetSoundsTime + 400) {
            this.targetSoundsTime = this.tickCount;
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), IcariaSoundEvents.FOREST_HAG_TARGET, SoundSource.HOSTILE, 1.0f, 1.0f, false);
            }
        }
    }

    public void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.001f));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f, 0.025f, false));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new ForestHagPlaceSaplingGoal(this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void setTarget(@Nullable LivingEntity pTarget) {
        super.setTarget(pTarget);
        if (pTarget == null) {
            this.targetChangeTime = 0;
            this.entityData.set(TARGETING, (Object)false);
        } else {
            this.targetChangeTime = this.tickCount;
            this.entityData.set(TARGETING, (Object)true);
        }
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 16.0).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.FOLLOW_RANGE, 64.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5).add(Attributes.MAX_HEALTH, 48.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public SoundEvent getAmbientSound() {
        return this.isTargeting() ? IcariaSoundEvents.FOREST_HAG_SCREAM : IcariaSoundEvents.FOREST_HAG_AMBIENT;
    }

    public SoundEvent getDeathSound() {
        return IcariaSoundEvents.FOREST_HAG_DEATH;
    }

    public SoundEvent getHurtSound(DamageSource pDamageSource) {
        return IcariaSoundEvents.FOREST_HAG_HURT;
    }
}

