/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.entity.SpellEntity;
import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.registry.IcariaFluids;
import com.axanthic.icaria.common.registry.IcariaMobEffects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FreezingSpellEntity
extends SpellEntity {
    public FreezingSpellEntity(EntityType<? extends SpellEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean canSurvive(LevelReader pLevel, BlockPos pPos) {
        BlockPos belowPos = pPos.below();
        BlockState blockState = pLevel.getBlockState(belowPos);
        if (blockState.is(BlockTags.SNOW_LAYER_CANNOT_SURVIVE_ON)) {
            return false;
        }
        if (blockState.is(BlockTags.SNOW_LAYER_CAN_SURVIVE_ON)) {
            return true;
        }
        return Block.isFaceFull((VoxelShape)blockState.getCollisionShape((BlockGetter)pLevel, belowPos), (Direction)Direction.UP) || blockState.is(Blocks.SNOW) && (Integer)blockState.getValue((Property)SnowLayerBlock.LAYERS) == 8;
    }

    @Override
    public void onHitBlock(BlockHitResult pResult) {
        super.onHitBlock(pResult);
        Level level = this.level();
        BlockPos blockPos = pResult.getBlockPos();
        BlockPos abovePos = blockPos.above();
        if (level.getBlockState(blockPos).is(Blocks.SNOW) && (Integer)level.getBlockState(blockPos).getValue((Property)SnowLayerBlock.LAYERS) < 8) {
            level.setBlockAndUpdate(blockPos, (BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(Math.min((Integer)level.getBlockState(blockPos).getValue((Property)SnowLayerBlock.LAYERS) + 1, 8))));
        } else if (level.getBlockState(abovePos).is(Blocks.SNOW) && (Integer)level.getBlockState(abovePos).getValue((Property)SnowLayerBlock.LAYERS) <= 2) {
            level.setBlockAndUpdate(abovePos, (BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(2)));
        } else if (!level.getBlockState(abovePos).is(Blocks.SNOW) && level.getBlockState(abovePos).canBeReplaced() && this.canSurvive((LevelReader)level, abovePos)) {
            level.setBlockAndUpdate(abovePos, (BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(1)));
        }
    }

    @Override
    public void onHitEntity(EntityHitResult pResult) {
        LivingEntity livingEntity;
        super.onHitEntity(pResult);
        Entity entity = pResult.getEntity();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).canFreeze()) {
            livingEntity.addEffect(new MobEffectInstance(IcariaMobEffects.FREEZING, 300));
        }
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        BlockPos blockPos = this.blockPosition();
        BlockState blockState = level.getBlockState(blockPos);
        FluidState fluidState = blockState.getFluidState();
        if (blockState.canBeReplaced() && fluidState.is((Fluid)IcariaFluids.MEDITERRANEAN_WATER.get())) {
            level.setBlockAndUpdate(blockPos, IcariaBlocks.ARISTONE.get().defaultBlockState());
            this.discard();
        } else if (blockState.canBeReplaced() && fluidState.is((Fluid)Fluids.WATER)) {
            level.setBlockAndUpdate(blockPos, Blocks.ICE.defaultBlockState());
            this.discard();
        }
    }
}

