/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.util.IcariaPortalShape;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.HitResult;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GreekFireGrenadeEntity
extends AbstractArrow {
    public ItemStack stack = new ItemStack((ItemLike)IcariaItems.GREEK_FIRE_GRENADE.get());

    public GreekFireGrenadeEntity(EntityType<? extends GreekFireGrenadeEntity> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public GreekFireGrenadeEntity(Level pLevel, LivingEntity pEntity, ItemStack pStack) {
        super(IcariaEntityTypes.GREEK_FIRE_GRENADE.get(), pEntity, pLevel, pStack, null);
        this.stack = pStack.copy();
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public boolean spawnPortal(LevelAccessor pLevel, BlockPos pPos) {
        IcariaPortalShape portalShape = this.getPortalShape(pLevel, pPos);
        if (portalShape != null) {
            portalShape.createPortalBlocks();
            return true;
        }
        return false;
    }

    public void onHit(HitResult pResult) {
        if (!this.level().isClientSide()) {
            if (this.spawnPortal((LevelAccessor)this.level(), BlockPos.containing((double)pResult.getLocation().x(), (double)pResult.getLocation().y(), (double)pResult.getLocation().z()))) {
                this.discard();
            } else {
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 1.5f, Level.ExplosionInteraction.NONE);
                this.discard();
                for (int i = -2; i <= 2; ++i) {
                    BlockPos negPos = BlockPos.containing((double)(this.getX() - (double)i), (double)(this.getY() - (double)i), (double)(this.getZ() - (double)i));
                    BlockPos posPos = BlockPos.containing((double)(this.getX() + (double)i), (double)(this.getY() + (double)i), (double)(this.getZ() + (double)i));
                    for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)negPos, (BlockPos)posPos)) {
                        if (this.getRandom().nextInt(10) != 0 || !this.level().getBlockState(blockPos).isAir() || !this.level().getBlockState(blockPos.below()).isSolidRender((BlockGetter)this.level(), blockPos.below())) continue;
                        this.level().setBlockAndUpdate(blockPos, IcariaBlocks.GREEK_FIRE.get().defaultBlockState());
                    }
                }
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.getRandom().nextBoolean()) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public IcariaPortalShape getPortalShape(LevelAccessor pLevel, BlockPos pPos) {
        IcariaPortalShape icariaPortalShapeX = new IcariaPortalShape(pLevel, pPos, Direction.Axis.X);
        IcariaPortalShape icariaPortalShapeZ = new IcariaPortalShape(pLevel, pPos, Direction.Axis.Z);
        if (icariaPortalShapeX.isValid() && icariaPortalShapeX.numPortalBlocks == 0) {
            return icariaPortalShapeX;
        }
        if (icariaPortalShapeZ.isValid() && icariaPortalShapeZ.numPortalBlocks == 0) {
            return icariaPortalShapeZ;
        }
        return null;
    }

    public ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    public ItemStack getItem() {
        return this.stack;
    }

    public SoundEvent getDefaultHitGroundSoundEvent() {
        return (SoundEvent)SoundEvents.GENERIC_EXPLODE.value();
    }
}

