/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class HyliasterEntity
extends Monster {
    public int maxSize = 4;
    public int minSize = 1;
    public float aabbMult = 0.2f;
    public float renderMult = 0.25f;
    public float shadowMult = 0.15f;
    public float sizeMult = 0.75f;
    public float sizeMultInverted = 0.25f;
    public AnimationState moveAnimationState = new AnimationState();
    public static final EntityDataAccessor<Integer> SIZE = SynchedEntityData.defineId(HyliasterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public HyliasterEntity(EntityType<? extends HyliasterEntity> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public boolean isBaby() {
        return this.getSize() < this.maxSize;
    }

    public boolean isMovingOnLand() {
        return this.onGround() && this.getDeltaMovement().horizontalDistanceSqr() > 0.0;
    }

    public boolean isPushable() {
        return false;
    }

    public float getSizeInverted() {
        return (float)this.getSize() * -1.0f + 5.0f;
    }

    public float getScaleForRender() {
        return this.getScaleFromSize() * this.renderMult;
    }

    public float getScaleForShadow() {
        return this.getScaleFromSize() * this.shadowMult;
    }

    public float getScaleFromSize() {
        return this.getSizeWithMultInverted() + this.getSizeWithMult();
    }

    public float getSizeWithMult() {
        return (float)this.getSize() * this.sizeMult;
    }

    public float getSizeWithMultInverted() {
        return this.getSizeInverted() * this.sizeMultInverted;
    }

    public float getVoicePitch() {
        return this.getSizeWithMultInverted() + 0.75f;
    }

    public int getSize() {
        return (Integer)this.entityData.get(SIZE);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Size", this.getSize());
    }

    public void aiStep() {
        super.aiStep();
        if (this.isAlive()) {
            this.setSize(this.getSize());
        }
    }

    public void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(SIZE, (Object)this.minSize);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        super.onSyncedDataUpdated(pKey);
        if (SIZE.equals(pKey)) {
            this.refreshDimensions();
        }
    }

    public void playStepSound(BlockPos pPos, BlockState pState) {
        this.playSound(IcariaSoundEvents.HYLIASTER_SQUISH, 0.1f, 1.0f);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setSize(pCompound.getInt("Size"));
    }

    public void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.001f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, true));
    }

    public void remove() {
        if (this.getSize() == this.minSize) {
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public void remove(Entity.RemovalReason pReason) {
        int size;
        super.remove(pReason);
        if (!this.level().isClientSide() && (size = this.getSize()) > this.minSize && this.isDeadOrDying()) {
            for (int l = 0; l < size; ++l) {
                float xOffset = ((float)(l % 2) - 0.5f) * (float)size * 0.05f;
                float zOffset = ((float)(l / 2) - 0.5f) * (float)size * 0.05f;
                HyliasterEntity entity = (HyliasterEntity)IcariaEntityTypes.HYLIASTER.get().create(this.level());
                if (entity == null) continue;
                entity.moveTo(this.getX() + (double)xOffset, this.getY() + 0.5, this.getZ() + (double)zOffset, this.random.nextFloat() * 360.0f, 0.0f);
                entity.setCustomName(this.getCustomName());
                entity.setSize(this.minSize);
                this.level().addFreshEntity((Entity)entity);
            }
        }
    }

    public void setSize(int pSize) {
        int size = Mth.clamp((int)pSize, (int)this.minSize, (int)this.maxSize);
        this.refreshDimensions();
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue((double)size);
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)(size * size));
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue((double)size * 0.04 + 0.1);
        this.entityData.set(SIZE, (Object)size);
        this.xpReward = size + 1;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            if (this.isMovingOnLand()) {
                this.moveAnimationState.startIfStopped(this.tickCount);
            } else {
                this.moveAnimationState.stop();
            }
        }
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.MAX_HEALTH, 16.0).add(Attributes.MOVEMENT_SPEED, 0.1);
    }

    public EntityDimensions getDefaultDimensions(Pose pPose) {
        float scale = this.getScaleFromSize() * this.aabbMult;
        return this.getType().getDimensions().scale(scale);
    }

    public InteractionResult mobInteract(Player pPlayer, InteractionHand pHand) {
        ItemStack itemStack = pPlayer.getItemInHand(pHand);
        if (itemStack.is(IcariaItems.EMPTY_VIAL.get())) {
            ItemStack filledResult = ItemUtils.createFilledResult((ItemStack)itemStack, (Player)pPlayer, (ItemStack)IcariaItems.HYLIASTRUM_VIAL.get().getDefaultInstance());
            this.remove();
            this.setSize(this.getSize() - 1);
            pPlayer.awardStat(Stats.ITEM_USED.get((Object)IcariaItems.EMPTY_VIAL.get()));
            pPlayer.playSound(IcariaSoundEvents.VIAL_FILL);
            pPlayer.setItemInHand(pHand, filledResult);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(pPlayer, pHand);
    }

    public SoundEvent getDeathSound() {
        return IcariaSoundEvents.HYLIASTER_DEATH;
    }

    public SoundEvent getHurtSound(DamageSource pDamageSource) {
        return IcariaSoundEvents.HYLIASTER_HURT;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        this.setSize(this.random.nextIntBetweenInclusive(1, 4));
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }
}

