/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.entity.IcariaBreedableEntity;
import com.axanthic.icaria.common.entity.SizedPathfinderMobEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class IcariaAnimalEntity
extends SizedPathfinderMobEntity
implements IcariaBreedableEntity {
    public int maxCooldown = 16000;
    public int minCooldown = 0;
    public int maxDuration = 1200;
    public int minDuration = 0;
    public int maxTick = 64000;
    public int minTick = 0;
    public static final EntityDataAccessor<Integer> COOLDOWN = SynchedEntityData.defineId(IcariaAnimalEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.defineId(IcariaAnimalEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> TICK = SynchedEntityData.defineId(IcariaAnimalEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public IcariaAnimalEntity(EntityType<? extends IcariaAnimalEntity> pType, Level pLevel, float pAabbMult, float pRenderMult, float pShadowMult, float pSizeMult, float pSizeMultInverted) {
        super(pType, pLevel, pAabbMult, pRenderMult, pShadowMult, pSizeMult, pSizeMultInverted);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
    }

    public boolean canMate(IcariaAnimalEntity pEntity) {
        if (pEntity == this) {
            return false;
        }
        if (pEntity.getClass() != this.getClass()) {
            return false;
        }
        return this.inLove() && pEntity.inLove();
    }

    public static boolean checkAnimalSpawnRules(EntityType<? extends IcariaAnimalEntity> pAnimal, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return IcariaAnimalEntity.isBrightEnoughToSpawn((BlockAndTintGetter)pLevel, pPos);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.isInvulnerableTo(pSource)) {
            return false;
        }
        this.setDuration(this.minDuration);
        return super.hurt(pSource, pAmount);
    }

    public boolean inLove() {
        return this.getDuration() > this.minDuration;
    }

    public static boolean isBrightEnoughToSpawn(BlockAndTintGetter pLevel, BlockPos pPos) {
        return pLevel.getRawBrightness(pPos, 0) > 8;
    }

    public boolean isFood(ItemStack pStack) {
        return false;
    }

    public boolean onCooldown() {
        return this.getCooldown() > this.minCooldown;
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return false;
    }

    public int age(int pAge) {
        if (this.getTick() < 16000) {
            return Math.min(this.getTick() + pAge, 16000);
        }
        if (this.getTick() < 32000) {
            return Math.min(this.getTick() + pAge, 32000);
        }
        if (this.getTick() < 48000) {
            return Math.min(this.getTick() + pAge, 48000);
        }
        return Math.min(this.getTick() + pAge, 64000);
    }

    public int getCooldown() {
        return (Integer)this.entityData.get(COOLDOWN);
    }

    public int getDuration() {
        return (Integer)this.entityData.get(DURATION);
    }

    public int getTick() {
        return (Integer)this.entityData.get(TICK);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Cooldown", this.getCooldown());
        pCompound.putInt("Duration", this.getDuration());
        pCompound.putInt("Tick", this.getTick());
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.isAlive()) {
            int tick;
            int duration;
            int cooldown = this.getCooldown();
            if (cooldown > this.minCooldown) {
                this.setCooldown(--cooldown);
            }
            if ((duration = this.getDuration()) > this.minDuration) {
                this.setDuration(--duration);
                if (this.getDuration() % 10 == 0) {
                    double random = this.random.nextGaussian() * 0.025;
                    this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), random, random, random);
                }
            }
            if ((tick = this.getTick()) < 16000) {
                this.setSize(1);
                this.setTick(++tick);
            } else if (tick < 32000) {
                this.setSize(2);
                this.heal(16000);
                this.setTick(++tick);
            } else if (tick < 48000) {
                this.setSize(3);
                this.heal(32000);
                this.setTick(++tick);
            } else if (tick < 64000) {
                this.setSize(4);
                this.heal(48000);
                this.setTick(++tick);
            }
        }
    }

    public void ate() {
        super.ate();
        if (this.isBaby()) {
            this.setTick(this.age(1200));
        }
    }

    @Override
    public void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(COOLDOWN, (Object)this.minCooldown);
        pBuilder.define(DURATION, (Object)this.minDuration);
        pBuilder.define(TICK, (Object)this.minTick);
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 18) {
            for (int i = 0; i < 7; ++i) {
                double random = this.random.nextGaussian() * 0.025;
                this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), random, random, random);
            }
        } else {
            super.handleEntityEvent(pId);
        }
    }

    public void heal(int pTick) {
        if (this.getTick() == pTick) {
            this.setHealth(this.getMaxHealth());
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setCooldown(pCompound.getInt("Cooldown"));
        this.setDuration(pCompound.getInt("Duration"));
        this.setTick(pCompound.getInt("Tick"));
    }

    public void setCooldown(int pSize) {
        int ticks = Mth.clamp((int)pSize, (int)this.minCooldown, (int)this.maxCooldown);
        this.entityData.set(COOLDOWN, (Object)ticks);
    }

    public void setDuration(int pSize) {
        int ticks = Mth.clamp((int)pSize, (int)this.minDuration, (int)this.maxDuration);
        this.entityData.set(DURATION, (Object)ticks);
    }

    public void setTick(int pSize) {
        int tick = Mth.clamp((int)pSize, (int)this.minTick, (int)this.maxTick);
        this.entityData.set(TICK, (Object)tick);
    }

    public void spawnChildFromBreeding(ServerLevel pLevel, IcariaAnimalEntity pEntity) {
        IcariaAnimalEntity entity = this.getBreedOffspring(pLevel, pEntity);
        if (entity != null) {
            entity.moveTo(this.getX(), this.getY(), this.getZ(), 0.0f, 0.0f);
            entity.setSize(this.minSize);
            entity.setTick(this.minTick);
            pEntity.setCooldown(this.maxCooldown);
            this.setCooldown(this.maxCooldown);
            pEntity.setDuration(this.minDuration);
            this.setDuration(this.minDuration);
            pLevel.addFreshEntityWithPassengers((Entity)entity);
            pLevel.broadcastEntityEvent((Entity)this, (byte)18);
            if (pLevel.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
                pLevel.addFreshEntity((Entity)new ExperienceOrb((Level)pLevel, this.getX(), this.getY(), this.getZ(), this.getRandom().nextInt(7) + 1));
            }
        }
    }

    @Nonnull
    public InteractionResult mobInteract(Player pPlayer, InteractionHand pHand) {
        ItemStack itemStack = pPlayer.getItemInHand(pHand);
        if (this.isFood(itemStack)) {
            if (!(this.level().isClientSide() || this.isBaby() || this.inLove() || this.onCooldown())) {
                itemStack.shrink(1);
                pPlayer.awardStat(Stats.ANIMALS_BRED);
                this.level().broadcastEntityEvent((Entity)this, (byte)18);
                this.setDuration(this.maxDuration);
                return InteractionResult.SUCCESS;
            }
            if (this.isBaby()) {
                itemStack.shrink(1);
                this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
                this.setTick(this.age(1200));
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
            }
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
        }
        return super.mobInteract(pPlayer, pHand);
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        this.setTick(this.random.nextIntBetweenInclusive(0, 64000));
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }
}

