/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.block.RackBlock;
import com.axanthic.icaria.common.registry.IcariaBlockStateProperties;
import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.registry.IcariaLootTables;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import com.axanthic.icaria.common.registry.IcariaWoodTypes;
import com.axanthic.icaria.data.tags.IcariaBlockTags;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaBarrelEntity
extends Entity {
    public static final EntityDataAccessor<BlockPos> BLOCK_POS = SynchedEntityData.defineId(IcariaBarrelEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    public static final EntityDataAccessor<BlockState> BLOCK_STATE = SynchedEntityData.defineId(IcariaBarrelEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);

    public IcariaBarrelEntity(EntityType<? extends IcariaBarrelEntity> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public IcariaBarrelEntity(EntityType<? extends IcariaBarrelEntity> pType, Level pLevel, BlockState pState, BlockPos pPos) {
        this(pType, pLevel);
        this.setBlockPos(pPos);
        this.setBlockState(pState);
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public boolean isAttackable() {
        return false;
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public boolean onlyOpCanSetNbt() {
        return true;
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
    }

    public void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(BLOCK_POS, (Object)BlockPos.ZERO);
        pBuilder.define(BLOCK_STATE, (Object)Blocks.AIR.defaultBlockState());
    }

    public void dropFromLootTable(DamageSource pDamageSource) {
        Level level;
        if (this.level().getServer() != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootParams lootContext = new LootParams.Builder(serverLevel).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)pDamageSource.getDirectEntity()).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)pDamageSource.getEntity()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)pDamageSource).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)this).create(LootContextParamSets.ENTITY);
            lootContext.getLevel().getServer().reloadableRegistries().getLootTable(IcariaLootTables.BARREL_LOOT).getRandomItems(lootContext).forEach(arg_0 -> ((IcariaBarrelEntity)this).spawnAtLocation(arg_0));
        }
    }

    public void playerTouch(Player pPlayer) {
        if (pPlayer instanceof ServerPlayer && !pPlayer.isCreative()) {
            pPlayer.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN), (Entity)this);
        }
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
    }

    public void rideTick() {
        super.rideTick();
        Entity entity = this.getVehicle();
        if (entity != null && entity.isShiftKeyDown()) {
            this.stopRiding();
            this.setDeltaMovement(-Mth.sin((float)(entity.getYRot() * ((float)Math.PI / 180))), -Mth.sin((float)(entity.getXRot() * ((float)Math.PI / 180))), Mth.cos((float)(entity.getYRot() * ((float)Math.PI / 180))));
        }
    }

    public void setBlockPos(BlockPos pPos) {
        this.entityData.set(BLOCK_POS, (Object)pPos);
    }

    public void setBlockState(BlockState pState) {
        this.entityData.set(BLOCK_STATE, (Object)pState);
    }

    public void tick() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        if (this.onGround()) {
            if (!this.level().isClientSide()) {
                if (this.getBlockState().hasProperty((Property)IcariaBlockStateProperties.LOADED_BARREL) && ((Boolean)this.getBlockState().getValue((Property)IcariaBlockStateProperties.LOADED_BARREL)).booleanValue() || this.getBlockState().is(IcariaBlockTags.LOADED_BARRELS)) {
                    this.level().explode((Entity)this, x, y, z, 2.0f, Level.ExplosionInteraction.BLOCK);
                    for (int i = -2; i <= 2; ++i) {
                        BlockPos negPos = BlockPos.containing((double)(x - (double)i), (double)(y - (double)i), (double)(z - (double)i));
                        BlockPos posPos = BlockPos.containing((double)(x + (double)i), (double)(y + (double)i), (double)(z + (double)i));
                        for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)negPos, (BlockPos)posPos)) {
                            BlockPos belowPos = blockPos.below();
                            if (this.level().getRandom().nextInt(10) != 0 || !this.level().getBlockState(blockPos).isAir() || !this.level().getBlockState(belowPos).isSolidRender((BlockGetter)this.level(), belowPos)) continue;
                            this.level().setBlockAndUpdate(blockPos, IcariaBlocks.GREEK_FIRE.get().defaultBlockState());
                        }
                    }
                } else if (this.getBlockState().hasProperty((Property)IcariaBlockStateProperties.TAPPED_BARREL) && ((Boolean)this.getBlockState().getValue((Property)IcariaBlockStateProperties.TAPPED_BARREL)).booleanValue() || this.getBlockState().is(IcariaBlockTags.TAPPED_BARRELS)) {
                    for (int i = -1; i <= 1; ++i) {
                        BlockPos negPos = BlockPos.containing((double)(x - (double)i), (double)(y - (double)i), (double)(z - (double)i));
                        BlockPos posPos = BlockPos.containing((double)(x + (double)i), (double)(y + (double)i), (double)(z + (double)i));
                        for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)negPos, (BlockPos)posPos)) {
                            BlockPos belowPos = blockPos.below();
                            if (this.level().getRandom().nextInt(10) != 0 || !this.level().getBlockState(blockPos).isAir() || !this.level().getBlockState(belowPos).isSolidRender((BlockGetter)this.level(), belowPos)) continue;
                            this.level().setBlockAndUpdate(blockPos, IcariaBlocks.MEDITERRANEAN_WATER.get().defaultBlockState());
                        }
                    }
                } else {
                    this.dropFromLootTable(this.damageSources().fall());
                }
            }
            this.discard();
            this.playSound(IcariaSoundEvents.BARREL_BREAK);
        } else {
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.05, 0.0));
        }
    }

    public BlockPos getBlockPos() {
        return (BlockPos)this.entityData.get(BLOCK_POS);
    }

    public BlockState getBlockState() {
        return (BlockState)this.entityData.get(BLOCK_STATE);
    }

    public BlockState getLoaded() {
        Block block = this.getBlockState().getBlock();
        if (block instanceof RackBlock) {
            RackBlock block2 = (RackBlock)block;
            if (block2.getType().equals((Object)IcariaWoodTypes.CYPRESS)) {
                return IcariaBlocks.LOADED_CYPRESS_BARREL.get().defaultBlockState();
            }
            if (block2.getType().equals((Object)IcariaWoodTypes.DROUGHTROOT)) {
                return IcariaBlocks.LOADED_DROUGHTROOT_BARREL.get().defaultBlockState();
            }
            if (block2.getType().equals((Object)IcariaWoodTypes.FIR)) {
                return IcariaBlocks.LOADED_FIR_BARREL.get().defaultBlockState();
            }
            if (block2.getType().equals((Object)IcariaWoodTypes.LAUREL)) {
                return IcariaBlocks.LOADED_LAUREL_BARREL.get().defaultBlockState();
            }
            if (block2.getType().equals((Object)IcariaWoodTypes.OLIVE)) {
                return IcariaBlocks.LOADED_OLIVE_BARREL.get().defaultBlockState();
            }
            if (block2.getType().equals((Object)IcariaWoodTypes.PLANE)) {
                return IcariaBlocks.LOADED_PLANE_BARREL.get().defaultBlockState();
            }
            return IcariaBlocks.LOADED_POPULUS_BARREL.get().defaultBlockState();
        }
        return this.getBlockState();
    }

    public BlockState getNormal() {
        Block block = this.getBlockState().getBlock();
        if (block instanceof RackBlock) {
            RackBlock block2 = (RackBlock)block;
            if (block2.getType().equals((Object)IcariaWoodTypes.CYPRESS)) {
                return IcariaBlocks.CYPRESS_BARREL.get().defaultBlockState();
            }
            if (block2.getType().equals((Object)IcariaWoodTypes.DROUGHTROOT)) {
                return IcariaBlocks.DROUGHTROOT_BARREL.get().defaultBlockState();
            }
            if (block2.getType().equals((Object)IcariaWoodTypes.FIR)) {
                return IcariaBlocks.FIR_BARREL.get().defaultBlockState();
            }
            if (block2.getType().equals((Object)IcariaWoodTypes.LAUREL)) {
                return IcariaBlocks.LAUREL_BARREL.get().defaultBlockState();
            }
            if (block2.getType().equals((Object)IcariaWoodTypes.OLIVE)) {
                return IcariaBlocks.OLIVE_BARREL.get().defaultBlockState();
            }
            if (block2.getType().equals((Object)IcariaWoodTypes.PLANE)) {
                return IcariaBlocks.PLANE_BARREL.get().defaultBlockState();
            }
            return IcariaBlocks.POPULUS_BARREL.get().defaultBlockState();
        }
        return this.getBlockState();
    }

    public BlockState getTapped() {
        Block block = this.getBlockState().getBlock();
        if (block instanceof RackBlock) {
            RackBlock block2 = (RackBlock)block;
            if (block2.getType().equals((Object)IcariaWoodTypes.CYPRESS)) {
                return IcariaBlocks.TAPPED_CYPRESS_BARREL.get().defaultBlockState();
            }
            if (block2.getType().equals((Object)IcariaWoodTypes.DROUGHTROOT)) {
                return IcariaBlocks.TAPPED_DROUGHTROOT_BARREL.get().defaultBlockState();
            }
            if (block2.getType().equals((Object)IcariaWoodTypes.FIR)) {
                return IcariaBlocks.TAPPED_FIR_BARREL.get().defaultBlockState();
            }
            if (block2.getType().equals((Object)IcariaWoodTypes.LAUREL)) {
                return IcariaBlocks.TAPPED_LAUREL_BARREL.get().defaultBlockState();
            }
            if (block2.getType().equals((Object)IcariaWoodTypes.OLIVE)) {
                return IcariaBlocks.TAPPED_OLIVE_BARREL.get().defaultBlockState();
            }
            if (block2.getType().equals((Object)IcariaWoodTypes.PLANE)) {
                return IcariaBlocks.TAPPED_PLANE_BARREL.get().defaultBlockState();
            }
            return IcariaBlocks.TAPPED_POPULUS_BARREL.get().defaultBlockState();
        }
        return this.getBlockState();
    }

    public BlockState getRenderState() {
        if (this.getBlockState().getBlock() instanceof RackBlock) {
            if (((Boolean)this.getBlockState().getValue((Property)IcariaBlockStateProperties.LOADED_BARREL)).booleanValue()) {
                return this.getLoaded();
            }
            if (((Boolean)this.getBlockState().getValue((Property)IcariaBlockStateProperties.TAPPED_BARREL)).booleanValue()) {
                return this.getTapped();
            }
            return this.getNormal();
        }
        return this.getBlockState();
    }

    public Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }
}

