/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.data.tags.IcariaPaintingVariantTags;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.Validate;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IcariaPaintingEntity
extends Painting {
    public IcariaPaintingEntity(EntityType<? extends Painting> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public IcariaPaintingEntity(Level pLevel, BlockPos pPos) {
        super(IcariaEntityTypes.PAINTING.get(), pLevel);
        this.pos = pPos;
    }

    public static int variantArea(Holder<PaintingVariant> pHolder) {
        return ((PaintingVariant)pHolder.value()).area();
    }

    public void setDirection(Direction pDirection) {
        Objects.requireNonNull(pDirection);
        Validate.isTrue((boolean)pDirection.getAxis().isHorizontal());
        this.direction = pDirection;
        this.setYRot((float)this.getDirection().get2DDataValue() * 90.0f);
        this.yRotO = this.getYRot();
        this.recalculateBoundingBox();
    }

    public ItemEntity spawnAtLocation(ItemLike pItem) {
        return super.spawnAtLocation((ItemLike)IcariaItems.PAINTING.get());
    }

    public ItemStack getPickResult() {
        return IcariaItems.PAINTING.get().getDefaultInstance();
    }

    public static Optional<Painting> create(Level pLevel, BlockPos pPos, Direction pDirection) {
        ArrayList<Holder> list = new ArrayList<Holder>();
        IcariaPaintingEntity painting = new IcariaPaintingEntity(pLevel, pPos);
        pLevel.registryAccess().registryOrThrow(Registries.PAINTING_VARIANT).getTagOrEmpty(IcariaPaintingVariantTags.PLACEABLE).forEach(list::add);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        painting.setDirection(pDirection);
        list.removeIf(holder -> {
            painting.setVariant((Holder)holder);
            return !painting.survives();
        });
        if (list.isEmpty()) {
            return Optional.empty();
        }
        list.removeIf(holder -> IcariaPaintingEntity.variantArea((Holder<PaintingVariant>)holder) < list.stream().mapToInt(IcariaPaintingEntity::variantArea).max().orElse(0));
        Optional optional = Util.getRandomSafe(list, (RandomSource)painting.getRandom());
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        painting.setDirection(pDirection);
        painting.setVariant((Holder)optional.get());
        return Optional.of(painting);
    }
}

