/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.entity.SizedFlyingMobEntity;
import com.axanthic.icaria.common.goal.JellyfishFleeGoal;
import com.axanthic.icaria.common.goal.JellyfishRandomMovementGoal;
import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class JellyfishEntity
extends SizedFlyingMobEntity {
    public float rotateSpeed;
    public float speed;
    public float tentacleAngle;
    public float oldTentacleAngle;
    public float tentacleMovement;
    public float oldTentacleMovement;
    public float tentacleSpeed;
    public float tx;
    public float ty;
    public float tz;
    public float xBodyRot;
    public float oldXBodyRot;
    public float zBodyRot;
    public float oldZBodyRot;

    public JellyfishEntity(EntityType<? extends JellyfishEntity> pType, Level pLevel) {
        super(pType, pLevel, 0.25f, 0.25f, 0.15f, 0.75f, 0.25f);
        this.tentacleSpeed = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
    }

    public boolean hasMovementVector() {
        return this.tx != 0.0f || this.ty != 0.0f || this.tz != 0.0f;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.getType() == IcariaEntityTypes.ENDER_JELLYFISH.get()) {
            if (this.isInvulnerableTo(pSource)) {
                return false;
            }
            if (pSource.is(DamageTypeTags.IS_PROJECTILE)) {
                boolean flag;
                Entity entity = pSource.getDirectEntity();
                if (entity instanceof ThrownPotion) {
                    ThrownPotion thrownPotion = (ThrownPotion)entity;
                    flag = this.hurtWithCleanWater(pSource, thrownPotion, pAmount);
                } else {
                    flag = false;
                }
                for (int i = 0; i < 64; ++i) {
                    if (!this.teleport()) continue;
                    return true;
                }
                return flag;
            }
            if (!this.level().isClientSide() && this.random.nextInt(10) != 0 && !(pSource.getEntity() instanceof LivingEntity)) {
                this.teleport();
            }
            return super.hurt(pSource, pAmount);
        }
        return super.hurt(pSource, pAmount);
    }

    public boolean hurtWithCleanWater(DamageSource pSource, ThrownPotion pPotion, float pAmount) {
        return super.hurt(pSource, pAmount) && ((PotionContents)pPotion.getItem().getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).is(Potions.WATER);
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public boolean isSensitiveToWater() {
        return this.getType() == IcariaEntityTypes.ENDER_JELLYFISH.get();
    }

    public boolean teleport() {
        if (!this.level().isClientSide() && this.isAlive()) {
            return this.teleport(this.getX() + (this.random.nextDouble() - 0.5) * 64.0, this.getY() + (double)(this.random.nextInt(64) - 32), this.getZ() + (this.random.nextDouble() - 0.5) * 64.0);
        }
        return false;
    }

    public boolean teleport(double pX, double pY, double pZ) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pX, pY, pZ);
        while (mutablePos.getY() > this.level().getMinBuildHeight() && !this.level().getBlockState((BlockPos)mutablePos).blocksMotion()) {
            mutablePos.move(Direction.DOWN);
        }
        BlockState blockState = this.level().getBlockState((BlockPos)mutablePos);
        if (blockState.blocksMotion() && !blockState.getFluidState().is(FluidTags.WATER)) {
            if (EventHooks.onEnderTeleport((LivingEntity)this, (double)pX, (double)pY, (double)pZ).isCanceled()) {
                return false;
            }
            return this.randomTeleport(pX, pY, pZ, true);
        }
        return false;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        this.oldTentacleAngle = this.tentacleAngle;
        this.oldTentacleMovement = this.tentacleMovement;
        this.tentacleMovement += this.tentacleSpeed;
        this.oldXBodyRot = this.xBodyRot;
        this.oldZBodyRot = this.zBodyRot;
        if ((double)this.tentacleMovement > 6.2831854820251465) {
            if (this.level().isClientSide()) {
                this.tentacleMovement = (float)Math.PI * 2;
            } else {
                this.tentacleMovement -= (float)Math.PI * 2;
                if (this.random.nextInt(10) == 0) {
                    this.tentacleSpeed = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
                }
                this.level().broadcastEntityEvent((Entity)this, (byte)19);
            }
        }
        if (this.tentacleMovement < (float)Math.PI) {
            float f = this.tentacleMovement / (float)Math.PI;
            this.tentacleAngle = Mth.sin((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
            if ((double)f > 0.75) {
                this.rotateSpeed = 1.0f;
                this.speed = 1.0f;
            } else {
                this.rotateSpeed *= 0.8f;
            }
        } else {
            this.rotateSpeed *= 0.99f;
            this.speed *= 0.9f;
            this.tentacleAngle = 0.0f;
        }
        if (!this.level().isClientSide()) {
            this.setDeltaMovement(this.tx * this.speed, this.ty * this.speed, this.tz * this.speed);
        }
        Vec3 vec3 = this.getDeltaMovement();
        this.xBodyRot += (float)(-Mth.atan2((double)vec3.horizontalDistance(), (double)vec3.y) * 57.2957763671875 * (double)0.1f - (double)(this.xBodyRot * 0.1f));
        this.yBodyRot += (float)((-Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875 - (double)this.yBodyRot) * (double)0.1f);
        this.zBodyRot += (float)Math.PI * this.rotateSpeed * 1.5f;
        this.setYRot(this.yBodyRot);
        if (this.getType() == IcariaEntityTypes.ENDER_JELLYFISH.get() && this.level().isClientSide()) {
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getRandomX(0.5), this.getRandomY() - 0.25, this.getRandomZ(0.5), (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    public void customServerAiStep() {
        super.customServerAiStep();
        if (this.getType() == IcariaEntityTypes.ENDER_JELLYFISH.get() && this.random.nextInt(100) == 0) {
            this.teleport();
        }
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 19) {
            this.tentacleMovement = 0.0f;
        } else {
            super.handleEntityEvent(pId);
        }
    }

    public void playerTouch(Player pPlayer) {
        if (pPlayer instanceof ServerPlayer) {
            pPlayer.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getSize());
            if (!pPlayer.isCreative()) {
                if (this.getType() == IcariaEntityTypes.ENDER_JELLYFISH.get()) {
                    pPlayer.addEffect(new MobEffectInstance(MobEffects.WITHER, this.getSize() * 100, 0), (Entity)this);
                } else if (this.getType() == IcariaEntityTypes.FIRE_JELLYFISH.get()) {
                    pPlayer.igniteForSeconds((float)(this.getSize() * 5));
                } else if (this.getType() == IcariaEntityTypes.NATURE_JELLYFISH.get()) {
                    pPlayer.addEffect(new MobEffectInstance(MobEffects.POISON, this.getSize() * 100, 0), (Entity)this);
                } else if (this.getType() == IcariaEntityTypes.VOID_JELLYFISH.get()) {
                    pPlayer.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, this.getSize() * 100, 0), (Entity)this);
                } else if (this.getType() == IcariaEntityTypes.WATER_JELLYFISH.get()) {
                    pPlayer.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, this.getSize() * 100, 0), (Entity)this);
                }
            }
        }
    }

    public void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new JellyfishRandomMovementGoal(this));
        this.goalSelector.addGoal(2, (Goal)new JellyfishFleeGoal(this));
    }

    public void setMovementVector(float pTx, float pTy, float pTz) {
        this.tx = pTx;
        this.ty = pTy;
        this.tz = pTz;
    }

    @Override
    public void setSize(int pSize) {
        super.setSize(pSize);
        int size = Mth.clamp((int)pSize, (int)this.minSize, (int)this.maxSize);
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue((double)size);
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)(size * size));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.MAX_HEALTH, 16.0);
    }

    public Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    public PathNavigation createNavigation(Level pLevel) {
        return new FlyingPathNavigation((Mob)this, pLevel);
    }

    public SoundEvent getAmbientSound() {
        return IcariaSoundEvents.JELLYFISH_AMBIENT;
    }

    public SoundEvent getDeathSound() {
        return IcariaSoundEvents.JELLYFISH_DEATH;
    }

    public SoundEvent getHurtSound(DamageSource pDamageSource) {
        return IcariaSoundEvents.JELLYFISH_HURT;
    }
}

