/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.registry.IcariaBlocks;
import com.axanthic.icaria.common.registry.IcariaLootTables;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LootVaseEntity
extends Entity {
    public static final EntityDataAccessor<BlockPos> BLOCK_POS = SynchedEntityData.defineId(LootVaseEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    public static final EntityDataAccessor<BlockState> BLOCK_STATE = SynchedEntityData.defineId(LootVaseEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);

    public LootVaseEntity(EntityType<? extends LootVaseEntity> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public LootVaseEntity(EntityType<? extends LootVaseEntity> pType, Level pLevel, BlockState pState, BlockPos pPos) {
        this(pType, pLevel);
        this.setBlockPos(pPos);
        this.setBlockState(pState);
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public boolean isAttackable() {
        return false;
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public boolean onlyOpCanSetNbt() {
        return true;
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
    }

    public void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(BLOCK_POS, (Object)BlockPos.ZERO);
        pBuilder.define(BLOCK_STATE, (Object)Blocks.AIR.defaultBlockState());
    }

    public void dropFromLootTable(DamageSource pDamageSource) {
        Level level;
        if (this.level().getServer() != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootParams lootContext = new LootParams.Builder(serverLevel).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)pDamageSource.getDirectEntity()).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)pDamageSource.getEntity()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)pDamageSource).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)this).create(LootContextParamSets.ENTITY);
            ResourceKey<LootTable> lootTable = this.getBlockState().is(IcariaBlocks.RED_LOOT_VASE.get()) ? IcariaLootTables.RED_LOOT_VASE_LOOT : (this.getBlockState().is(IcariaBlocks.LOST_LOOT_VASE.get()) ? IcariaLootTables.LOST_LOOT_VASE_LOOT : IcariaLootTables.CYAN_LOOT_VASE_LOOT);
            lootContext.getLevel().getServer().reloadableRegistries().getLootTable(lootTable).getRandomItems(lootContext).forEach(arg_0 -> ((LootVaseEntity)this).spawnAtLocation(arg_0));
        }
    }

    public void playerTouch(Player pPlayer) {
        if (pPlayer instanceof ServerPlayer && !pPlayer.isCreative()) {
            pPlayer.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN), (Entity)this);
        }
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
    }

    public void rideTick() {
        super.rideTick();
        Entity entity = this.getVehicle();
        if (entity != null && entity.isShiftKeyDown()) {
            this.stopRiding();
            this.setDeltaMovement(-Mth.sin((float)(entity.getYRot() * ((float)Math.PI / 180))), -Mth.sin((float)(entity.getXRot() * ((float)Math.PI / 180))), Mth.cos((float)(entity.getYRot() * ((float)Math.PI / 180))));
        }
    }

    public void setBlockPos(BlockPos pPos) {
        this.entityData.set(BLOCK_POS, (Object)pPos);
    }

    public void setBlockState(BlockState pState) {
        this.entityData.set(BLOCK_STATE, (Object)pState);
    }

    public void tick() {
        if (this.onGround()) {
            this.discard();
            this.dropFromLootTable(this.damageSources().fall());
            this.playSound(IcariaSoundEvents.VASE_BREAK);
        } else {
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.05, 0.0));
        }
    }

    public BlockPos getBlockPos() {
        return (BlockPos)this.entityData.get(BLOCK_POS);
    }

    public BlockState getBlockState() {
        return (BlockState)this.entityData.get(BLOCK_STATE);
    }

    public Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }
}

