/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.client.helper.IcariaClientHelper;
import com.axanthic.icaria.common.goal.MyrmekeQueenHurtByTargetGoal;
import com.axanthic.icaria.common.goal.MyrmekeQueenSummonGoal;
import com.axanthic.icaria.common.registry.IcariaEntityTypes;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import com.axanthic.icaria.common.util.IcariaSummonSpellTypes;
import com.axanthic.icaria.data.tags.IcariaBlockTags;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MyrmekeQueenEntity
extends Monster {
    public float red;
    public float green;
    public float blue;
    public static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.defineId(MyrmekeQueenEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Byte> SPELL = SynchedEntityData.defineId(MyrmekeQueenEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);

    public MyrmekeQueenEntity(EntityType<? extends MyrmekeQueenEntity> pType, Level pLevel) {
        super(pType, pLevel);
        this.xpReward = 10;
    }

    public boolean canBeAffected(MobEffectInstance pEffectInstance) {
        return super.canBeAffected(pEffectInstance) && !pEffectInstance.is(MobEffects.POISON);
    }

    public boolean isClimbing() {
        return ((Byte)this.entityData.get(CLIMBING) & 1) != 0;
    }

    public boolean onClimbable() {
        return this.isClimbing();
    }

    public void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(CLIMBING, (Object)0);
        pBuilder.define(SPELL, (Object)0);
    }

    public void makeStuckInBlock(BlockState pState, Vec3 pMotionMultiplier) {
        if (!pState.is(IcariaBlockTags.COBWEB_BLOCKS)) {
            super.makeStuckInBlock(pState, pMotionMultiplier);
        }
    }

    public void playStepSound(BlockPos pPos, BlockState pState) {
        this.playSound(IcariaSoundEvents.MYRMEKE_QUEEN_STEP, 0.1f, 1.0f);
    }

    public void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MyrmekeQueenSummonGoal(this));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.001f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new MyrmekeQueenHurtByTargetGoal(this).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void setCasting(IcariaSummonSpellTypes pSpell) {
        this.entityData.set(SPELL, (Object)((byte)pSpell.id));
    }

    public void setClimbing(boolean pClimbing) {
        byte b = (Byte)this.entityData.get(CLIMBING);
        b = pClimbing ? (byte)(b | 1) : (byte)(b & 0xFFFFFFFE);
        this.entityData.set(CLIMBING, (Object)b);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.tickRegisterRaysValues();
        } else {
            this.setClimbing(this.horizontalCollision);
        }
    }

    public void tickRegisterRaysValues() {
        if (this.getType() == IcariaEntityTypes.MYRMEKE_QUEEN.get() && this.tickCount < 20) {
            this.red = IcariaClientHelper.getRed((LivingEntity)this);
            this.green = IcariaClientHelper.getGreen((LivingEntity)this);
            this.blue = IcariaClientHelper.getBlue((LivingEntity)this);
        }
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public PathNavigation createNavigation(Level pLevel) {
        return new WallClimberNavigation((Mob)this, pLevel);
    }

    public SoundEvent getAmbientSound() {
        return IcariaSoundEvents.MYRMEKE_QUEEN_AMBIENT;
    }

    public SoundEvent getDeathSound() {
        return IcariaSoundEvents.MYRMEKE_QUEEN_DEATH;
    }

    public SoundEvent getHurtSound(DamageSource pDamageSource) {
        return IcariaSoundEvents.MYRMEKE_QUEEN_HURT;
    }
}

