/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.entity.MyrmekeDroneEntity;
import com.axanthic.icaria.common.goal.MyrmekeSoldierHurtByTargetGoal;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MyrmekeSoldierEntity
extends MyrmekeDroneEntity {
    public int maxTick = 40;
    public int minTick = 0;
    public static final EntityDataAccessor<Integer> TICK = SynchedEntityData.defineId(MyrmekeSoldierEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public MyrmekeSoldierEntity(EntityType<? extends MyrmekeSoldierEntity> pType, Level pLevel) {
        super((EntityType<? extends MyrmekeDroneEntity>)pType, pLevel);
        this.xpReward = 5;
    }

    public boolean onTick() {
        return this.getTick() < this.maxTick;
    }

    public float getShadowStrength() {
        return (float)this.getTick() / (float)this.maxTick;
    }

    public int getTick() {
        return (Integer)this.entityData.get(TICK);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Tick", this.getTick());
    }

    public void aiStep() {
        int tick;
        super.aiStep();
        if (this.isAlive() && (tick = this.getTick()) < this.maxTick) {
            this.setTick(++tick);
        }
    }

    @Override
    public void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(TICK, (Object)this.minTick);
    }

    @Override
    public void playStepSound(BlockPos pPos, BlockState pState) {
        this.playSound(IcariaSoundEvents.MYRMEKE_SOLDIER_STEP, 0.1f, 1.0f);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setTick(pCompound.getInt("Tick"));
    }

    @Override
    public void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new LeapAtTargetGoal((Mob)this, 0.25f));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.001f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new MyrmekeSoldierHurtByTargetGoal(this).setAlertOthers(new Class[0]));
    }

    public void setTick(int pSize) {
        int tick = Mth.clamp((int)pSize, (int)this.minTick, (int)this.maxTick);
        this.entityData.set(TICK, (Object)tick);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.tickParticlePlusSounds();
        }
    }

    public void tickParticlePlusSounds() {
        if (this.onTick()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), this.getBlockStateOn().getSoundType((LevelReader)this.level(), this.blockPosition(), (Entity)this).getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            for (int i = 0; i < 25; ++i) {
                double x = this.getX() + (double)Mth.randomBetween((RandomSource)this.getRandom(), (float)-0.75f, (float)0.75f);
                double y = this.getY();
                double z = this.getZ() + (double)Mth.randomBetween((RandomSource)this.getRandom(), (float)-0.75f, (float)0.75f);
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.getBlockStateOn()), x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.MAX_HEALTH, 16.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    @Override
    public SoundEvent getAmbientSound() {
        return IcariaSoundEvents.MYRMEKE_SOLDIER_AMBIENT;
    }

    @Override
    public SoundEvent getDeathSound() {
        return IcariaSoundEvents.MYRMEKE_SOLDIER_DEATH;
    }

    @Override
    public SoundEvent getHurtSound(DamageSource pDamageSource) {
        return IcariaSoundEvents.MYRMEKE_SOLDIER_HURT;
    }
}

