/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.entity.GreekFireGrenadeEntity;
import com.axanthic.icaria.common.entity.RevenantEntity;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class NetherPyromancerRevenantEntity
extends RevenantEntity
implements RangedAttackMob {
    public int maxAiming = 40;
    public int minAiming = 0;
    public int maxReload = 80;
    public int minReload = 0;
    public int maxThrown = 40;
    public int minThrown = 0;
    public AnimationState reloadAnimationState = new AnimationState();
    public AnimationState thrownAnimationState = new AnimationState();
    public static final EntityDataAccessor<Integer> AIMING = SynchedEntityData.defineId(NetherPyromancerRevenantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> RELOAD = SynchedEntityData.defineId(NetherPyromancerRevenantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> THROWN = SynchedEntityData.defineId(NetherPyromancerRevenantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public NetherPyromancerRevenantEntity(EntityType<? extends NetherPyromancerRevenantEntity> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public boolean onAiming() {
        return this.getAiming() > this.minAiming;
    }

    public boolean onReload() {
        return this.getReload() > this.minReload;
    }

    public boolean onThrown() {
        return this.getThrown() > this.minThrown;
    }

    public int getAiming() {
        return (Integer)this.entityData.get(AIMING);
    }

    public int getReload() {
        return (Integer)this.entityData.get(RELOAD);
    }

    public int getThrown() {
        return (Integer)this.entityData.get(THROWN);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Aiming", this.getAiming());
        pCompound.putInt("Reload", this.getReload());
        pCompound.putInt("Thrown", this.getThrown());
    }

    public void aiStep() {
        int aiming;
        super.aiStep();
        if (this.onThrown()) {
            int thrown = this.getThrown();
            if (thrown > this.minThrown) {
                this.setThrown(--thrown);
                this.setReload(this.maxReload);
            }
        } else if (this.onReload()) {
            int reload = this.getReload();
            if (reload > this.minReload) {
                this.setReload(--reload);
                this.setAiming(this.maxAiming);
                if (reload < this.maxReload / 2) {
                    this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)IcariaItems.GREEK_FIRE_GRENADE.get()));
                }
            }
        } else if (this.onAiming() && (aiming = this.getAiming()) > this.minAiming) {
            this.setAiming(--aiming);
        }
    }

    public void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(AIMING, (Object)this.minAiming);
        pBuilder.define(RELOAD, (Object)this.minReload);
        pBuilder.define(THROWN, (Object)this.minThrown);
    }

    public void performRangedAttack(LivingEntity pTarget, float pVelocity) {
        if (!this.onAiming()) {
            GreekFireGrenadeEntity entity = new GreekFireGrenadeEntity(this.level(), (LivingEntity)this, this.useItem);
            double d0 = pTarget.getX() - this.getX();
            double d1 = pTarget.getY(0.3) - entity.getY();
            double d2 = pTarget.getZ() - this.getZ();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            entity.shoot(d0, d1 + d3 * 0.2, d2, 1.0f, 8.0f);
            this.level().addFreshEntity((Entity)entity);
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            this.setThrown(this.maxThrown);
            if (!this.isSilent()) {
                this.level().playSound(null, this.blockPosition(), IcariaSoundEvents.GREEK_FIRE_GRENADE_THROW, SoundSource.HOSTILE, 0.1f, 1.0f);
            }
        }
    }

    public void populateDefaultEquipmentSlots(RandomSource pRandom, DifficultyInstance pDifficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)IcariaItems.GREEK_FIRE_GRENADE.get()));
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setAiming(pCompound.getInt("Aiming"));
        this.setReload(pCompound.getInt("Reload"));
        this.setAiming(pCompound.getInt("Thrown"));
    }

    @Override
    public void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 80, 12.0f));
        this.goalSelector.addGoal(3, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.001f));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f, 0.025f, false));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, true));
    }

    public void setAiming(int pTick) {
        this.entityData.set(AIMING, (Object)pTick);
    }

    public void setReload(int pTick) {
        this.entityData.set(RELOAD, (Object)pTick);
    }

    public void setThrown(int pTick) {
        this.entityData.set(THROWN, (Object)pTick);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            if (this.onThrown()) {
                this.thrownAnimationState.startIfStopped(this.tickCount);
                this.reloadAnimationState.stop();
            } else if (this.onReload()) {
                this.reloadAnimationState.startIfStopped(this.tickCount);
                this.thrownAnimationState.stop();
            }
        }
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    @Override
    public SoundEvent getAmbientSound() {
        return IcariaSoundEvents.NETHER_PYROMANCER_REVENANT_AMBIENT;
    }
}

