/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SizedFlyingMobEntity
extends FlyingMob {
    public int maxSize = 4;
    public int minSize = 1;
    public float aabbMult;
    public float renderMult;
    public float shadowMult;
    public float sizeMult;
    public float sizeMultInverted;
    public static final EntityDataAccessor<Integer> SIZE = SynchedEntityData.defineId(SizedFlyingMobEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public SizedFlyingMobEntity(EntityType<? extends SizedFlyingMobEntity> pType, Level pLevel, float pAabbMult, float pRenderMult, float pShadowMult, float pSizeMult, float pSizeMultInverted) {
        super(pType, pLevel);
        this.aabbMult = pAabbMult;
        this.renderMult = pRenderMult;
        this.shadowMult = pShadowMult;
        this.sizeMult = pSizeMult;
        this.sizeMultInverted = pSizeMultInverted;
    }

    public static boolean checkMobSpawnRules(EntityType<? extends Mob> pType, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return true;
    }

    public boolean isBaby() {
        return this.getSize() < this.maxSize;
    }

    public float getSizeInverted() {
        return (float)this.getSize() * -1.0f + 5.0f;
    }

    public float getScaleForRender() {
        return this.getScaleFromSize() * this.renderMult;
    }

    public float getScaleForShadow() {
        return this.getScaleFromSize() * this.shadowMult;
    }

    public float getScaleFromSize() {
        return this.getSizeWithMultInverted() + this.getSizeWithMult();
    }

    public float getSizeWithMult() {
        return (float)this.getSize() * this.sizeMult;
    }

    public float getSizeWithMultInverted() {
        return this.getSizeInverted() * this.sizeMultInverted;
    }

    public float getVoicePitch() {
        return this.getSizeWithMultInverted() + 0.75f;
    }

    public int getSize() {
        return (Integer)this.entityData.get(SIZE);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Size", this.getSize());
    }

    public void aiStep() {
        super.aiStep();
        if (this.isAlive()) {
            this.setSize(this.getSize());
        }
    }

    public void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(SIZE, (Object)this.minSize);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        super.onSyncedDataUpdated(pKey);
        if (SIZE.equals(pKey)) {
            this.refreshDimensions();
        }
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setSize(pCompound.getInt("Size"));
    }

    public void setSize(int pSize) {
        int size = Mth.clamp((int)pSize, (int)this.minSize, (int)this.maxSize);
        this.refreshDimensions();
        this.entityData.set(SIZE, (Object)size);
        this.xpReward = size + 1;
    }

    public EntityDimensions getDefaultDimensions(Pose pPose) {
        float scale = this.getScaleFromSize() * this.aabbMult;
        return this.getType().getDimensions().scale(scale);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        this.setSize(this.random.nextIntBetweenInclusive(1, 4));
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }
}

