/*
 * Decompiled with CFR 0.152.
 */
package com.axanthic.icaria.common.entity;

import com.axanthic.icaria.common.entity.SizedPathfinderMobEntity;
import com.axanthic.icaria.common.registry.IcariaItems;
import com.axanthic.icaria.common.registry.IcariaSoundEvents;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SnullEntity
extends SizedPathfinderMobEntity {
    public int maxCooldown = 400;
    public int minCooldown = 0;
    public int maxHide = 80;
    public int minHide = 0;
    public int maxShow = 80;
    public int minShow = 0;
    public AnimationState hideAnimationState = new AnimationState();
    public AnimationState hurtAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState moveAnimationState = new AnimationState();
    public AnimationState showAnimationState = new AnimationState();
    public static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.defineId(SnullEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Integer> COOLDOWN = SynchedEntityData.defineId(SnullEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> HIDE = SynchedEntityData.defineId(SnullEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> SHOW = SynchedEntityData.defineId(SnullEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public SnullEntity(EntityType<? extends SnullEntity> pType, Level pLevel) {
        super(pType, pLevel, 0.25f, 0.25f, 0.15f, 0.75f, 0.25f);
    }

    public boolean doHide() {
        return !this.onCooldown() && !this.onHide() && !this.onShow();
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.doHide() && this.getHealth() < 4.0f) {
            this.setHide(this.maxHide);
        }
        return super.hurt(pSource, pAmount);
    }

    public boolean isClimbing() {
        return ((Byte)this.entityData.get(CLIMBING) & 1) != 0;
    }

    public boolean isMovingOnLand() {
        return this.onGround() && this.getDeltaMovement().horizontalDistanceSqr() > 0.0;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean onClimbable() {
        return this.isClimbing();
    }

    public boolean onCooldown() {
        return this.getCooldown() > this.minCooldown;
    }

    public boolean onHide() {
        return this.getHide() > this.minHide;
    }

    public boolean onHurt() {
        return this.hurtTime > 0;
    }

    public boolean onShow() {
        return this.getShow() > this.minShow;
    }

    @Override
    public float getVoicePitch() {
        return super.getVoicePitch() - 0.75f;
    }

    public int getCooldown() {
        return (Integer)this.entityData.get(COOLDOWN);
    }

    public int getHide() {
        return (Integer)this.entityData.get(HIDE);
    }

    public int getShow() {
        return (Integer)this.entityData.get(SHOW);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Cooldown", this.getCooldown());
        pCompound.putInt("Hide", this.getHide());
        pCompound.putInt("Show", this.getShow());
    }

    @Override
    public void aiStep() {
        int show;
        super.aiStep();
        if (this.onHide()) {
            int hide = this.getHide();
            if (hide > this.minHide) {
                this.setHide(--hide);
                this.setCooldown(this.maxCooldown);
            }
        } else if (this.onCooldown()) {
            int cooldown = this.getCooldown();
            if (cooldown > this.minCooldown) {
                this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, --cooldown, 3, false, false));
                this.setCooldown(cooldown);
                this.setShow(this.maxShow);
            }
        } else if (this.onShow() && (show = this.getShow()) > this.minShow) {
            this.setShow(--show);
        }
    }

    @Override
    public void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(CLIMBING, (Object)0);
        pBuilder.define(COOLDOWN, (Object)this.minCooldown);
        pBuilder.define(HIDE, (Object)this.minHide);
        pBuilder.define(SHOW, (Object)this.minShow);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setCooldown(pCompound.getInt("Cooldown"));
        this.setHide(pCompound.getInt("Hide"));
        this.setShow(pCompound.getInt("Show"));
    }

    public void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.001f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void setClimbing(boolean pClimbing) {
        byte b = (Byte)this.entityData.get(CLIMBING);
        b = pClimbing ? (byte)(b | 1) : (byte)(b & 0xFFFFFFFE);
        this.entityData.set(CLIMBING, (Object)b);
    }

    public void setCooldown(int pCooldown) {
        int ticks = Mth.clamp((int)pCooldown, (int)this.minCooldown, (int)this.maxCooldown);
        this.entityData.set(COOLDOWN, (Object)ticks);
    }

    public void setHide(int pCooldown) {
        int ticks = Mth.clamp((int)pCooldown, (int)this.minHide, (int)this.maxHide);
        this.entityData.set(HIDE, (Object)ticks);
    }

    public void setShow(int pCooldown) {
        int ticks = Mth.clamp((int)pCooldown, (int)this.minShow, (int)this.maxShow);
        this.entityData.set(SHOW, (Object)ticks);
    }

    @Override
    public void setSize(int pSize) {
        super.setSize(pSize);
        int size = Mth.clamp((int)pSize, (int)this.minSize, (int)this.maxSize);
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)(size * size));
    }

    public void stopMove() {
        if (this.onHide() || this.onCooldown() || this.onShow()) {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
        } else {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.125);
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            if (this.isAlive()) {
                this.idleAnimationState.startIfStopped(this.tickCount);
            } else {
                this.idleAnimationState.stop();
            }
            if (this.isClimbing() || this.isMovingOnLand()) {
                this.moveAnimationState.startIfStopped(this.tickCount);
            } else {
                this.moveAnimationState.stop();
            }
            if (this.onHide() || this.onCooldown()) {
                this.hideAnimationState.startIfStopped(this.tickCount);
                this.showAnimationState.stop();
            } else {
                this.showAnimationState.startIfStopped(this.tickCount);
                this.hideAnimationState.stop();
            }
            if (this.onHurt()) {
                this.hurtAnimationState.startIfStopped(this.tickCount);
            } else {
                this.hurtAnimationState.stop();
            }
        } else {
            this.setClimbing(this.horizontalCollision);
            this.stopMove();
        }
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.MAX_HEALTH, 16.0).add(Attributes.MOVEMENT_SPEED, 0.125);
    }

    public InteractionResult mobInteract(Player pPlayer, InteractionHand pHand) {
        ItemStack itemStack = pPlayer.getItemInHand(pHand);
        if (itemStack.getItem() == IcariaItems.HALITE_DUST.get()) {
            if (!this.level().isClientSide()) {
                pPlayer.awardStat(Stats.ITEM_USED.get((Object)IcariaItems.HALITE_DUST.get()));
                this.hurt(this.damageSources().generic(), 1.0f);
                if (this.doHide()) {
                    this.setHide(this.maxHide);
                }
                if (!pPlayer.isCreative()) {
                    itemStack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(pPlayer, pHand);
    }

    public PathNavigation createNavigation(Level pLevel) {
        return new WallClimberNavigation((Mob)this, pLevel);
    }

    public SoundEvent getAmbientSound() {
        return IcariaSoundEvents.SNULL_AMBIENT;
    }

    public SoundEvent getDeathSound() {
        return IcariaSoundEvents.SNULL_DEATH;
    }

    public SoundEvent getHurtSound(DamageSource pDamageSource) {
        return IcariaSoundEvents.SNULL_HURT;
    }
}

